/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.scopes;

import com.intellij.lang.LangBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.ui.DependenciesPanel;
import com.intellij.packageDependencies.ui.Marker;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.packageDependencies.ui.PatternDialectProvider;
import com.intellij.packageDependencies.ui.TreeModel;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.jetbrains.rider.projectView.scopes.FileSystemNode;
import com.jetbrains.rider.projectView.scopes.FileSystemPatternPackageSet;
import com.jetbrains.rider.projectView.scopes.FileSystemTreeModelBuilder;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0012\u0010\u001c\u001a\f0\u001b\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\r\u0010\u001f\u001a\u00070 \u00a2\u0006\u0002\b\u001dH\u0016J\b\u0010!\u001a\u00020\u001bH\u0016\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/projectView/scopes/FileSystemPatternProvider;", "Lcom/intellij/packageDependencies/ui/PatternDialectProvider;", "()V", "createActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "update", "Ljava/lang/Runnable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Runnable;)[Lcom/intellij/openapi/actionSystem/AnAction;", "createPackageSet", "Lcom/intellij/psi/search/scope/packageSet/PackageSet;", "node", "Lcom/intellij/packageDependencies/ui/PackageDependenciesNode;", "recursively", "", "createTreeModel", "Lcom/intellij/packageDependencies/ui/TreeModel;", "marker", "Lcom/intellij/packageDependencies/ui/Marker;", "deps", "", "Lcom/intellij/psi/PsiFile;", "settings", "Lcom/intellij/packageDependencies/ui/DependenciesPanel$DependencyPanelSettings;", "getDisplayName", "", "getHintMessage", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getIcon", "Ljavax/swing/Icon;", "getShortName", "intellij.rider"})
public final class FileSystemPatternProvider
extends PatternDialectProvider {
    @NotNull
    public String getDisplayName() {
        return RiderProjectViewBundle.Companion.message("FileSystemExplorerPane.title.file.system", new Object[0]);
    }

    @NotNull
    public String getShortName() {
        return "filesystem";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = RiderIcons.Toolwindows.ToolwindowFileSystem;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"ToolwindowFileSystem");
        return icon2;
    }

    @NotNull
    public TreeModel createTreeModel(@NotNull Project project, @NotNull Marker marker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        return this.createTreeModel(project, SetsKt.emptySet(), marker, new DependenciesPanel.DependencyPanelSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TreeModel createTreeModel(@NotNull Project project, @NotNull Set<? extends PsiFile> deps, @NotNull Marker marker, @NotNull DependenciesPanel.DependencyPanelSettings settings) {
        TreeModel treeModel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(deps, (String)"deps");
        Intrinsics.checkNotNullParameter((Object)marker, (String)"marker");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        FileSystemPatternProvider fileSystemPatternProvider = this;
        synchronized (fileSystemPatternProvider) {
            boolean bl = false;
            treeModel = new FileSystemTreeModelBuilder(project, marker, settings).build(project);
        }
        return treeModel;
    }

    @NotNull
    public AnAction[] createActions(@NotNull Project project, @NotNull Runnable update2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return AnAction.EMPTY_ARRAY;
    }

    @Nullable
    public PackageSet createPackageSet(@NotNull PackageDependenciesNode node, boolean recursively) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        FileSystemNode fileSystemNode = node instanceof FileSystemNode ? (FileSystemNode)node : null;
        if (fileSystemNode == null) {
            return null;
        }
        FileSystemNode fileSystemNode2 = fileSystemNode;
        String string = fileSystemNode2.getRelativePath();
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (fileSystemNode2.getVirtualFile().isDirectory()) {
            String string3 = ((CharSequence)string2).length() > 0 ? (recursively ? "//*" : "/*") : (recursively ? "*/" : "*");
            object = string2 + string3;
        } else {
            object = string2;
        }
        String string4 = object;
        return (PackageSet)new FileSystemPatternPackageSet(string4);
    }

    @NotNull
    public String getHintMessage() {
        String string = LangBundle.message((String)"package.pattern.provider.hint.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }
}

