/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.templateTypes;

import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdProjectTemplate;
import com.jetbrains.rider.projectView.projectTemplates.NewProjectDialogContext;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesCollector;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesSharedModel;
import com.jetbrains.rider.projectView.projectTemplates.components.ProjectTemplateLanguage;
import com.jetbrains.rider.projectView.projectTemplates.generators.TypeBasedProjectTemplateGenerator;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.PredefinedProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.UnitTestProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.Comparator;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/UnitTestProjectTemplateType;", "Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/PredefinedProjectTemplateType;", "()V", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()I", "acceptableForTemplate", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "createGenerator", "Lcom/jetbrains/rider/projectView/projectTemplates/generators/TypeBasedProjectTemplateGenerator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/rider/projectView/projectTemplates/NewProjectDialogContext;", "sharedModel", "Lcom/jetbrains/rider/projectView/projectTemplates/ProjectTemplatesSharedModel;", "intellij.rider"})
public final class UnitTestProjectTemplateType
extends PredefinedProjectTemplateType {
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;
    private final int order;

    public UnitTestProjectTemplateType() {
        Icon icon2 = RiderIcons.Templates.TemplateUnitTests;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TemplateUnitTests");
        this.icon = icon2;
        this.name = RiderProjectViewBundle.Companion.message("NewProjectDialog.UnitTestProjectTemplateType.name", new Object[0]);
        this.order = 60;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean acceptableForTemplate(@NotNull RdProjectTemplate projectTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
        return this.checkId(projectTemplate) && ExtensionsKt.hasClassification(projectTemplate, "test") && !Intrinsics.areEqual((Object)ExtensionsKt.getLanguage(projectTemplate), (Object)ProjectTemplateLanguage.Companion.getCPlusPlus());
    }

    @Override
    @NotNull
    public TypeBasedProjectTemplateGenerator createGenerator(@NotNull Lifetime lifetime2, @NotNull NewProjectDialogContext context, @NotNull ProjectTemplatesSharedModel sharedModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedModel, (String)"sharedModel");
        IOptProperty<Set<RdProjectTemplate>> iOptProperty = this.getProjectTemplates();
        return new TypeBasedProjectTemplateGenerator(lifetime2, context, sharedModel, iOptProperty){
            @NotNull
            private final String defaultName;
            @NotNull
            private final ProjectTemplatesCollector.ProjectType projectType;
            {
                this.defaultName = "TestProject1";
                this.projectType = ProjectTemplatesCollector.ProjectType.UnitTest;
            }

            @NotNull
            public String getDefaultName() {
                return this.defaultName;
            }

            @NotNull
            protected ProjectTemplatesCollector.ProjectType getProjectType() {
                return this.projectType;
            }

            @NotNull
            protected String getType(@NotNull RdProjectTemplate template2) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                return ((Object)StringsKt.trim((CharSequence)StringsKt.removeSuffix((String)super.getType(template2), (CharSequence)"Test Project"))).toString();
            }

            @NotNull
            protected Comparator<String> typeComparator() {
                Function1[] function1Array = new Function1[]{createGenerator.typeComparator.1.INSTANCE, createGenerator.typeComparator.2.INSTANCE};
                return ComparisonsKt.compareBy((Function1[])function1Array);
            }
        };
    }
}

