/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.projectTemplates.templateTypes;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rider.model.RdProjectTemplate;
import com.jetbrains.rider.projectView.projectTemplates.NewProjectDialogContext;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesCollector;
import com.jetbrains.rider.projectView.projectTemplates.ProjectTemplatesSharedModel;
import com.jetbrains.rider.projectView.projectTemplates.generators.TypeListBasedProjectTemplateGenerator;
import com.jetbrains.rider.projectView.projectTemplates.templateTypes.PredefinedProjectTemplateType;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import icons.RiderIcons;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/DesktopProjectTemplateType;", "Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/PredefinedProjectTemplateType;", "()V", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "name", "", "getName", "()Ljava/lang/String;", "order", "", "getOrder", "()I", "shouldHide", "", "getShouldHide", "()Z", "acceptableForTemplate", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "createGenerator", "Lcom/jetbrains/rider/projectView/projectTemplates/generators/TypeListBasedProjectTemplateGenerator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "context", "Lcom/jetbrains/rider/projectView/projectTemplates/NewProjectDialogContext;", "sharedModel", "Lcom/jetbrains/rider/projectView/projectTemplates/ProjectTemplatesSharedModel;", "Companion", "intellij.rider"})
public final class DesktopProjectTemplateType
extends PredefinedProjectTemplateType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Icon icon;
    @NotNull
    private final String name;
    private final int order;

    public DesktopProjectTemplateType() {
        Icon icon2 = RiderIcons.Templates.TemplateDesktop;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"TemplateDesktop");
        this.icon = icon2;
        this.name = RiderProjectViewBundle.Companion.message("NewProjectDialog.DesktopProjectTemplateType.name", new Object[0]);
        this.order = 30;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean getShouldHide() {
        return !SystemInfo.isWindows;
    }

    @Override
    public boolean acceptableForTemplate(@NotNull RdProjectTemplate projectTemplate) {
        Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
        return this.checkId(projectTemplate) && Companion.acceptableForTemplateInternal$intellij_rider(projectTemplate);
    }

    @Override
    @NotNull
    public TypeListBasedProjectTemplateGenerator createGenerator(@NotNull Lifetime lifetime2, @NotNull NewProjectDialogContext context, @NotNull ProjectTemplatesSharedModel sharedModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sharedModel, (String)"sharedModel");
        IOptProperty<Set<RdProjectTemplate>> iOptProperty = this.getProjectTemplates();
        return new TypeListBasedProjectTemplateGenerator(lifetime2, context, sharedModel, iOptProperty){
            @NotNull
            private final String defaultName;
            @NotNull
            private final ProjectTemplatesCollector.ProjectType projectType;
            {
                this.defaultName = "DesktopApp1";
                this.projectType = ProjectTemplatesCollector.ProjectType.Desktop;
            }

            @NotNull
            public String getDefaultName() {
                return this.defaultName;
            }

            @NotNull
            protected ProjectTemplatesCollector.ProjectType getProjectType() {
                return this.projectType;
            }

            @NotNull
            public List<TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon> getPredefinedTypes() {
                Object[] objectArray = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon[7];
                Icon icon2 = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"FormsApp");
                objectArray[0] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms App", icon2, false, 4, null);
                Icon icon3 = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"FormsApp");
                objectArray[1] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms Class Library", icon3, false, 4, null);
                Icon icon4 = RiderIcons.Templates.FormsApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"FormsApp");
                objectArray[2] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("Windows Forms Control Library", icon4, false, 4, null);
                Icon icon5 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon5, (String)"WpfApp");
                objectArray[3] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Application", icon5, false, 4, null);
                Icon icon6 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon6, (String)"WpfApp");
                objectArray[4] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Class Library", icon6, false, 4, null);
                Icon icon7 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon7, (String)"WpfApp");
                objectArray[5] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF Custom Control Library", icon7, false, 4, null);
                Icon icon8 = RiderIcons.Templates.WpfApp;
                Intrinsics.checkNotNullExpressionValue((Object)icon8, (String)"WpfApp");
                objectArray[6] = new TypeListBasedProjectTemplateGenerator.TemplateTypeWithIcon("WPF User Control Library", icon8, false, 4, null);
                return CollectionsKt.listOf((Object[])objectArray);
            }

            @NotNull
            public String getType(@NotNull RdProjectTemplate template2) {
                Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
                return StringsKt.replace$default((String)template2.getName(), (String)"library", (String)"Library", (boolean)false, (int)4, null);
            }
        };
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/projectView/projectTemplates/templateTypes/DesktopProjectTemplateType$Companion;", "", "()V", "acceptableForTemplateInternal", "", "projectTemplate", "Lcom/jetbrains/rider/model/RdProjectTemplate;", "acceptableForTemplateInternal$intellij_rider", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean acceptableForTemplateInternal$intellij_rider(@NotNull RdProjectTemplate projectTemplate) {
            Intrinsics.checkNotNullParameter((Object)projectTemplate, (String)"projectTemplate");
            return ExtensionsKt.hasClassification(projectTemplate, "desktop") || ExtensionsKt.hasClassification(projectTemplate, "WinForms") || ExtensionsKt.hasClassification(projectTemplate, "WPF");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

