/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.scaffolding;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.RdAddScaffoldedItemRequest;
import com.jetbrains.rd.ide.model.RdAddScaffoldedItemResult;
import com.jetbrains.rd.ide.model.ScaffoldedItemKind;
import com.jetbrains.rd.ide.model.ScaffoldedItemStatus;
import com.jetbrains.rd.ide.model.ScaffoldingItemModel;
import com.jetbrains.rd.ide.model.ScaffoldingItemModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFolderDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.actions.ProjectViewActionBase;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldItemNameValidator;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldingDialogWithTemplates;
import com.jetbrains.rider.projectView.actions.scaffolding.ScaffoldingTemplate;
import com.jetbrains.rider.projectView.actions.scaffolding.fus.ScaffoldItemFUSLogger;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import com.jetbrains.rider.util.idea.ExtensionsKt;
import java.awt.event.InputEvent;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J&\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00042\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u001bH\u0002J6\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020!2\b\b\u0001\u0010\r\u001a\u00020\f2\b\b\u0001\u0010\"\u001a\u00020\fH\u0002\u00a8\u0006%"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction;", "Lcom/jetbrains/rider/projectView/actions/ProjectViewActionBase;", "()V", "actionPerformedInternal", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "project", "Lcom/intellij/openapi/project/Project;", "execute", "node", "template", "", "itemName", "getItemInternal", "j", "Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$ScaffoldingRequestData;", "j", "", "descriptor", "Lcom/jetbrains/rider/model/RdProjectDescriptor;", "j", "path", "Ljava/nio/file/Path;", "j", "pathToOpen", "pathsToRefresh", "", "j", "j", "Lcom/jetbrains/rd/ide/model/RdAddScaffoldedItemResult;", "targetNode", "itemKind", "Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "taskName", "Companion", "ScaffoldingRequestData", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAddNewScaffoldedItemAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddNewScaffoldedItemAction.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,214:1\n1549#2:215\n1620#2,3:216\n37#3,2:219\n13#4:221\n13#5:222\n*S KotlinDebug\n*F\n+ 1 AddNewScaffoldedItemAction.kt\ncom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction\n*L\n204#1:215\n204#1:216,3\n204#1:219,2\n42#1:221\n42#1:222\n*E\n"})
public final class AddNewScaffoldedItemAction
extends ProjectViewActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    public AddNewScaffoldedItemAction() {
        super(false, 1, null);
    }

    @Override
    @Nullable
    protected ProjectModelEntity getItemInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
        if (rdProjectModelItemDescriptor instanceof RdProjectDescriptor) {
            object = (RdProjectDescriptor)rdProjectModelItemDescriptor;
        } else if (rdProjectModelItemDescriptor instanceof RdProjectFolderDescriptor) {
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor2;
            ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
            Object object2 = rdProjectModelItemDescriptor2 = projectModelEntity != null ? projectModelEntity.getDescriptor() : null;
            object = rdProjectModelItemDescriptor2 instanceof RdProjectDescriptor ? (RdProjectDescriptor)rdProjectModelItemDescriptor2 : null;
        } else {
            object = null;
        }
        if (object == null) {
            return null;
        }
        RdProjectDescriptor rdProjectDescriptor = object;
        if (!this.j(rdProjectDescriptor)) {
            return null;
        }
        return entity;
    }

    @Override
    protected void actionPerformedInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationKt.getApplication().assertIsDispatchThread();
        ApplicationKt.getApplication().saveAll();
        VirtualFile virtualFile2 = ProjectModelEntityExtensionsKt.getVirtualFileAsParent((ProjectModelEntity)entity);
        if (virtualFile2 == null) {
            throw new IllegalStateException(("Unable to get parent directory for item: " + ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)entity, (Project)project)).toString());
        }
        VirtualFile virtualFile3 = virtualFile2;
        ScaffoldingDialogWithTemplates scaffoldingDialogWithTemplates = new ScaffoldingDialogWithTemplates(entity, virtualFile3);
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)((Object)scaffoldingDialogWithTemplates), (JComponent)scaffoldingDialogWithTemplates.getNameField()).setTitle(RiderProjectViewBundle.Companion.message("popup.scaffolding.new_item.title", new Object[0])).setResizable(false).setModalContext(true).setFocusable(true).setRequestFocus(true).setMovable(true).setBelongsToGlobalPopupStack(true).setCancelKeyEnabled(true).setCancelOnWindowDeactivation(false).setCancelOnClickOutside(true).addUserData((Object)"SIMPLE_WINDOW").createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        JBPopup jBPopup2 = jBPopup;
        scaffoldingDialogWithTemplates.setApplyAction(arg_0 -> AddNewScaffoldedItemAction.j((Function1)new Function1<InputEvent, Unit>(scaffoldingDialogWithTemplates, jBPopup2, this, project, entity){
            final /* synthetic */ ScaffoldingDialogWithTemplates $contentPanel;
            final /* synthetic */ JBPopup $popup;
            final /* synthetic */ AddNewScaffoldedItemAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ ProjectModelEntity $entity;
            {
                this.$contentPanel = $contentPanel;
                this.$popup = $popup;
                this.this$0 = $receiver;
                this.$project = $project;
                this.$entity = $entity;
                super(1);
            }

            public final void invoke(InputEvent event) {
                String string = this.$contentPanel.getEnteredName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getEnteredName(...)");
                String string2 = string;
                String string3 = this.$contentPanel.getSelectedTemplate();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getSelectedTemplate(...)");
                String string4 = string3;
                ScaffoldItemNameValidator scaffoldItemNameValidator = this.$contentPanel.getValidator();
                boolean bl = scaffoldItemNameValidator.checkInput(string2);
                if (bl) {
                    this.$popup.closeOk(event);
                    this.this$0.execute(this.$project, this.$entity, string4, string2);
                } else {
                    this.$contentPanel.setError(scaffoldItemNameValidator.getErrorText(string2));
                }
            }
        }, arg_0));
        Disposer.register((Disposable)((Disposable)jBPopup2), (Disposable)((Disposable)scaffoldingDialogWithTemplates));
        jBPopup2.showCenteredInCurrentWindow(project);
    }

    private final ScaffoldingRequestData j(String string) {
        String string2;
        ScaffoldedItemKind scaffoldedItemKind = ScaffoldingTemplate.INSTANCE.templateNameToKind(string);
        String string3 = string;
        if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcAreaName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_area", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerEmptyName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_empty", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerReadWriteActionsName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_read_write_actions", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcControllerEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_controller_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerEmptyName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_empty", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerReadWriteActionsName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_read_write_actions", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateApiControllerEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.api_controller_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateMvcViewName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.mvc_view", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageEntityFrameworkName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page_entity_framework", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateRazorPageEntityFrameworkCRUDName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.razor_page_entity_framework_crud", var5_4);
        } else if (Intrinsics.areEqual((Object)string3, (Object)ScaffoldingTemplate.INSTANCE.getTemplateIdentityName())) {
            var5_4 = new Object[]{string};
            string2 = RiderProjectViewBundle.Companion.message("progress.scaffolding.add.identity", var5_4);
        } else {
            throw new IllegalArgumentException("Unable to find Scaffolding kind for template with name '" + string + "'");
        }
        String string4 = string2;
        return new ScaffoldingRequestData(scaffoldedItemKind, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull Project project, @NotNull ProjectModelEntity node, @NotNull String template2, @NotNull String itemName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)template2, (String)"template");
        Intrinsics.checkNotNullParameter((Object)itemName, (String)"itemName");
        ProjectModelEntity projectModelEntity = ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)node) ? node.getParentEntity() : node;
        if (projectModelEntity == null) {
            throw new IllegalStateException("Unable to get target Project Model node".toString());
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        ScaffoldingRequestData scaffoldingRequestData = this.j(template2);
        try {
            RdAddScaffoldedItemResult rdAddScaffoldedItemResult = this.j(project, projectModelEntity2, scaffoldingRequestData.getItemKind(), itemName, scaffoldingRequestData.getTaskName());
            if (rdAddScaffoldedItemResult != null && rdAddScaffoldedItemResult.getStatus() == ScaffoldedItemStatus.Succeeded) {
                this.j(project, rdAddScaffoldedItemResult.getPathToOpen(), rdAddScaffoldedItemResult.getPathsToRefresh());
            }
        }
        catch (CancellationException cancellationException) {
            logger.trace("Cancel scaffolding item task for template '" + template2 + "', item '" + itemName + "'.");
            ScaffoldItemFUSLogger.INSTANCE.onScaffoldingCanceled(project, ScaffoldingTemplate.INSTANCE.templateNameToKind(template2));
        }
        finally {
            ScaffoldingItemModel scaffoldingItemModel = ScaffoldingItemModel_PregeneratedKt.getScaffoldingItemModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
            scaffoldingItemModel.getScaffoldingGeneratorSession().getInitialized().fire((Object)false);
        }
    }

    private final boolean j(RdProjectDescriptor rdProjectDescriptor) {
        return rdProjectDescriptor.isDotNetCore() && rdProjectDescriptor.getSpecificType() == RdProjectType.Web;
    }

    private final RdAddScaffoldedItemResult j(Project project, ProjectModelEntity projectModelEntity, ScaffoldedItemKind scaffoldedItemKind, @NlsSafe String string, @Nls String string2) {
        ScaffoldingItemModel scaffoldingItemModel = ScaffoldingItemModel_PregeneratedKt.getScaffoldingItemModel((Solution)SolutionHostExtensionsKt.getSolution((Project)project));
        Integer n2 = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)project);
        if (n2 == null) {
            throw new IllegalStateException("Unable to find target node Id for Scaffolding action.".toString());
        }
        int n3 = n2;
        ScaffoldItemFUSLogger.INSTANCE.onSelectScaffoldingTemplate(project, scaffoldedItemKind);
        logger.info("Start waiting scaffolding action " + string + ".");
        RdAddScaffoldedItemResult rdAddScaffoldedItemResult = (RdAddScaffoldedItemResult)ExtensionsKt.runCommandUnderProgress$default((IRdCall)((IRdCall)scaffoldingItemModel.getAddScaffoldedItem()), (Object)new RdAddScaffoldedItemRequest(n3, scaffoldedItemKind, string), (Project)project, (String)string2, (boolean)true, (boolean)false, (boolean)false, (int)48, null);
        logger.info("Finish waiting scaffolding action " + string + ".");
        if (rdAddScaffoldedItemResult != null) {
            ScaffoldItemFUSLogger.INSTANCE.onGetScaffoldingResult(project, scaffoldedItemKind, rdAddScaffoldedItemResult.getStatus());
        }
        return rdAddScaffoldedItemResult;
    }

    private final void j(Project project, String string, List<String> list2) {
        if (!((Collection)list2).isEmpty()) {
            this.j(list2);
        }
        if (string != null) {
            Path path = Path.of(string, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            this.j(project, path);
        }
    }

    private final void j(List<String> list2) {
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            String string = (String)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            collection2.add(DocumentUtilKt.toIOFile((String)string));
        }
        iterable = (List)collection;
        bl = false;
        iterable2 = iterable;
        File[] fileArray = iterable2.toArray(new File[0]);
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (File[])Arrays.copyOf(fileArray, fileArray.length));
    }

    private final void j(Project project, Path path) {
        VirtualFile virtualFile2 = VfsUtil.findFile((Path)path, (boolean)true);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        SolutionViewUtilsKt.navigateToSolutionView$default(project, virtualFile3, false, 2, null);
        FileEditorManager.getInstance((Project)project).openFile(virtualFile3, true);
    }

    private static final void j(Function1 function1, Object object) {
        Intrinsics.checkNotNullParameter((Object)function1, (String)"$tmp0");
        function1.invoke(object);
    }

    static {
        boolean bl = false;
        boolean bl2 = false;
        Logger logger2 = Logger.getInstance(AddNewScaffoldedItemAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        logger = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0003\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/projectView/actions/scaffolding/AddNewScaffoldedItemAction$ScaffoldingRequestData;", "", "itemKind", "Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "taskName", "", "(Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;Ljava/lang/String;)V", "getItemKind", "()Lcom/jetbrains/rd/ide/model/ScaffoldedItemKind;", "getTaskName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class ScaffoldingRequestData {
        @NotNull
        private final ScaffoldedItemKind itemKind;
        @NotNull
        private final String taskName;

        public ScaffoldingRequestData(@NotNull ScaffoldedItemKind itemKind, @Nls @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)itemKind, (String)"itemKind");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.itemKind = itemKind;
            this.taskName = taskName;
        }

        @NotNull
        public final ScaffoldedItemKind getItemKind() {
            return this.itemKind;
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        @NotNull
        public final ScaffoldedItemKind component1() {
            return this.itemKind;
        }

        @NotNull
        public final String component2() {
            return this.taskName;
        }

        @NotNull
        public final ScaffoldingRequestData copy(@NotNull ScaffoldedItemKind itemKind, @Nls @NotNull String taskName) {
            Intrinsics.checkNotNullParameter((Object)itemKind, (String)"itemKind");
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new ScaffoldingRequestData(itemKind, taskName);
        }

        public static /* synthetic */ ScaffoldingRequestData copy$default(ScaffoldingRequestData scaffoldingRequestData, ScaffoldedItemKind scaffoldedItemKind, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                scaffoldedItemKind = scaffoldingRequestData.itemKind;
            }
            if ((n2 & 2) != 0) {
                string = scaffoldingRequestData.taskName;
            }
            return scaffoldingRequestData.copy(scaffoldedItemKind, string);
        }

        @NotNull
        public String toString() {
            return "ScaffoldingRequestData(itemKind=" + this.itemKind + ", taskName=" + this.taskName + ")";
        }

        public int hashCode() {
            int n2 = this.itemKind.hashCode();
            n2 = n2 * 31 + this.taskName.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ScaffoldingRequestData)) {
                return false;
            }
            ScaffoldingRequestData scaffoldingRequestData = (ScaffoldingRequestData)other;
            if (this.itemKind != scaffoldingRequestData.itemKind) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.taskName, (Object)scaffoldingRequestData.taskName);
        }
    }
}

