/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.references;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.EsprojFileType;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.MsbuildFileType;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.ShprojFileType;
import com.jetbrains.rider.projectView.actions.ProjectViewActionBase;
import com.jetbrains.rider.projectView.actions.references.dialog.AddReferenceDialog;
import com.jetbrains.rider.projectView.views.solutionExplorer.SolutionExplorerCustomization;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u001e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/projectView/actions/references/AddReferenceAction;", "Lcom/jetbrains/rider/projectView/actions/ProjectViewActionBase;", "()V", "actionPerformedInternal", "", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "project", "Lcom/intellij/openapi/project/Project;", "getItemInternal", "updatePresentation", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "entities", "", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAddReferenceAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddReferenceAction.kt\ncom/jetbrains/rider/projectView/actions/references/AddReferenceAction\n+ 2 ModalUiUtils.kt\ncom/jetbrains/rdclient/protocol/ModalUiUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,49:1\n9#2,14:50\n12474#3,2:64\n*S KotlinDebug\n*F\n+ 1 AddReferenceAction.kt\ncom/jetbrains/rider/projectView/actions/references/AddReferenceAction\n*L\n29#1:50,14\n42#1:64,2\n*E\n"})
public final class AddReferenceAction
extends ProjectViewActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final HashSet<MsbuildFileType> ignoredProjects;

    public AddReferenceAction() {
        super(false, 1, null);
    }

    @Override
    protected void updatePresentation(@NotNull AnActionEvent e, @NotNull List<? extends ProjectModelEntity> entities2) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(entities2, (String)"entities");
        if (Intrinsics.areEqual((Object)e.getPlace(), (Object)"ProjectViewPopup")) {
            e.getPresentation().setText(RiderActionsBundle.Companion.message("action.AddReferenceAction.solution.view.text", new Object[0]));
        }
    }

    @Override
    protected void actionPerformedInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AddReferenceDialog addReferenceDialog = new AddReferenceDialog(project, entity);
        DialogWrapper dialogWrapper = addReferenceDialog;
        boolean bl = false;
        try {
            Container container = dialogWrapper.getWindow();
            if (container == null && (container = dialogWrapper.getRootPane()) == null) {
                throw new AssertionError((Object)"An attempt to show a dialog which doesn't provide any component for modality state");
            }
            Window window = container;
            PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
            Component component2 = window;
            Disposable disposable = dialogWrapper.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            permittedModalitiesImpl.allowPumpProtocolForComponent(component2, disposable);
            AddReferenceDialog addReferenceDialog2 = (AddReferenceDialog)dialogWrapper;
            boolean bl2 = false;
            addReferenceDialog.show();
        }
        catch (Throwable throwable) {
            Disposer.dispose((Disposable)dialogWrapper.getDisposable());
            throw throwable;
        }
    }

    @Override
    @Nullable
    protected ProjectModelEntity getItemInternal(@NotNull ProjectModelEntity entity, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity) || ProjectModelEntityExtensionsKt.isDependenciesFolder((ProjectModelEntity)entity) || ProjectModelEntityExtensionsKt.isTargetFrameworkFolder((ProjectModelEntity)entity) || ProjectModelEntityExtensionsKt.isAssembliesFolder((ProjectModelEntity)entity) || ProjectModelEntityExtensionsKt.isProjectsFolder((ProjectModelEntity)entity)) {
            boolean bl;
            ProjectModelEntity projectModelEntity;
            block6: {
                SolutionExplorerCustomization[] solutionExplorerCustomizationArray;
                ProjectModelEntity projectModelEntity2 = ProjectModelEntityExtensionsKt.containingProjectEntity((ProjectModelEntity)entity);
                if (projectModelEntity2 == null) {
                    return null;
                }
                projectModelEntity = projectModelEntity2;
                VirtualFileUrl virtualFileUrl = projectModelEntity.getUrl();
                if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
                    return null;
                }
                VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
                if (CollectionsKt.contains((Iterable)ignoredProjects, (Object)virtualFileUrl2.getFileType())) {
                    return null;
                }
                SolutionExplorerCustomization[] solutionExplorerCustomizationArray2 = solutionExplorerCustomizationArray = SolutionExplorerCustomization.Companion.getExtensions(project);
                boolean bl2 = false;
                int n2 = solutionExplorerCustomizationArray2.length;
                for (int k = 0; k < n2; ++k) {
                    SolutionExplorerCustomization solutionExplorerCustomization;
                    SolutionExplorerCustomization solutionExplorerCustomization2 = solutionExplorerCustomization = solutionExplorerCustomizationArray2[k];
                    boolean bl3 = false;
                    if (!(!solutionExplorerCustomization2.supportReferenceModifications(projectModelEntity))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                return null;
            }
            return projectModelEntity;
        }
        return null;
    }

    static {
        MsbuildFileType[] msbuildFileTypeArray = new MsbuildFileType[]{ShprojFileType.INSTANCE, EsprojFileType.INSTANCE};
        ignoredProjects = SetsKt.hashSetOf((Object[])msbuildFileTypeArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/projectView/actions/references/AddReferenceAction$Companion;", "", "()V", "ignoredProjects", "Ljava/util/HashSet;", "Lcom/jetbrains/rider/ideaInterop/fileTypes/msbuild/MsbuildFileType;", "Lkotlin/collections/HashSet;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

