/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions.properties.configurations.table;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.jetbrains.rd.ide.model.RdConfigurationAndPlatform;
import com.jetbrains.rd.util.reactive.IMutableViewableMap;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdEditConfigurationProjectInfo;
import com.jetbrains.rider.model.RdEditConfigurationTableRow;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsDialog;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditConfigurationsAndPlatformsViewModel;
import com.jetbrains.rider.projectView.actions.properties.configurations.EditSolutionPropertiesContext;
import com.jetbrains.rider.projectView.actions.properties.configurations.ExtensionsKt;
import com.jetbrains.rider.projectView.actions.properties.configurations.table.ConfigurationAndPlatformRenderer;
import com.jetbrains.rider.projectView.actions.properties.configurations.table.ConfigurationRowModel;
import com.jetbrains.rider.ui.components.table.TablePopupCellEditor;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u000f\u0010\u0011B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor;", "Lcom/jetbrains/rider/ui/components/table/TablePopupCellEditor;", "context", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditSolutionPropertiesContext;", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditSolutionPropertiesContext;)V", "createActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "table", "Ljavax/swing/JTable;", "value", "", "createComponent", "Ljavax/swing/JComponent;", "isSelected", "", "EditAction", "RemoveAction", "SelectAction", "intellij.rider"})
public final class ConfigurationAndPlatformEditor
extends TablePopupCellEditor {
    @Nullable
    private final EditSolutionPropertiesContext context;

    public ConfigurationAndPlatformEditor(@Nullable EditSolutionPropertiesContext context) {
        this.context = context;
    }

    @Override
    @NotNull
    public DefaultActionGroup createActionGroup(@NotNull JTable table2, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ConfigurationRowModel configurationRowModel = (ConfigurationRowModel)value;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new EditAction(configurationRowModel, table2));
        defaultActionGroup.addSeparator();
        Set<RdConfigurationAndPlatform> set = configurationRowModel.getProjectConfigurations();
        for (RdConfigurationAndPlatform rdConfigurationAndPlatform : set) {
            defaultActionGroup.add((AnAction)new SelectAction(rdConfigurationAndPlatform, configurationRowModel, table2));
        }
        defaultActionGroup.addSeparator();
        defaultActionGroup.add((AnAction)new RemoveAction(configurationRowModel, table2));
        return defaultActionGroup;
    }

    @Override
    @NotNull
    public JComponent createComponent(@NotNull JTable table2, @NotNull Object value, boolean isSelected) {
        Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return (JComponent)ConfigurationAndPlatformRenderer.Companion.createComboBoxLabel((ConfigurationRowModel)value, this.context);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "MyViewModel", "intellij.rider"})
    public static final class EditAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public EditAction(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            super(RiderActionsBundle.Companion.message("ConfigurationAndPlatformRenderer.action.edit.text", new Object[0]), RiderActionsBundle.Companion.message("ConfigurationAndPlatformRenderer.action.edit.project.configurations.platforms.description", new Object[0]), AllIcons.Actions.Edit);
            this.model = model2;
            this.table = table2;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabledAndVisible(ExtensionsKt.isEditable(this.model));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            Project project2 = project;
            EditConfigurationsAndPlatformsDialog editConfigurationsAndPlatformsDialog = new EditConfigurationsAndPlatformsDialog(project2, this.model.getLifetime(), new MyViewModel(this.model, this.table));
            editConfigurationsAndPlatformsDialog.show();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001d\u001a\u00020\bH\u0014J\b\u0010\u001e\u001a\u00020\u0014H\u0016J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\bH\u0014R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$EditAction$MyViewModel;", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/EditConfigurationsAndPlatformsViewModel;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "affectAllProjects", "", "getAffectAllProjects", "()Z", "allValues", "", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "getAllValues", "()Ljava/util/Set;", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "predefinedPlatforms", "", "", "getPredefinedPlatforms", "()Ljava/lang/Iterable;", "getTable", "()Ljavax/swing/JTable;", "addInternal", "", "new", "base", "forProjects", "getDialogTitle", "removeInternal", "old", "intellij.rider"})
        private static final class MyViewModel
        extends EditConfigurationsAndPlatformsViewModel {
            @NotNull
            private final ConfigurationRowModel model;
            @NotNull
            private final JTable table;

            public MyViewModel(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
                Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.model = model2;
                this.table = table2;
                this.getChanged().advise(this.model.getLifetime(), (Function1)new Function1<Unit, Unit>(){

                    public final void invoke(@NotNull Unit it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        TableModel tableModel2 = this.getTable().getModel();
                        Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
                        ((AbstractTableModel)tableModel2).fireTableDataChanged();
                    }
                });
            }

            @NotNull
            public final ConfigurationRowModel getModel() {
                return this.model;
            }

            @NotNull
            public final JTable getTable() {
                return this.table;
            }

            @Override
            public boolean getAffectAllProjects() {
                return false;
            }

            @Override
            @NotNull
            public Set<RdConfigurationAndPlatform> getAllValues() {
                return this.model.getProjectConfigurations();
            }

            @Override
            @NotNull
            public Iterable<String> getPredefinedPlatforms() {
                Object[] objectArray = new String[]{"AnyCPU"};
                return CollectionsKt.arrayListOf((Object[])objectArray);
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                Object[] objectArray = new Object[]{this.model.getProjectName()};
                return RiderProjectViewBundle.Companion.message("ConfigurationAndPlatformEditor.dialog.title", objectArray);
            }

            @Override
            protected void addInternal(@NotNull RdConfigurationAndPlatform rdConfigurationAndPlatform, @Nullable RdConfigurationAndPlatform base, boolean forProjects) {
                RdEditConfigurationTableRow rdEditConfigurationTableRow;
                Intrinsics.checkNotNullParameter((Object)rdConfigurationAndPlatform, (String)"new");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> iMutableViewableMap = this.model.getProjectConfigurationsMap();
                ((Map)iMutableViewableMap).put(rdConfigurationAndPlatform, new RdEditConfigurationProjectInfo(base));
                RdEditConfigurationTableRow rdEditConfigurationTableRow2 = rdEditConfigurationTableRow = this.model.getRow();
                Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow2);
                rdEditConfigurationTableRow2.getConfigurationAndPlatform().set((Object)rdConfigurationAndPlatform);
            }

            @Override
            protected void removeInternal(@NotNull RdConfigurationAndPlatform old, boolean forProjects) {
                Intrinsics.checkNotNullParameter((Object)old, (String)"old");
                IMutableViewableMap<RdConfigurationAndPlatform, RdEditConfigurationProjectInfo> iMutableViewableMap = this.model.getProjectConfigurationsMap();
                iMutableViewableMap.remove((Object)old);
                RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
                Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
                RdEditConfigurationTableRow rdEditConfigurationTableRow2 = rdEditConfigurationTableRow;
                if (Intrinsics.areEqual((Object)rdEditConfigurationTableRow2.getConfigurationAndPlatform().getValue(), (Object)old)) {
                    rdEditConfigurationTableRow2.getConfigurationAndPlatform().set(CollectionsKt.firstOrNull((Iterable)iMutableViewableMap.keySet()));
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$RemoveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
    public static final class RemoveAction
    extends AnAction {
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public RemoveAction(@NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            Object[] objectArray = new Object[]{ExtensionsKt.present((RdConfigurationAndPlatform)model2.getContent().getConfigurationAndPlatform().getValue())};
            super(RiderActionsBundle.Companion.message("action.remove.text", new Object[0]), RiderActionsBundle.Companion.message("ConfigurationAndPlatformEditor.action.dont.specify.project.configuration", objectArray), AllIcons.General.Remove);
            this.model = model2;
            this.table = table2;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            boolean bl = rdEditConfigurationTableRow.getConfigurationAndPlatform().getValue() != null;
            e.getPresentation().setEnabledAndVisible(bl && ExtensionsKt.isEditable(this.model));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            rdEditConfigurationTableRow.getConfigurationAndPlatform().set(null);
            TableModel tableModel2 = this.table.getModel();
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationAndPlatformEditor$SelectAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "projectConfiguration", "Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "model", "Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "table", "Ljavax/swing/JTable;", "(Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;Ljavax/swing/JTable;)V", "getModel", "()Lcom/jetbrains/rider/projectView/actions/properties/configurations/table/ConfigurationRowModel;", "getProjectConfiguration", "()Lcom/jetbrains/rd/ide/model/RdConfigurationAndPlatform;", "getTable", "()Ljavax/swing/JTable;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
    public static final class SelectAction
    extends AnAction {
        @NotNull
        private final RdConfigurationAndPlatform projectConfiguration;
        @NotNull
        private final ConfigurationRowModel model;
        @NotNull
        private final JTable table;

        public SelectAction(@NotNull RdConfigurationAndPlatform projectConfiguration, @NotNull ConfigurationRowModel model2, @NotNull JTable table2) {
            Intrinsics.checkNotNullParameter((Object)projectConfiguration, (String)"projectConfiguration");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
            this.projectConfiguration = projectConfiguration;
            this.model = model2;
            this.table = table2;
        }

        @NotNull
        public final RdConfigurationAndPlatform getProjectConfiguration() {
            return this.projectConfiguration;
        }

        @NotNull
        public final ConfigurationRowModel getModel() {
            return this.model;
        }

        @NotNull
        public final JTable getTable() {
            return this.table;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
            ExtensionsKt.present(this.projectConfiguration, presentation2);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RdEditConfigurationTableRow rdEditConfigurationTableRow = this.model.getRow();
            Intrinsics.checkNotNull((Object)rdEditConfigurationTableRow);
            rdEditConfigurationTableRow.getConfigurationAndPlatform().set((Object)this.projectConfiguration);
            TableModel tableModel2 = this.table.getModel();
            Intrinsics.checkNotNull((Object)tableModel2, (String)"null cannot be cast to non-null type javax.swing.table.AbstractTableModel");
            ((AbstractTableModel)tableModel2).fireTableDataChanged();
        }
    }
}

