/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.projectView.actions;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.projectView.views.SolutionViewEntityOwner;
import com.jetbrains.rider.projectView.views.SolutionViewUtilsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.usages.RiderProjectViewBundle;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/projectView/actions/RevealBaseDirectoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "j", "Lcom/intellij/openapi/vfs/VirtualFile;", "update", "intellij.rider"})
public final class RevealBaseDirectoryAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        String string;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile2 = this.j(e);
        if (virtualFile2 == null || !RevealFileAction.isSupported()) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        String string2 = virtualFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String string3 = string2;
        String string4 = RevealFileAction.getFileManagerName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getFileManagerName(...)");
        String string5 = string4;
        Presentation presentation2 = e.getPresentation();
        if (SystemInfo.isMac) {
            Object[] objectArray = new Object[]{string3};
            string = RiderProjectViewBundle.Companion.message("RevealBaseDirectoryAction.name.mac", objectArray);
        } else {
            Object[] objectArray = new Object[]{string3, string5};
            string = RiderProjectViewBundle.Companion.message("RevealBaseDirectoryAction.name.other", objectArray);
        }
        presentation2.setText(string);
        e.getPresentation().setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile2 = this.j(e);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)virtualFile3));
    }

    private final VirtualFile j(AnActionEvent anActionEvent) {
        DataContext dataContext = anActionEvent.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = CollectionsKt.singleOrNull(SolutionViewUtilsKt.getSolutionViewNodes(dataContext));
        SolutionViewEntityOwner solutionViewEntityOwner = object instanceof SolutionViewEntityOwner ? (SolutionViewEntityOwner)object : null;
        if (solutionViewEntityOwner == null) {
            return null;
        }
        SolutionViewEntityOwner solutionViewEntityOwner2 = solutionViewEntityOwner;
        ProjectModelEntity projectModelEntity = solutionViewEntityOwner2.getEntity();
        Object object2 = projectModelEntity != null ? projectModelEntity.getDescriptor() : null;
        Object object3 = object2 instanceof RdProjectDescriptor ? (RdProjectDescriptor)object2 : null;
        if (object3 == null || (object3 = object3.getBaseDirectory()) == null) {
            return null;
        }
        Object object4 = object3;
        return VfsUtil.findFileByIoFile((File)new File((String)object4), (boolean)false);
    }
}

