/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectState;
import com.jetbrains.rider.model.RdSolutionDescriptor;
import com.jetbrains.rider.model.RdSolutionState;
import com.jetbrains.rider.model.RdUnloadProjectDescriptor;
import com.jetbrains.rider.model.RdUnloadProjectState;
import com.jetbrains.rider.problemsView.RiderProblemsViewBundle;
import com.jetbrains.rider.problemsView.fus.RiderProblemsViewStatisticsCollector;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewIndicationService;
import com.jetbrains.rider.problemsView.views.RiderProblemsViewToolwindowUtils;
import com.jetbrains.rider.projectView.notifications.SolutionLoadNotification;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/problemsView/notifications/ProblemsViewToolWindowNotification;", "Lcom/jetbrains/rider/projectView/notifications/SolutionLoadNotification;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "settingName", "", "getSettingName", "()Ljava/lang/String;", "createNotification", "Lcom/intellij/notification/Notification;", "Companion", "intellij.rider"})
public final class ProblemsViewToolWindowNotification
extends SolutionLoadNotification {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String openBalloonAction = "open";
    @NotNull
    public static final String disableBalloonAction = "disable";

    public ProblemsViewToolWindowNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public String getSettingName() {
        return "do_not_show_solution_notification";
    }

    @Nullable
    public Notification createNotification() {
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(this.getProject()).getToolWindow("Problems View");
        if (toolWindow == null) {
            return null;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2.isVisible()) {
            return null;
        }
        var var2_2 = new ProjectModelEntityVisitor(){
            private int projectsWithErrors;

            public final int getProjectsWithErrors() {
                return this.projectsWithErrors;
            }

            public final void setProjectsWithErrors(int n2) {
                this.projectsWithErrors = n2;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitProject(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectDescriptor");
                RdProjectState rdProjectState = ((RdProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (rdProjectState == RdProjectState.WithErrors) {
                    int n2 = this.projectsWithErrors;
                    this.projectsWithErrors = n2 + 1;
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }

            @NotNull
            protected ProjectModelEntityVisitor.Result visitUnloadedProject(@NotNull ProjectModelEntity entity) {
                Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
                Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdUnloadProjectDescriptor");
                RdUnloadProjectState rdUnloadProjectState = ((RdUnloadProjectDescriptor)rdProjectModelItemDescriptor).getState();
                if (rdUnloadProjectState == RdUnloadProjectState.LoadFailed) {
                    int n2 = this.projectsWithErrors;
                    this.projectsWithErrors = n2 + 1;
                }
                return ProjectModelEntityVisitor.Result.Stop;
            }
        };
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.getProject()));
        if (projectModelEntity == null) {
            return null;
        }
        ProjectModelEntity projectModelEntity2 = projectModelEntity;
        var2_2.visit(projectModelEntity2);
        int n2 = var2_2.getProjectsWithErrors();
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity2.getDescriptor();
        Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdSolutionDescriptor");
        RdSolutionState rdSolutionState = ((RdSolutionDescriptor)rdProjectModelItemDescriptor).getState();
        if (rdSolutionState == RdSolutionState.WithErrors) {
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        Object[] objectArray = new Object[]{openBalloonAction, n2, n2 == 1 ? 0 : 1};
        String string = RiderProblemsViewBundle.Companion.message("notification.title", objectArray);
        objectArray = n2 > 0 ? NotificationType.ERROR : NotificationType.WARNING;
        String string2 = "<a href=\"disable\">" + RiderProblemsViewBundle.Companion.message("notification.do.not.show", new Object[0]) + "</a>";
        Notification notification2 = new Notification("ProblemsView Notification", string, string2, (NotificationType)objectArray);
        notification2.setListener((arg_0, arg_1) -> ProblemsViewToolWindowNotification.j(this, arg_0, arg_1));
        RiderProblemsViewIndicationService.Companion.getInstance(this.getProject());
        return notification2;
    }

    private static final void j(ProblemsViewToolWindowNotification problemsViewToolWindowNotification, Notification notification2, HyperlinkEvent hyperlinkEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)problemsViewToolWindowNotification), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)notification2, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)hyperlinkEvent, (String)"hyperlinkEvent");
        if (!Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
            return;
        }
        if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)openBalloonAction)) {
            RiderProblemsViewToolwindowUtils.INSTANCE.selectToolsetFileTab(problemsViewToolWindowNotification.getProject());
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            RiderProblemsViewStatisticsCollector.INSTANCE.balloonOpenActionPressed(string, problemsViewToolWindowNotification.getProject());
        }
        if (Intrinsics.areEqual((Object)hyperlinkEvent.getDescription(), (Object)disableBalloonAction)) {
            problemsViewToolWindowNotification.disableNotification();
            String string = hyperlinkEvent.getDescription();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDescription(...)");
            RiderProblemsViewStatisticsCollector.INSTANCE.balloonOpenActionPressed(string, problemsViewToolWindowNotification.getProject());
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/problemsView/notifications/ProblemsViewToolWindowNotification$Companion;", "", "()V", "disableBalloonAction", "", "openBalloonAction", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

