/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.problemsView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.problemsView.tree.RiderProblemNode;
import com.jetbrains.rider.problemsView.views.panels.RiderProblemsViewToolsetPanel;
import icons.ReSharperIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/problemsView/actions/RiderProblemsViewIgnoreAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "panel", "Lcom/jetbrains/rider/problemsView/views/panels/RiderProblemsViewToolsetPanel;", "(Lcom/jetbrains/rider/problemsView/views/panels/RiderProblemsViewToolsetPanel;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
public final class RiderProblemsViewIgnoreAction
extends AnAction {
    @NotNull
    private final RiderProblemsViewToolsetPanel panel;

    public RiderProblemsViewIgnoreAction(@NotNull RiderProblemsViewToolsetPanel panel2) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        super(RiderBundle.message("action.problems.view.ignore.text", new Object[0]), RiderBundle.message("action.problems.view.ignore.text", new Object[0]), ReSharperIcons.Common.Ignore);
        this.panel = panel2;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RiderProblemNode riderProblemNode = this.panel.getSelectedRiderProblemNode();
        if (riderProblemNode != null) {
            e.getPresentation().setEnabledAndVisible(true);
            boolean bl = this.panel.isNodeIgnored(riderProblemNode);
            if (bl) {
                e.getPresentation().setIcon(AllIcons.Actions.Show);
                e.getPresentation().setText(RiderBundle.message("action.problems.view.stop.ignoring.issue.text", new Object[0]));
            } else {
                e.getPresentation().setIcon(ReSharperIcons.SolutionAnalysis.IgnoreErrors);
                e.getPresentation().setText(RiderBundle.message("action.problems.view.ignore.issue.text", new Object[0]));
            }
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RiderProblemNode riderProblemNode = this.panel.getSelectedRiderProblemNode();
        if (riderProblemNode != null) {
            boolean bl = this.panel.isNodeIgnored(riderProblemNode);
            this.panel.ignoreCurrentProblem(!bl);
        }
    }
}

