/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.RiderEnvironment;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/plugins/RiderBundledPluginHelpers;", "", "()V", "Companion", "intellij.rider"})
public final class RiderBundledPluginHelpers {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u0004\u0018\u00010\u0004\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ*\u0010\f\u001a\u00020\r\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/RiderBundledPluginHelpers$Companion;", "", "()V", "getBundledPluginDotFile", "Ljava/io/File;", "T", "serviceClass", "Ljava/lang/Class;", "dllOrExeName", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "isAvailable", "", "productCoreDllFileName", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final <T> boolean isAvailable(@NotNull Class<T> serviceClass, @NotNull String productCoreDllFileName, @NotNull Logger logger2) {
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)productCoreDllFileName, (String)"productCoreDllFileName");
            Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
            return this.getBundledPluginDotFile(serviceClass, productCoreDllFileName, logger2) != null;
        }

        @Nullable
        public final <T> File getBundledPluginDotFile(@NotNull Class<T> serviceClass, @NotNull String dllOrExeName, @NotNull Logger logger2) {
            Object object;
            block7: {
                File file2;
                block6: {
                    Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
                    Intrinsics.checkNotNullParameter((Object)dllOrExeName, (String)"dllOrExeName");
                    Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
                    String string = PathManager.getJarPathForClass(serviceClass);
                    if (string == null) {
                        logger2.error("No JAR file found for " + dllOrExeName);
                        return null;
                    }
                    file2 = new File(string);
                    object = PathManager.getArchivedCompliedClassesLocation();
                    if (object == null) break block6;
                    String string2 = object;
                    boolean bl = false;
                    File file3 = FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(PathManager.getHomePath()), (String)"out"), (String)"rider"), (String)"plugins-backend-parts");
                    String string3 = file2.getParentFile().getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                    File file4 = FilesKt.resolve((File)file3, (String)string3);
                    object = file4;
                    if (file4 != null) break block7;
                }
                object = Intrinsics.areEqual((Object)FilesKt.getExtension((File)file2), (Object)"jar") ? file2.getParentFile().getParentFile() : file2;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            File file5 = FilesKt.resolve((File)FilesKt.resolve((File)object2, (String)"DotFiles"), (String)dllOrExeName);
            if (file5.exists()) {
                logger2.info("Plugin backend file " + dllOrExeName + " found in DotFiles: " + file5);
                return file5;
            }
            object2 = FilesKt.resolve((File)RiderEnvironment.INSTANCE.getRiderBackendDirectory(), (String)dllOrExeName);
            if (((File)object2).exists()) {
                logger2.info("Plugin backend file " + dllOrExeName + " found in BinDir: " + file5);
                return object2;
            }
            logger2.info("Plugin backend file " + dllOrExeName + " not found");
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

