/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.pasteSpecial;

import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actions.BasePasteHandler;
import com.intellij.openapi.editor.impl.EditorCopyPasteHelperImpl;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.ui.messages.MessagesService;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.pasteSpecial.JsonToCSharp;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH&J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/pasteSpecial/PasteAsCSharpHandler;", "Lcom/intellij/openapi/editor/actions/BasePasteHandler;", "()V", "doExecute", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "format", "Lcom/jetbrains/rider/pasteSpecial/JsonToCSharp$OutputFormat;", "pasteJson", "content", "", "intellij.rider"})
public abstract class PasteAsCSharpHandler
extends BasePasteHandler {
    @NotNull
    public abstract JsonToCSharp.OutputFormat format();

    public void doExecute(@NotNull Editor editor2, @Nullable Caret caret, @Nullable DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Transferable transferable = CopyPasteManager.getInstance().getContents();
        Object object = transferable != null ? transferable.getTransferData(DataFlavor.stringFlavor) : null;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        String string = (String)object;
        this.pasteJson(editor2, string);
    }

    public final void pasteJson(@NotNull Editor editor2, @NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        String string = null;
        try {
            string = JsonToCSharp.INSTANCE.convert(content2, this.format());
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string2 = RiderBundle.message("paste.special.unable.to.parse.json", new Object[0]);
            String string3 = RiderBundle.message("paste.special.invalid.json.message", new Object[0]);
            MessagesService.Companion.getInstance().showErrorDialog(null, string3, string2);
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> PasteAsCSharpHandler.j(editor2, string));
    }

    private static final void j(Editor editor2, String string) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)string, (String)"$text");
        EditorCopyPasteHelperImpl.insertStringAtCaret((Editor)editor2, (String)string);
    }
}

