/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.panels;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdNuGetConfigFile;
import com.jetbrains.rider.model.RdNuGetFeedDetails;
import com.jetbrains.rider.model.RdNuGetUltraConfig;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.RiderNuGetMainSplitterToggleAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetReloadAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetShowSettingsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetToolbarRestoreAction;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigList;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigListState;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigPropertiesPanel;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedTable;
import com.jetbrains.rider.nuget.helpers.RiderNuGetActionHelper;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConsoleHelper;
import com.jetbrains.rider.nuget.panels.RiderNuGetPanelBase;
import com.jetbrains.rider.nuget.panels.components.NuGetConfigDetailedView;
import com.jetbrains.rider.nuget.panels.components.NuGetSourcesMainSplitter;
import com.jetbrains.rider.ui.RiderUI;
import java.awt.Color;
import java.awt.Component;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001/B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\nH\u0002J$\u0010!\u001a\u00020\u001d2\b\b\u0001\u0010\"\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00062\b\b\u0003\u0010$\u001a\u00020\u001fH\u0002J\b\u0010%\u001a\u00020\fH\u0014J\b\u0010&\u001a\u00020'H\u0014J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u0010+\u001a\u00020,2\b\b\u0002\u0010-\u001a\u00020.H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel;", "Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelBase;", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "(Lcom/jetbrains/rider/nuget/RiderNuGetFacade;)V", "configDetailedView", "Ljavax/swing/JTextPane;", "configList", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigList;", "errorConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "errorPane", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getFacade", "()Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "feedTable", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedTable;", "mainPanel", "mainPanelSync", "Ljava/lang/Object;", "mainSplitter", "Lcom/jetbrains/rider/nuget/panels/components/NuGetSourcesMainSplitter;", "mainSplitterToggleAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetMainSplitterToggleAction;", "propertiesPanel", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigPropertiesPanel;", "reloadAction", "Lcom/jetbrains/rider/nuget/actions/RiderNuGetReloadAction;", "j", "", "line", "", "textPane", "j", "text", "console", "prefix", "build", "buildToolbar", "Ljavax/swing/JComponent;", "j", "config", "Lcom/jetbrains/rider/model/RdNuGetConfigFile;", "j", "Ljavax/swing/Icon;", "invert", "", "ConsoleType", "intellij.rider"})
public final class RiderNuGetSourcesPanel
extends RiderNuGetPanelBase {
    @NotNull
    private final RiderNuGetFacade facade;
    @NotNull
    private final RiderNuGetConfigList configList;
    @NotNull
    private final JTextPane configDetailedView;
    @NotNull
    private final RiderNuGetFeedTable feedTable;
    @NotNull
    private final RiderNuGetConfigPropertiesPanel propertiesPanel;
    @NotNull
    private final ConsoleViewImpl errorConsole;
    @NotNull
    private final BorderLayoutPanel errorPane;
    @NotNull
    private final RiderNuGetMainSplitterToggleAction mainSplitterToggleAction;
    @NotNull
    private final NuGetSourcesMainSplitter mainSplitter;
    @NotNull
    private final RiderNuGetReloadAction reloadAction;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    @NotNull
    private final Object mainPanelSync;

    public RiderNuGetSourcesPanel(@NotNull RiderNuGetFacade facade) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(RiderNugetBundle.Companion.message("tab.title.sources", new Object[0]));
        this.facade = facade;
        this.configList = new RiderNuGetConfigList(this.facade);
        this.configDetailedView = new NuGetConfigDetailedView();
        this.feedTable = new RiderNuGetFeedTable(this.facade, this.facade.getHost().getConfigManager());
        this.propertiesPanel = new RiderNuGetConfigPropertiesPanel((Lifetime)this.facade.getLifetime(), this.facade.getProject(), this.facade.getHost().getConfigManager());
        this.errorConsole = RiderNuGetConsoleHelper.Companion.createConsole(this.facade.getProject());
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        RiderNuGetSourcesPanel riderNuGetSourcesPanel = this;
        boolean bl = false;
        borderLayoutPanel2.setVisible(false);
        borderLayoutPanel2.addToCenter((Component)this.errorConsole.getComponent());
        this.errorConsole.getEditor().getSettings().setCaretRowShown(true);
        riderNuGetSourcesPanel.errorPane = borderLayoutPanel;
        this.mainSplitterToggleAction = new RiderNuGetMainSplitterToggleAction(this.facade, (Function0<? extends Icon>)((Function0)new Function0<Icon>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Icon invoke() {
                return RiderNuGetSourcesPanel.getMainSplitterIcon$default(this.this$0, false, 1, null);
            }
        }));
        this.mainSplitter = new NuGetSourcesMainSplitter(this.configList, this.feedTable, this.propertiesPanel, this.configDetailedView, this.facade, (Function1<? super Boolean, ? extends Icon>)((Function1)new Function1<Boolean, Icon>(this){
            final /* synthetic */ RiderNuGetSourcesPanel this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Icon invoke(boolean it) {
                return RiderNuGetSourcesPanel.access$getMainSplitterIcon(this.this$0, true);
            }
        }));
        this.reloadAction = new RiderNuGetReloadAction(this.facade);
        borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        riderNuGetSourcesPanel = this;
        bl = false;
        borderLayoutPanel2.addToCenter((Component)((Object)this.mainSplitter));
        RiderNuGetActionHelper.INSTANCE.applyRefreshActionShortcut(this.reloadAction, (JComponent)borderLayoutPanel2);
        riderNuGetSourcesPanel.mainPanel = borderLayoutPanel;
        this.mainPanelSync = new Object();
        Disposer.register((Disposable)((Disposable)this.facade.getProject()), (Disposable)((Disposable)this.errorConsole));
        this.facade.getHost().getConfigManager().getConfigFiles().advise((Lifetime)this.facade.getLifetime(), (Function1)new Function1<List<? extends RdNuGetConfigFile>, Unit>(){

            public final void invoke(@NotNull List<RdNuGetConfigFile> newFiles) {
                RiderNuGetConfigList riderNuGetConfigList;
                Intrinsics.checkNotNullParameter(newFiles, (String)"newFiles");
                RiderNuGetConfigList riderNuGetConfigList2 = riderNuGetConfigList = configList;
                boolean bl = false;
                RiderNuGetConfigListState riderNuGetConfigListState = riderNuGetConfigList2.getState();
                riderNuGetConfigList2.getRiderModel().removeAllElements();
                for (RdNuGetConfigFile rdNuGetConfigFile : newFiles) {
                    riderNuGetConfigList2.getRiderModel().addElement(rdNuGetConfigFile);
                }
                riderNuGetConfigList2.applyState(riderNuGetConfigListState);
            }
        });
        this.facade.getHost().getConfigManager().getUltraConfig().advise((Lifetime)this.facade.getLifetime(), (Function1)new Function1<RdNuGetUltraConfig, Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull RdNuGetUltraConfig ultra) {
                Intrinsics.checkNotNullParameter((Object)ultra, (String)"ultra");
                Object object = mainPanelSync;
                RiderNuGetSourcesPanel riderNuGetSourcesPanel = this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    CharSequence charSequence = ultra.getErrorMessage();
                    boolean bl2 = !(charSequence == null || charSequence.length() == 0);
                    boolean bl3 = riderNuGetSourcesPanel.errorPane.isVisible() ^ bl2;
                    if (riderNuGetSourcesPanel.errorPane.isVisible() && !bl2) {
                        riderNuGetSourcesPanel.mainPanel.remove((Component)riderNuGetSourcesPanel.errorPane);
                        riderNuGetSourcesPanel.mainPanel.addToCenter((Component)((Object)riderNuGetSourcesPanel.mainSplitter));
                    }
                    if (!riderNuGetSourcesPanel.errorPane.isVisible() && bl2) {
                        riderNuGetSourcesPanel.mainPanel.remove((Component)((Object)riderNuGetSourcesPanel.mainSplitter));
                        riderNuGetSourcesPanel.mainPanel.addToCenter((Component)riderNuGetSourcesPanel.errorPane);
                    }
                    riderNuGetSourcesPanel.errorConsole.clear();
                    String string = ultra.getErrorMessage();
                    if (string == null) {
                        string = "";
                    }
                    String string2 = string;
                    riderNuGetSourcesPanel.j(string2, riderNuGetSourcesPanel.errorConsole);
                    riderNuGetSourcesPanel.errorPane.setVisible(bl2);
                    if (bl3) {
                        riderNuGetSourcesPanel.mainPanel.invalidate();
                        riderNuGetSourcesPanel.mainPanel.repaint();
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
        });
        this.configList.getOnConfigSelection().advise((Lifetime)this.facade.getLifetime(), (Function1)new Function1<RdNuGetConfigFile, Unit>(){

            public final void invoke(@NotNull RdNuGetConfigFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.j(it);
                feedTable.displayConfig(it);
                propertiesPanel.displayConfig(it);
            }
        });
        InterfacesKt.fire((ISignal)this.facade.getHost().getConfigManager().getReload());
        this.facade.getViewSettings().getSourcesSplitterOrientation().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean value) {
                mainSplitter.setOrientation(value);
                mainSplitter.updateUI();
            }
        }));
    }

    @NotNull
    public final RiderNuGetFacade getFacade() {
        return this.facade;
    }

    private final Icon j(boolean bl) {
        Icon icon2;
        boolean bl2 = this.facade.getViewSettings().getSourcesSplitterOrientation().getValue() ^ bl;
        if (bl2) {
            Icon icon3 = AllIcons.Actions.SplitHorizontally;
            icon2 = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"SplitHorizontally");
        } else if (!bl2) {
            Icon icon4 = AllIcons.Actions.SplitVertically;
            icon2 = icon4;
            Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"SplitVertically");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return icon2;
    }

    static /* synthetic */ Icon getMainSplitterIcon$default(RiderNuGetSourcesPanel riderNuGetSourcesPanel, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        return riderNuGetSourcesPanel.j(bl);
    }

    private final void j(@Nls String string, JTextPane jTextPane, @Nls String string2) {
        Object object = new char[]{'\n'};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])object, (boolean)false, (int)0, (int)6, null);
        object = list2.iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            this.j(string2 + string3, jTextPane);
        }
    }

    static /* synthetic */ void addText$default(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string, JTextPane jTextPane, String string2, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        riderNuGetSourcesPanel.j(string, jTextPane, string2);
    }

    private final void j(String string, ConsoleViewImpl consoleViewImpl) {
        Object object = new char[]{'\n'};
        List list2 = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"\r", (String)"", (boolean)false, (int)4, null), (char[])object, (boolean)false, (int)0, (int)6, null);
        object = list2.iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            consoleViewImpl.print(string2 + "\n", ConsoleType.Companion.getError());
        }
    }

    private final void j(@Nls String string, JTextPane jTextPane) {
        JTextPane jTextPane2;
        Color color;
        if (StringsKt.startsWith$default((String)string, (String)"###", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.VsPalette.Companion.getModifierBlue();
        } else if (StringsKt.startsWith$default((String)string, (String)"*", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.CommonPalette.Companion.getLightGreen();
        } else if (StringsKt.startsWith$default((String)string, (String)"!", (boolean)false, (int)2, null)) {
            color = (Color)RiderUI.CommonPalette.Companion.getRed();
        } else {
            JBColor jBColor = JBColor.GRAY;
            Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"GRAY");
            color = (Color)jBColor;
        }
        Color color2 = color;
        StyleContext styleContext = StyleContext.getDefaultStyleContext();
        AttributeSet attributeSet = null;
        attributeSet = styleContext.addAttribute(SimpleAttributeSet.EMPTY, StyleConstants.Foreground, color2);
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.FontFamily, "Lucida Console");
        attributeSet = styleContext.addAttribute(attributeSet, StyleConstants.Alignment, 3);
        JTextPane jTextPane3 = jTextPane2 = jTextPane;
        boolean bl = false;
        jTextPane3.setCaretPosition(jTextPane3.getDocument().getLength());
        jTextPane3.setCharacterAttributes(attributeSet, false);
        jTextPane3.replaceSelection(string + "\n");
    }

    private final void j(RdNuGetConfigFile rdNuGetConfigFile) {
        JTextPane jTextPane;
        JTextPane jTextPane2 = jTextPane = this.configDetailedView;
        boolean bl = false;
        jTextPane2.setEditable(true);
        jTextPane2.setText("");
        RiderNuGetSourcesPanel.j(this, rdNuGetConfigFile.getDetailedInfoHeader());
        RiderNuGetSourcesPanel.N(this, "");
        RiderNuGetSourcesPanel.N(this, "### " + RiderNugetBundle.Companion.message("restore.consent", new Object[0]));
        RiderNuGetSourcesPanel.N(this, "    " + RiderNugetBundle.Companion.message("nuget.config.is.granted", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isGranted() + ", " + RiderNugetBundle.Companion.message("nuget.config.is.granted.in.settings", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isGrantedInSettings() + ", " + RiderNugetBundle.Companion.message("nuget.config.is.automatic", new Object[0]) + " = " + rdNuGetConfigFile.getRestoreConsent().isAutomatic());
        RiderNuGetSourcesPanel.N(this, "");
        RiderNuGetSourcesPanel.N(this, "### " + RiderNugetBundle.Companion.message("feeds", new Object[0]));
        Iterator iterator2 = rdNuGetConfigFile.getFeeds().iterator();
        while (iterator2.hasNext()) {
            CharSequence charSequence;
            Object object;
            RdNuGetFeedDetails rdNuGetFeedDetails;
            RdNuGetFeedDetails rdNuGetFeedDetails2 = rdNuGetFeedDetails = (object = (RdNuGetFeedDetails)iterator2.next());
            boolean bl2 = false;
            RiderNuGetSourcesPanel.N(this, "* " + rdNuGetFeedDetails2.getName() + (String)((charSequence = (CharSequence)rdNuGetFeedDetails2.getDescription()) == null || charSequence.length() == 0 ? "" : " (" + rdNuGetFeedDetails2.getDescription() + ")"));
            RiderNuGetSourcesPanel.j(this, rdNuGetFeedDetails2.getDetailedInfo());
            RiderNuGetSourcesPanel.N(this, "");
        }
        if (CollectionsKt.any((Iterable)rdNuGetConfigFile.getFallbackFolders())) {
            RiderNuGetSourcesPanel.N(this, "### " + RiderNugetBundle.Companion.message("nuget.config.fallback.folders", new Object[0]));
            for (Object object : rdNuGetConfigFile.getFallbackFolders()) {
                RiderNuGetSourcesPanel.N(this, "* " + (String)object);
            }
        }
        jTextPane2.setEditable(false);
    }

    @NotNull
    protected BorderLayoutPanel build() {
        return this.mainPanel;
    }

    @Override
    @NotNull
    protected JComponent buildToolbar() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup defaultActionGroup2 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        defaultActionGroup2.add((AnAction)new RiderNuGetToolbarRestoreAction((Lifetime)this.facade.getLifetime(), this.facade));
        defaultActionGroup2.add((AnAction)this.reloadAction);
        defaultActionGroup2.add((AnAction)this.mainSplitterToggleAction);
        defaultActionGroup2.add((AnAction)new RiderNuGetShowSettingsAction(this.facade.getProject()));
        defaultActionGroup2.add((AnAction)this.facade.getHelpAction());
        DefaultActionGroup defaultActionGroup3 = defaultActionGroup;
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup3, false).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private static final void j(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string) {
        RiderNuGetSourcesPanel.addText$default(riderNuGetSourcesPanel, string, riderNuGetSourcesPanel.configDetailedView, null, 4, null);
    }

    private static final void N(RiderNuGetSourcesPanel riderNuGetSourcesPanel, String string) {
        riderNuGetSourcesPanel.j(string, riderNuGetSourcesPanel.configDetailedView);
    }

    public static final /* synthetic */ Icon access$getMainSplitterIcon(RiderNuGetSourcesPanel $this, boolean invert) {
        return $this.j(invert);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel$ConsoleType;", "", "()V", "Companion", "intellij.rider"})
    private static final class ConsoleType {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final ConsoleViewContentType error = new ConsoleViewContentType("NUGET_ERROR", ConsoleHighlighter.RED);

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetSourcesPanel$ConsoleType$Companion;", "", "()V", "error", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getError", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "intellij.rider"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final ConsoleViewContentType getError() {
                return error;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

