/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.panels;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ConsoleHighlighter;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdNuGetLogLevel;
import com.jetbrains.rider.model.RdNuGetLogMessage;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNuGetLogHost;
import com.jetbrains.rider.nuget.RiderNuGetViewSettings;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.actions.NuGetRefreshLogsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetShowSettingsAction;
import com.jetbrains.rider.nuget.actions.RiderNuGetToolbarRestoreAction;
import com.jetbrains.rider.nuget.credentials.MicrosoftDeviceFlowUtil;
import com.jetbrains.rider.nuget.helpers.RiderNuGetActionHelper;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConsoleHelper;
import com.jetbrains.rider.nuget.panels.RiderNuGetPanelBase;
import com.jetbrains.rider.nuget.panels.components.NuGetLogSeverityComboBox;
import icons.ReSharperIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001'B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010\u001e\u001a\u00020\u001fH\u0014J\b\u0010 \u001a\u00020\u001fH\u0014J\b\u0010!\u001a\u00020\u001aH\u0002J\b\u0010\"\u001a\u00020\u001aH\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetLogPanel;", "Lcom/jetbrains/rider/nuget/panels/RiderNuGetPanelBase;", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "(Lcom/jetbrains/rider/nuget/RiderNuGetFacade;)V", "console", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "dateFormat", "Ljava/text/SimpleDateFormat;", "fullLog", "", "Lcom/jetbrains/rider/model/RdNuGetLogMessage;", "j", "()Ljava/util/List;", "refreshAction", "Lcom/jetbrains/rider/nuget/actions/NuGetRefreshLogsAction;", "rehighlightQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "rehighlightQueueAction", "Lcom/intellij/util/ui/update/Update;", "viewSettings", "Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "j", "()Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "j", "", "message", "build", "Ljavax/swing/JPanel;", "buildToolbar", "Ljavax/swing/JComponent;", "buildTopToolbar", "j", "N", "j", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "level", "Lcom/jetbrains/rider/model/RdNuGetLogLevel;", "ConsoleType", "intellij.rider"})
public final class RiderNuGetLogPanel
extends RiderNuGetPanelBase {
    @NotNull
    private final RiderNuGetFacade facade;
    @NotNull
    private final ConsoleViewImpl console;
    private final MergingUpdateQueue rehighlightQueue;
    @NotNull
    private final Update rehighlightQueueAction;
    @NotNull
    private final SimpleDateFormat dateFormat;
    @NotNull
    private final NuGetRefreshLogsAction refreshAction;

    public RiderNuGetLogPanel(@NotNull RiderNuGetFacade facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super(RiderNugetBundle.Companion.message("tab.title.log", new Object[0]));
        this.facade = facade;
        this.console = RiderNuGetConsoleHelper.Companion.createConsole(this.facade.getProject());
        this.rehighlightQueue = new MergingUpdateQueue("RiderNuGetLog->ReHighlight", 2000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.facade.getProject(), null, true).setRestartTimerOnAdd(true);
        this.rehighlightQueueAction = new Update(this){
            final /* synthetic */ RiderNuGetLogPanel this$0;
            {
                this.this$0 = $receiver;
                super((Object)"RiderNuGetLog->ReHighlightAction");
            }

            public void run() {
                RiderNuGetLogPanel.access$getConsole$p(this.this$0).rehighlightHyperlinksAndFoldings();
            }
        };
        this.dateFormat = new SimpleDateFormat("HH:mm:ss");
        this.refreshAction = new NuGetRefreshLogsAction((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ RiderNuGetLogPanel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                RiderNuGetLogPanel.access$reloadAll(this.this$0);
            }
        }));
        Disposer.register((Disposable)((Disposable)this.facade.getProject()), (Disposable)((Disposable)this.console));
        this.N();
        this.facade.getHost().getLog().advise((Lifetime)this.facade.getLifetime(), (Function1)new Function1<List<? extends RdNuGetLogMessage>, Unit>(){

            public final void invoke(@NotNull List<RdNuGetLogMessage> messages) {
                Intrinsics.checkNotNullParameter(messages, (String)"messages");
                for (RdNuGetLogMessage rdNuGetLogMessage : messages) {
                    this.j(rdNuGetLogMessage);
                }
                this.j();
            }
        });
        this.j().getShowTime().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.N();
            }
        }));
        this.j().getShowContext().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.N();
            }
        }));
        this.j().getShowLevel().advise((Lifetime)this.facade.getLifetime(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.N();
            }
        }));
        this.j().getVerbosity().advise((Lifetime)this.facade.getLifetime(), (Function1<? super RdNuGetLogLevel, Unit>)((Function1)new Function1<RdNuGetLogLevel, Unit>(){

            public final void invoke(@NotNull RdNuGetLogLevel it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.N();
            }
        }));
    }

    private final List<RdNuGetLogMessage> j() {
        return RiderNuGetLogHost.Companion.getInstance(this.facade.getProject()).getFullLog();
    }

    private final RiderNuGetViewSettings j() {
        return this.facade.getViewSettings();
    }

    private final void j() {
        this.rehighlightQueue.queue(this.rehighlightQueueAction);
    }

    private final void N() {
        this.console.clear();
        for (RdNuGetLogMessage rdNuGetLogMessage : this.j()) {
            this.j(rdNuGetLogMessage);
        }
        this.j();
    }

    private final void j(RdNuGetLogMessage rdNuGetLogMessage) {
        if (!RiderNuGetExtensionsKt.isEmpty((RdNuGetLogMessage)rdNuGetLogMessage)) {
            MicrosoftDeviceFlowUtil.Companion.interceptAndNotifyFromLogMessage(this.facade.getProject(), rdNuGetLogMessage.getText());
        }
        if (!RiderNuGetExtensionsKt.isEmpty((RdNuGetLogMessage)rdNuGetLogMessage) && this.j().getVerbosity().shouldBeVisible(rdNuGetLogMessage.getLevel())) {
            ConsoleViewContentType consoleViewContentType = this.j(rdNuGetLogMessage.getLevel());
            boolean bl = true;
            if (this.j().getShowTime().getValue()) {
                String string = this.dateFormat.format(rdNuGetLogMessage.getTimestamp());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
                RiderNuGetLogPanel.j(this, consoleViewContentType, string);
                bl = false;
            }
            if (this.j().getShowContext().getValue()) {
                if (!bl) {
                    RiderNuGetLogPanel.j(this, consoleViewContentType, "|");
                }
                String string = rdNuGetLogMessage.getContext().toString().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                RiderNuGetLogPanel.j(this, consoleViewContentType, string);
                bl = false;
            }
            if (this.j().getShowLevel().getValue()) {
                if (!bl) {
                    RiderNuGetLogPanel.j(this, consoleViewContentType, "|");
                }
                String string = rdNuGetLogMessage.getLevel().toString().toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
                String string2 = StringsKt.padEnd((String)string, (int)5, (char)' ').substring(0, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                RiderNuGetLogPanel.j(this, consoleViewContentType, string2);
                bl = false;
            }
            if (!bl) {
                RiderNuGetLogPanel.j(this, consoleViewContentType, "| ");
            }
            RiderNuGetLogPanel.j(this, consoleViewContentType, rdNuGetLogMessage.getText());
            RiderNuGetLogPanel.j(this, consoleViewContentType, "\n");
        }
    }

    @Override
    @NotNull
    protected JPanel build() {
        JPanel jPanel;
        JPanel jPanel2 = jPanel = new JPanel(new BorderLayout());
        boolean bl = false;
        jPanel2.add((Component)this.console.getComponent(), "Center");
        this.console.getEditor().getSettings().setCaretRowShown(true);
        RiderNuGetActionHelper.INSTANCE.applyRefreshActionShortcut(this.refreshAction, jPanel2);
        return jPanel;
    }

    @Override
    @NotNull
    protected JComponent buildToolbar() {
        List list2 = new ArrayList();
        list2.add(new RiderNuGetToolbarRestoreAction((Lifetime)this.facade.getLifetime(), this.facade));
        list2.add(this.refreshAction);
        list2.add(new RiderNuGetShowSettingsAction(this.facade.getProject()));
        list2.add(this.facade.getHelpAction());
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2);
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup, false).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @Override
    @NotNull
    protected JComponent buildTopToolbar() {
        List list2 = new ArrayList();
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.j().getShowTime(), RiderActionsBundle.Companion.message("action.hide.time.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.time.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.time.show.hide.description", new Object[0]), ReSharperIcons.UnitTesting.Time, null, 16, null));
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.j().getShowContext(), RiderActionsBundle.Companion.message("action.hide.context.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.context.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.context.show.hide.description", new Object[0]), AllIcons.Actions.MoveTo2, null, 16, null));
        list2.add(RiderNuGetViewSettings.BooleanViewProperty.toToggleDumbAwareAction$default(this.j().getShowLevel(), RiderActionsBundle.Companion.message("action.hide.level.text", new Object[0]), RiderActionsBundle.Companion.message("action.show.level.text", new Object[0]), RiderActionsBundle.Companion.message("action.toggle.level.description", new Object[0]), AllIcons.Actions.ListFiles, null, 16, null));
        list2.add(new Separator());
        AnAction[] anActionArray = this.console.createConsoleActions();
        Intrinsics.checkNotNullExpressionValue((Object)anActionArray, (String)"createConsoleActions(...)");
        AnAction[] anActionArray2 = anActionArray;
        AnAction anAction = anActionArray2[2];
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"get(...)");
        list2.add(anAction);
        AnAction anAction2 = anActionArray2[3];
        Intrinsics.checkNotNullExpressionValue((Object)anAction2, (String)"get(...)");
        list2.add(anAction2);
        AnAction anAction3 = anActionArray2[5];
        Intrinsics.checkNotNullExpressionValue((Object)anAction3, (String)"get(...)");
        list2.add(anAction3);
        list2.add(new Separator());
        list2.add(new NuGetLogSeverityComboBox(this.j()));
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2);
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)defaultActionGroup, true).getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final ConsoleViewContentType j(RdNuGetLogLevel rdNuGetLogLevel) {
        return switch (WhenMappings.$EnumSwitchMapping$0[rdNuGetLogLevel.ordinal()]) {
            case 1 -> ConsoleType.INSTANCE.getDebug();
            case 2 -> ConsoleType.INSTANCE.getVerbose();
            case 3 -> ConsoleType.INSTANCE.getInformation();
            case 4 -> ConsoleType.INSTANCE.getMinimal();
            case 5 -> ConsoleType.INSTANCE.getWarning();
            case 6 -> ConsoleType.INSTANCE.getError();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private static final void j(RiderNuGetLogPanel riderNuGetLogPanel, ConsoleViewContentType consoleViewContentType, String string) {
        riderNuGetLogPanel.console.print(string, consoleViewContentType);
    }

    public static final /* synthetic */ ConsoleViewImpl access$getConsole$p(RiderNuGetLogPanel $this) {
        return $this.console;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/nuget/panels/RiderNuGetLogPanel$ConsoleType;", "", "()V", "debug", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "getDebug", "()Lcom/intellij/execution/ui/ConsoleViewContentType;", "error", "getError", "information", "getInformation", "minimal", "getMinimal", "verbose", "getVerbose", "warning", "getWarning", "intellij.rider"})
    private static final class ConsoleType {
        @NotNull
        public static final ConsoleType INSTANCE = new ConsoleType();
        @NotNull
        private static final ConsoleViewContentType debug = new ConsoleViewContentType("NUGET_DEBUG", ConsoleHighlighter.GRAY);
        @NotNull
        private static final ConsoleViewContentType verbose = new ConsoleViewContentType("NUGET_VERBOSE", ConsoleHighlighter.BLUE);
        @NotNull
        private static final ConsoleViewContentType information = new ConsoleViewContentType("NUGET_INFORMATION", ConsoleHighlighter.CYAN);
        @NotNull
        private static final ConsoleViewContentType minimal = new ConsoleViewContentType("NUGET_MINIMAL", ConsoleHighlighter.MAGENTA);
        @NotNull
        private static final ConsoleViewContentType warning = new ConsoleViewContentType("NUGET_WARNING", ConsoleHighlighter.YELLOW);
        @NotNull
        private static final ConsoleViewContentType error = new ConsoleViewContentType("NUGET_ERROR", ConsoleHighlighter.RED);

        private ConsoleType() {
        }

        @NotNull
        public final ConsoleViewContentType getDebug() {
            return debug;
        }

        @NotNull
        public final ConsoleViewContentType getVerbose() {
            return verbose;
        }

        @NotNull
        public final ConsoleViewContentType getInformation() {
            return information;
        }

        @NotNull
        public final ConsoleViewContentType getMinimal() {
            return minimal;
        }

        @NotNull
        public final ConsoleViewContentType getWarning() {
            return warning;
        }

        @NotNull
        public final ConsoleViewContentType getError() {
            return error;
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RdNuGetLogLevel.values().length];
            try {
                nArray[RdNuGetLogLevel.Debug.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Verbose.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Information.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Minimal.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Warning.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RdNuGetLogLevel.Error.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

