/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.model.RdNuGetLicenseLabel;
import com.jetbrains.rider.model.RdNuGetPackageMetadata;
import com.jetbrains.rider.model.RdNuGetVersionsInFeed;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import icons.ReSharperIcons;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB-\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0018\u001a\u00020\u0019R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\f\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetLink;", "", "title", "", "url", "description", "icon", "Ljavax/swing/Icon;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljavax/swing/Icon;)V", "getDescription", "()Ljava/lang/String;", "setDescription", "(Ljava/lang/String;)V", "getIcon", "()Ljavax/swing/Icon;", "getTitle", "setTitle", "updated", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getUpdated", "()Lcom/jetbrains/rd/util/reactive/Signal;", "getUrl", "setUrl", "toHyperlinkLabel", "Lcom/intellij/ui/HyperlinkLabel;", "Companion", "intellij.rider"})
public final class RiderNuGetLink {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String title;
    @NotNull
    private String url;
    @NotNull
    private String description;
    @Nullable
    private final Icon icon;
    @NotNull
    private final Signal<Unit> updated;

    public RiderNuGetLink(@NlsContexts.LinkLabel @NotNull String title2, @NotNull String url2, @NlsContexts.Tooltip @NotNull String description, @Nullable Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.title = title2;
        this.url = url2;
        this.description = description;
        this.icon = icon2;
        this.updated = Signal.Companion.Void();
    }

    public /* synthetic */ RiderNuGetLink(String string, String string2, String string3, Icon icon2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            icon2 = null;
        }
        this(string, string2, string3, icon2);
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public final void setTitle(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.title = string;
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    public final void setUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.url = string;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.description = string;
    }

    @Nullable
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Signal<Unit> getUpdated() {
        return this.updated;
    }

    @NotNull
    public final HyperlinkLabel toHyperlinkLabel() {
        HyperlinkLabel hyperlinkLabel2;
        HyperlinkLabel hyperlinkLabel3 = hyperlinkLabel2 = new HyperlinkLabel(this.title);
        boolean bl = false;
        hyperlinkLabel3.setHyperlinkTarget(this.url);
        hyperlinkLabel3.setToolTipText(this.description);
        return hyperlinkLabel2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0007J\u0018\u0010\u000b\u001a\n \f*\u0004\u0018\u00010\u00070\u00072\u0006\u0010\r\u001a\u00020\u0007H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0013\u001a\u00020\u0014J*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0004J\u0016\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u0014\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetLink$Companion;", "", "()V", "createTagHyperlinks", "", "Lcom/intellij/ui/HyperlinkLabel;", "tags", "", "delim", "", "urlPrefix", "j", "kotlin.jvm.PlatformType", "url", "getGoogleLink", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetLink;", "id", "sourceName", "getLicenseUrlLink", "meta", "Lcom/jetbrains/rider/model/RdNuGetPackageMetadata;", "getLinks", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "versions", "Lcom/jetbrains/rider/model/RdNuGetVersionsInFeed;", "getNuGetOrgLink", "getProjectUrlLink", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetLink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetLink.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetLink$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,81:1\n1747#2,3:82\n1549#2:85\n1620#2,3:86\n1549#2:89\n1620#2,3:90\n766#2:93\n857#2,2:94\n1549#2:96\n1620#2,2:97\n1622#2:100\n1#3:99\n*S KotlinDebug\n*F\n+ 1 RiderNuGetLink.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetLink$Companion\n*L\n25#1:82,3\n51#1:85\n51#1:86,3\n68#1:89\n68#1:90,3\n69#1:93\n69#1:94,2\n70#1:96\n70#1:97,2\n70#1:100\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<RiderNuGetLink> getLinks(@NotNull RiderNuGetFacade facade, @NotNull RdNuGetPackageMetadata meta, @NotNull List<RdNuGetVersionsInFeed> versions) {
            boolean bl;
            List list2;
            List list3;
            block4: {
                Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
                Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
                Intrinsics.checkNotNullParameter(versions, (String)"versions");
                list2 = list3 = (List)new ArrayList();
                boolean bl2 = false;
                Iterable iterable = versions;
                boolean bl3 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    v0 = false;
                } else {
                    for (Object t : iterable) {
                        RdNuGetVersionsInFeed rdNuGetVersionsInFeed = (RdNuGetVersionsInFeed)t;
                        boolean bl4 = false;
                        if (!facade.isNuGetOrgFeed(rdNuGetVersionsInFeed.getFeedId())) continue;
                        v0 = true;
                        break block4;
                    }
                    v0 = bl = false;
                }
            }
            if (bl) {
                list2.add(Companion.getNuGetOrgLink(meta.getIdentity().getId(), ""));
            }
            list2.add(Companion.getProjectUrlLink(meta));
            list2.addAll((Collection)Companion.getLicenseUrlLink(meta));
            list2.add(Companion.getGoogleLink(meta.getIdentity().getId(), ""));
            return CollectionsKt.filterNotNull((Iterable)list3);
        }

        @NotNull
        public final RiderNuGetLink getNuGetOrgLink(@NotNull String id2, @NotNull String sourceName) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
            return new RiderNuGetLink("NuGet.org", "https://www.nuget.org/packages/" + this.j(id2), RiderNugetBundle.Companion.message("RiderNuGetLink.tooltip.show.package.on.nuget.org", new Object[0]), ReSharperIcons.ProjectModel.NuGet);
        }

        @Nullable
        public final RiderNuGetLink getProjectUrlLink(@NotNull RdNuGetPackageMetadata meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
            if (meta.getProjectUrl() != null) {
                String string = String.valueOf(meta.getProjectUrl());
                String string2 = StringsKt.startsWith$default((String)string, (String)"https://github.com/", (boolean)false, (int)2, null) ? "GitHub" : RiderNugetBundle.Companion.message("RiderNuGetLink.link.label.project.site", new Object[0]);
                Icon icon2 = StringsKt.startsWith$default((String)string, (String)"https://github.com/", (boolean)false, (int)2, null) ? AllIcons.Vcs.Vendors.Github : null;
                Object[] objectArray = new Object[]{string2};
                return new RiderNuGetLink(string2, string, RiderNugetBundle.Companion.message("RiderNuGetLink.tooltip.open.page", objectArray), icon2);
            }
            return null;
        }

        @NotNull
        public final List<RiderNuGetLink> getLicenseUrlLink(@NotNull RdNuGetPackageMetadata meta) {
            Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
            Iterable iterable = meta.getLicenses();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                RdNuGetLicenseLabel rdNuGetLicenseLabel = (RdNuGetLicenseLabel)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                String string = rdNuGetLicenseLabel.getText();
                Object object = rdNuGetLicenseLabel.getUrl();
                if (object == null || (object = ((URI)object).toString()) == null) {
                    object = "";
                }
                Object object2 = object;
                Intrinsics.checkNotNull((Object)object2);
                collection2.add(new RiderNuGetLink(string, (String)object2, RiderNugetBundle.Companion.message("show.license.page", new Object[0]) + (String)(!Intrinsics.areEqual((Object)rdNuGetLicenseLabel.getText(), (Object)"License") ? " (" + rdNuGetLicenseLabel.getText() + ")" : ""), null, 8, null));
            }
            return (List)collection;
        }

        @NotNull
        public final RiderNuGetLink getGoogleLink(@NotNull String id2, @NotNull String sourceName) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)sourceName, (String)"sourceName");
            String string = "Google";
            return new RiderNuGetLink(string, "http://www.google.com/search?q=" + this.j(id2), RiderNugetBundle.Companion.message("RiderNuGetLink.tooltip.search.this.package.with.google", new Object[0]), AllIcons.Actions.Search);
        }

        private final String j(String string) {
            return URLEncoder.encode(string, Charsets.UTF_8.name());
        }

        @NotNull
        public final List<HyperlinkLabel> createTagHyperlinks(@NotNull String tags, char delim, @NotNull String urlPrefix) {
            boolean bl;
            Collection collection;
            String string;
            Object t;
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            Intrinsics.checkNotNullParameter((Object)urlPrefix, (String)"urlPrefix");
            Object object = new char[]{delim};
            object = StringsKt.split$default((CharSequence)tags, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = false;
            Object object2 = object;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            boolean bl3 = false;
            Iterator iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                t = iterator2.next();
                string = (String)t;
                collection = collection2;
                bl = false;
                collection.add(((Object)StringsKt.trim((CharSequence)string)).toString());
            }
            object = (List)collection2;
            bl2 = false;
            object2 = object;
            collection2 = new ArrayList();
            bl3 = false;
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                t = iterator2.next();
                string = (String)t;
                bl = false;
                if (!(((CharSequence)string).length() > 0)) continue;
                collection2.add(t);
            }
            object = (List)collection2;
            bl2 = false;
            object2 = object;
            collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            bl3 = false;
            iterator2 = object2.iterator();
            while (iterator2.hasNext()) {
                HyperlinkLabel hyperlinkLabel2;
                t = iterator2.next();
                string = (String)t;
                collection = collection2;
                bl = false;
                String string2 = string;
                HyperlinkLabel hyperlinkLabel3 = hyperlinkLabel2 = new HyperlinkLabel(string2);
                boolean bl4 = false;
                hyperlinkLabel3.setHyperlinkTarget(urlPrefix + Companion.j(string));
                collection.add(hyperlinkLabel2);
            }
            return (List)collection2;
        }

        public static /* synthetic */ List createTagHyperlinks$default(Companion companion, String string, char c, String string2, int n2, Object object) {
            if ((n2 & 2) != 0) {
                c = (char)32;
            }
            if ((n2 & 4) != 0) {
                string2 = "https://www.nuget.org/packages?q=Tags%3A";
            }
            return companion.createTagHyperlinks(string, c, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

