/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import icons.ReSharperIcons;
import java.awt.Image;
import java.awt.Toolkit;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 ,2\u00020\u0001:\u0003,-.B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u0018\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u0011J\u0018\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0011H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000eH\u0002J\u001d\u0010&\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0018\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010+\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\b\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001d\u001a\u00020\u0011R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader;", "", "()V", "defaultErrorPackageIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "defaultPackageIcon", "fails", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Fail;", "getFails", "()Ljava/util/ArrayList;", "iconData", "", "", "", "iconDataSize", "", "icons", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "status", "getStatus", "()Ljava/lang/String;", "getIcon", "rdPackage", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "id", "iconPath", "size", "j", "hasLoadedIcon", "", "j", "bytes", "j", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$LoadedBytes;", "path", "j", "icon", "j", "Ljavax/swing/ImageIcon;", "data", "updateIcon", "Companion", "Fail", "LoadedBytes", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1549#2:161\n1620#2,3:162\n1#3:165\n*S KotlinDebug\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader\n*L\n148#1:161\n148#1:162,3\n*E\n"})
public final class RiderNuGetIconLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final Map<String, byte[]> iconData;
    @NotNull
    private final Map<String, Icon> icons;
    @NotNull
    private final Icon defaultPackageIcon;
    @NotNull
    private final Icon defaultErrorPackageIcon;
    private int iconDataSize;
    @NotNull
    private final ArrayList<Fail> fails;
    private static final int bigIconSize = 44;

    public RiderNuGetIconLoader() {
        Logger logger2 = Logger.getInstance(RiderNuGetIconLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        this.iconData = new HashMap();
        this.icons = new HashMap();
        Icon icon2 = ReSharperIcons.ProjectModel.NuGet;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"NuGet");
        this.defaultPackageIcon = icon2;
        Icon icon3 = ReSharperIcons.ProjectModel.NuGet;
        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"NuGet");
        this.defaultErrorPackageIcon = icon3;
        this.fails = new ArrayList();
    }

    @NotNull
    public final ArrayList<Fail> getFails() {
        return this.fails;
    }

    public final boolean hasLoadedIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        String string = rdPackage.getIconPath();
        return string == null || this.iconData.containsKey(string);
    }

    @NotNull
    public final Icon updateIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        String string;
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        if (!this.hasLoadedIcon(rdPackage) && (string = rdPackage.getIconPath()) != null) {
            Object object;
            this.iconData.put(string, null);
            LoadedBytes loadedBytes = this.j(string);
            if (loadedBytes.getBytes() == null) {
                String string2 = rdPackage.getId();
                Exception exception = loadedBytes.getException();
                Intrinsics.checkNotNull((Object)exception);
                object = new Fail(string2, string, exception);
                this.fails.add((Fail)object);
                this.logger.warn(((Fail)object).toString());
            }
            this.iconData.put(string, loadedBytes.getBytes());
            byte[] byArray = loadedBytes.getBytes();
            this.iconDataSize += byArray != null ? byArray.length : 0;
            if (loadedBytes.getBytes() != null) {
                object = rdPackage.getId();
                this.icons.put(this.j((String)object, Companion.getSmallIconSize()), this.j(loadedBytes.getBytes(), Companion.getSmallIconSize()));
                this.icons.put(this.j((String)object, 44), this.j(loadedBytes.getBytes(), 44));
            }
        }
        return this.getIcon(rdPackage);
    }

    @NotNull
    public final Icon updateIcon(@Nullable String id2, @Nullable String iconPath, int size) {
        if (id2 == null || iconPath == null) {
            return this.j(this.defaultPackageIcon, size);
        }
        if (!this.iconData.containsKey(iconPath)) {
            this.iconData.put(iconPath, null);
            LoadedBytes loadedBytes = this.j(iconPath);
            if (loadedBytes.getBytes() == null) {
                Exception exception = loadedBytes.getException();
                Intrinsics.checkNotNull((Object)exception);
                Fail fail = new Fail(id2, iconPath, exception);
                this.fails.add(fail);
                this.logger.warn(fail.toString());
            }
            this.iconData.put(iconPath, loadedBytes.getBytes());
            byte[] byArray = loadedBytes.getBytes();
            this.iconDataSize += byArray != null ? byArray.length : 0;
        }
        return this.getIcon(id2, iconPath, size);
    }

    private final String j(String string, int n2) {
        String string2 = (string + "-x" + n2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    @NotNull
    public final Icon getIcon(@NotNull RdNuGetSmartMetadata rdPackage) {
        Intrinsics.checkNotNullParameter((Object)rdPackage, (String)"rdPackage");
        return this.getIcon(rdPackage.getId(), rdPackage.getIconPath(), 44);
    }

    @NotNull
    public final Icon getIcon(@NotNull String id2, @Nullable String iconPath, int size) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        String string = this.j(id2, size);
        if (this.icons.containsKey(string) && (object = this.icons.get(string)) != null && object.getIconWidth() > 0 && object.getIconHeight() > 0) {
            return object;
        }
        if (this.iconData.containsKey(iconPath)) {
            byte[] byArray = this.iconData.get(iconPath);
            if (byArray == null) {
                return this.j(this.defaultErrorPackageIcon, size);
            }
            object = byArray;
            try {
                ImageIcon imageIcon = this.j((byte[])object, size);
                this.icons.put(string, imageIcon);
                if (imageIcon.getIconWidth() > 0 && imageIcon.getIconHeight() > 0) {
                    return imageIcon;
                }
            }
            catch (Exception exception) {
                String string2;
                if (iconPath != null) {
                    this.iconData.put(iconPath, null);
                }
                if ((string2 = iconPath) == null) {
                    string2 = "?";
                }
                this.logger.warn(new Fail(id2, string2, exception).toString());
                return this.j(this.defaultErrorPackageIcon, size);
            }
        }
        return this.j(this.defaultPackageIcon, size);
    }

    private final Icon j(Icon icon2, int n2) {
        Icon icon3 = icon2 instanceof ScalableIcon ? ((ScalableIcon)icon2).scale((float)n2 * 1.0f / (float)((ScalableIcon)icon2).getIconWidth()) : icon2;
        Intrinsics.checkNotNull((Object)icon3);
        return icon3;
    }

    private final ImageIcon j(byte[] byArray, int n2) {
        Image image = Toolkit.getDefaultToolkit().createImage(byArray).getScaledInstance(n2, n2, 4);
        boolean bl = false;
        return new ImageIcon(image);
    }

    private final LoadedBytes j(String string) {
        try {
            byte[] byArray = Files.readAllBytes(Paths.get(string, new String[0]));
            return new LoadedBytes(byArray, null);
        }
        catch (Exception exception) {
            return new LoadedBytes(null, exception);
        }
    }

    @NotNull
    public final String getStatus() {
        Collection collection;
        StringBuffer stringBuffer = new StringBuffer();
        Appendable appendable = ((Appendable)stringBuffer).append("*** RiderNuGetIconLoader ***");
        Intrinsics.checkNotNullExpressionValue((Object)appendable, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable.append('\n'), (String)"append(...)");
        Appendable appendable2 = ((Appendable)stringBuffer).append("Total cached icons     : " + this.icons.size());
        Intrinsics.checkNotNullExpressionValue((Object)appendable2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable2.append('\n'), (String)"append(...)");
        Appendable appendable3 = ((Appendable)stringBuffer).append("Total cached icon data : " + this.iconData.size());
        Intrinsics.checkNotNullExpressionValue((Object)appendable3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable3.append('\n'), (String)"append(...)");
        Appendable appendable4 = ((Appendable)stringBuffer).append("Failed icons           : " + this.fails.size());
        Intrinsics.checkNotNullExpressionValue((Object)appendable4, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable4.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)stringBuffer).append('\n'), (String)"append(...)");
        Appendable appendable5 = ((Appendable)stringBuffer).append("TotalIconDataSize : " + this.j(this.iconDataSize));
        Intrinsics.checkNotNullExpressionValue((Object)appendable5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable5.append('\n'), (String)"append(...)");
        Appendable appendable6 = ((Appendable)stringBuffer).append("AverageIconSize   : " + this.j(!this.icons.isEmpty() ? this.iconDataSize / this.icons.size() : 0));
        Intrinsics.checkNotNullExpressionValue((Object)appendable6, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable6.append('\n'), (String)"append(...)");
        Appendable appendable7 = stringBuffer;
        Iterable iterable = CollectionsKt.filterNotNull((Iterable)this.iconData.values());
        RiderNuGetIconLoader riderNuGetIconLoader = this;
        boolean bl = false;
        Object object = iterable;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            Object t = iterator2.next();
            byte[] byArray = (byte[])t;
            Collection collection3 = collection2;
            boolean bl3 = false;
            collection3.add(byArray.length);
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)collection2));
        Appendable appendable8 = appendable7.append("MaxIconSize       : " + riderNuGetIconLoader.j(n2 != null ? n2 : 0));
        Intrinsics.checkNotNullExpressionValue((Object)appendable8, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable8.append('\n'), (String)"append(...)");
        appendable7 = stringBuffer;
        Iterable iterable2 = this.iconData.entrySet();
        object = iterable2.iterator();
        if (!object.hasNext()) {
            collection = null;
        } else {
            collection2 = object.next();
            if (!object.hasNext()) {
                collection = collection2;
            } else {
                Map.Entry entry2 = (Map.Entry)((Object)collection2);
                boolean bl4 = false;
                byte[] byArray = (byte[])entry2.getValue();
                int n3 = byArray != null ? byArray.length : 0;
                do {
                    int n4;
                    Object e = object.next();
                    Map.Entry entry3 = (Map.Entry)e;
                    boolean bl5 = false;
                    byte[] byArray2 = (byte[])entry3.getValue();
                    int n5 = n4 = byArray2 != null ? byArray2.length : 0;
                    if (n3 >= n4) continue;
                    collection2 = e;
                    n3 = n4;
                } while (object.hasNext());
                collection = collection2;
            }
        }
        Map.Entry entry4 = (Map.Entry)((Object)collection);
        Appendable appendable9 = appendable7.append("BiggestIcon       : " + (entry4 != null ? (String)entry4.getKey() : null));
        Intrinsics.checkNotNullExpressionValue((Object)appendable9, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)appendable9.append('\n'), (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)stringBuffer).append('\n'), (String)"append(...)");
        String string = stringBuffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String j(int n2) {
        return n2 < 1024 ? n2 + " B" : (n2 < 0x100000 ? n2 / 1024 + " KB" : n2 / 1024 / 1024 + " MB " + n2 / 1024 % 1024 + " KB");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion;", "", "()V", "bigIconSize", "", "smallIconSize", "getSmallIconSize", "()I", "getInstance", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetIconLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion\n+ 2 ComponentContainerUtil.kt\ncom/jetbrains/rider/util/idea/ComponentContainerUtilKt\n*L\n1#1,160:1\n17#2,2:161\n*S KotlinDebug\n*F\n+ 1 RiderNuGetIconLoader.kt\ncom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Companion\n*L\n22#1:161,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderNuGetIconLoader getInstance() {
            ComponentManager componentManager = (ComponentManager)ApplicationKt.getApplication();
            boolean bl = false;
            Object object = componentManager.getService(RiderNuGetIconLoader.class);
            if (object == null) {
                throw new IllegalStateException("Service " + RiderNuGetIconLoader.class + " not found in container " + componentManager);
            }
            return (RiderNuGetIconLoader)object;
        }

        public final int getSmallIconSize() {
            return JBUI.scale((int)16);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\r\u0010\u0010\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0003J+\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\f\b\u0002\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0015\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$Fail;", "", "id", "", "url", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Exception;)V", "getException", "()Ljava/lang/Exception;", "getId", "()Ljava/lang/String;", "getUrl", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class Fail {
        @NotNull
        private final String id;
        @NotNull
        private final String url;
        @NotNull
        private final Exception exception;

        public Fail(@NotNull String id2, @NotNull String url2, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.id = id2;
            this.url = url2;
            this.exception = exception;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @NotNull
        public final Exception getException() {
            return this.exception;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.url;
        }

        @NotNull
        public final Exception component3() {
            return this.exception;
        }

        @NotNull
        public final Fail copy(@NotNull String id2, @NotNull String url2, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            return new Fail(id2, url2, exception);
        }

        public static /* synthetic */ Fail copy$default(Fail fail, String string, String string2, Exception exception, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = fail.id;
            }
            if ((n2 & 2) != 0) {
                string2 = fail.url;
            }
            if ((n2 & 4) != 0) {
                exception = fail.exception;
            }
            return fail.copy(string, string2, exception);
        }

        @NotNull
        public String toString() {
            return "Fail(id=" + this.id + ", url=" + this.url + ", exception=" + this.exception + ")";
        }

        public int hashCode() {
            int n2 = this.id.hashCode();
            n2 = n2 * 31 + this.url.hashCode();
            n2 = n2 * 31 + this.exception.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Fail)) {
                return false;
            }
            Fail fail = (Fail)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)fail.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)fail.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.exception, (Object)fail.exception);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetIconLoader$LoadedBytes;", "", "bytes", "", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "([BLjava/lang/Exception;)V", "getBytes", "()[B", "getException", "()Ljava/lang/Exception;", "intellij.rider"})
    private static final class LoadedBytes {
        @Nullable
        private final byte[] bytes;
        @Nullable
        private final Exception exception;

        public LoadedBytes(@Nullable byte[] bytes, @Nullable Exception exception) {
            this.bytes = bytes;
            this.exception = exception;
        }

        @Nullable
        public final byte[] getBytes() {
            return this.bytes;
        }

        @Nullable
        public final Exception getException() {
            return this.exception;
        }
    }
}

