/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.helpers;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.projectView.RiderOpenFileDescriptorKt;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u0000 \u00032\u00020\u0001:\u0003\u0003\u0004\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetConsoleHelper;", "", "()V", "Companion", "MessageFilter", "NavigateHyperlinkInfo", "intellij.rider"})
public final class RiderNuGetConsoleHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetConsoleHelper$Companion;", "", "()V", "createConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConsoleViewImpl createConsole(@NotNull Project project) {
            TextConsoleBuilder textConsoleBuilder;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            TextConsoleBuilder textConsoleBuilder2 = textConsoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
            boolean bl = false;
            textConsoleBuilder2.addFilter((Filter)new MessageFilter(project));
            ConsoleView consoleView = textConsoleBuilder.getConsole();
            Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
            return (ConsoleViewImpl)consoleView;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetConsoleHelper$MessageFilter;", "Lcom/intellij/execution/filters/Filter;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.rider"})
    private static final class MessageFilter
    implements Filter {
        @NotNull
        private final Project project;

        public MessageFilter(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            File file2;
            int n2;
            int n3;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            int n4 = 0;
            while (true) {
                if ((n3 = StringsKt.indexOf$default((CharSequence)line, (char)'\'', (int)n4, (boolean)false, (int)4, null)) == -1) {
                    return null;
                }
                n2 = StringsKt.indexOf$default((CharSequence)line, (char)'\'', (int)(n3 + 1), (boolean)false, (int)4, null);
                if (n2 == -1) {
                    return null;
                }
                String string = line.substring(n3 + 1, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                file2 = new File(string);
                if (file2.exists()) break;
                n4 = n2 + 1;
            }
            NavigateHyperlinkInfo navigateHyperlinkInfo = new NavigateHyperlinkInfo(file2);
            int n5 = entireLength - line.length();
            return new Filter.Result(n5 + n3 + 1, n5 + n2, (HyperlinkInfo)navigateHyperlinkInfo);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/nuget/helpers/RiderNuGetConsoleHelper$NavigateHyperlinkInfo;", "Lcom/intellij/execution/filters/HyperlinkInfo;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "getFile", "()Ljava/io/File;", "navigate", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    private static final class NavigateHyperlinkInfo
    implements HyperlinkInfo {
        @NotNull
        private final File file;

        public NavigateHyperlinkInfo(@NotNull File file2) {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            this.file = file2;
        }

        @NotNull
        public final File getFile() {
            return this.file;
        }

        public void navigate(@NotNull Project project) {
            Object[] objectArray;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (this.file.exists()) {
                if (this.file.isDirectory()) {
                    RevealFileAction.openDirectory((File)this.file);
                    return;
                }
                objectArray = VfsUtil.findFileByIoFile((File)this.file, (boolean)true);
                if (objectArray != null) {
                    RiderOpenFileDescriptorKt.withFirstFoundProjectModelId((Project)project, (VirtualFile)objectArray, (Function0)((Function0)new Function0<Unit>(project, (VirtualFile)objectArray){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ VirtualFile $virtualFile;
                        {
                            this.$project = $project;
                            this.$virtualFile = $virtualFile;
                            super(0);
                        }

                        public final void invoke() {
                            FileEditorManager.getInstance((Project)this.$project).openFile(this.$virtualFile, true, true);
                        }
                    }));
                    return;
                }
            }
            String string = RiderNugetBundle.Companion.message("notification.title.error", new Object[0]);
            objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)this.file.getAbsoluteFile(), (String)"getAbsoluteFile(...)");
            Notifications.Bus.notify((Notification)new Notification("System Messages", string, RiderNugetBundle.Companion.message("RiderNuGetConsoleHelper.notification.content.there.no.such.path", objectArray), NotificationType.ERROR), (Project)project);
        }
    }
}

