/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.credentials.providers;

import com.intellij.openapi.project.Project;
import com.jetbrains.rider.nuget.statistics.RiderNuGetStatisticsCollector;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u000f\u001a\u00060\u0010j\u0002`\u0011R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/nuget/credentials/providers/FeedTypeStatisticsReporter;", "", "()V", "SupportedTargetHosts", "", "", "artifactory", "byteSafeHost", "cloudSmithHost", "githubHost", "gitlab", "spaceFeedHost", "teamCityCloudHost", "isVstsEndpoint", "", "uri", "Ljava/net/URI;", "Lcom/jetbrains/rd/util/URI;", "reportFeedStatistic", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nFeedTypeStatisticsReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeedTypeStatisticsReporter.kt\ncom/jetbrains/rider/nuget/credentials/providers/FeedTypeStatisticsReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,36:1\n1747#2,3:37\n*S KotlinDebug\n*F\n+ 1 FeedTypeStatisticsReporter.kt\ncom/jetbrains/rider/nuget/credentials/providers/FeedTypeStatisticsReporter\n*L\n21#1:37,3\n*E\n"})
public final class FeedTypeStatisticsReporter {
    @NotNull
    public static final FeedTypeStatisticsReporter INSTANCE = new FeedTypeStatisticsReporter();
    @NotNull
    private static final String spaceFeedHost = "jetbrains.space";
    @NotNull
    private static final String githubHost = "pkg.github.com";
    @NotNull
    private static final String byteSafeHost = "bytesafe.dev";
    @NotNull
    private static final String gitlab = "gitlab";
    @NotNull
    private static final String teamCityCloudHost = "teamcity.com";
    @NotNull
    private static final String cloudSmithHost = "cloudsmith.io";
    @NotNull
    private static final String artifactory = "artifactory";
    @NotNull
    private static final List<String> SupportedTargetHosts;

    private FeedTypeStatisticsReporter() {
    }

    public final boolean isVstsEndpoint(@NotNull URI uri) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Iterable iterable = SupportedTargetHosts;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl3 = false;
                    String string2 = uri.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
                    if (!StringsKt.endsWith((String)string2, (String)string, (boolean)true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void reportFeedStatistic(@NotNull Project project, @NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        String string = uri.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        if (StringsKt.endsWith((String)string, (String)spaceFeedHost, (boolean)true)) {
            RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Space);
        } else {
            String string2 = uri.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            if (StringsKt.endsWith((String)string2, (String)githubHost, (boolean)true)) {
                RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Github);
            } else {
                String string3 = uri.getHost();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getHost(...)");
                if (StringsKt.endsWith((String)string3, (String)byteSafeHost, (boolean)true)) {
                    RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Bytesafe);
                } else {
                    String string4 = uri.getHost();
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getHost(...)");
                    if (StringsKt.endsWith((String)string4, (String)teamCityCloudHost, (boolean)true)) {
                        RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.TeamCity);
                    } else {
                        String string5 = uri.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getHost(...)");
                        if (StringsKt.endsWith((String)string5, (String)cloudSmithHost, (boolean)true)) {
                            RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.CloudSmith);
                        } else if (this.isVstsEndpoint(uri)) {
                            RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Azure);
                        } else {
                            String string6 = uri.getHost();
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getHost(...)");
                            if (StringsKt.contains((CharSequence)string6, (CharSequence)gitlab, (boolean)true)) {
                                RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Gitlab);
                            } else {
                                String string7 = uri.getHost();
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getHost(...)");
                                if (StringsKt.contains((CharSequence)string7, (CharSequence)artifactory, (boolean)true)) {
                                    RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Artifactory);
                                } else {
                                    RiderNuGetStatisticsCollector.INSTANCE.reportCloudHost(project, RiderNuGetStatisticsCollector.CloudHost.Other);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    static {
        Object[] objectArray = new String[]{".pkgs.visualstudio.com", "pkgs.dev.azure.com"};
        SupportedTargetHosts = CollectionsKt.listOf((Object[])objectArray);
    }
}

