/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.configs;

import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedManager;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\rR/\u0010\u0005\u001a#\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0012\f\u0012\n \b*\u0004\u0018\u00010\t0\t0\u0006\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedColorManager;", "", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "(Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;)V", "colorMap", "Ljava/util/HashMap;", "", "kotlin.jvm.PlatformType", "Ljava/awt/Color;", "Lorg/jetbrains/annotations/NotNull;", "feeds", "", "Lcom/jetbrains/rider/model/RdNuGetFeed;", "j", "()Ljava/util/List;", "j", "", "getColor", "feed", "Companion", "intellij.rider"})
public final class RiderNuGetFeedColorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RiderNuGetFeedManager feedManager;
    @NotNull
    private final HashMap<String, Color> colorMap;
    @NotNull
    private static final Color[] sourceColors;

    public RiderNuGetFeedColorManager(@NotNull RiderNuGetFeedManager feedManager) {
        Intrinsics.checkNotNullParameter((Object)feedManager, (String)"feedManager");
        this.feedManager = feedManager;
        HashMap hashMap = ContainerUtil.newHashMap();
        Intrinsics.checkNotNullExpressionValue((Object)hashMap, (String)"newHashMap(...)");
        this.colorMap = hashMap;
        this.j();
        this.feedManager.addListChangesListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.j();
            }
        }));
    }

    private final List<RdNuGetFeed> j() {
        return this.feedManager.getAllFeeds();
    }

    private final void j() {
        this.colorMap.clear();
        int n2 = 0;
        for (RdNuGetFeed rdNuGetFeed : this.j()) {
            Color color = null;
            if (n2 >= sourceColors.length) {
                Color color2;
                double d = (double)(n2 / sourceColors.length) / (double)(this.j().size() / sourceColors.length);
                Intrinsics.checkNotNullExpressionValue((Object)ColorUtil.mix((Color)sourceColors[n2 % sourceColors.length], (Color)sourceColors[(n2 + 1) % sourceColors.length], (double)d), (String)"mix(...)");
                int n3 = (int)(Math.abs(d - 0.5) * 2.0 * (double)(this.j().size() / sourceColors.length) + 1.0);
                color = (Color)new JBColor(ColorUtil.darker((Color)color2, (int)n3), ColorUtil.brighter((Color)color2, (int)(2 * n3)));
            } else {
                Color color3 = sourceColors[n2];
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"get(...)");
                color = color3;
            }
            ++n2;
            this.colorMap.put(rdNuGetFeed.getFeedId(), color);
        }
    }

    @NotNull
    public final Color getColor(@NotNull RdNuGetFeed feed) {
        Intrinsics.checkNotNullParameter((Object)feed, (String)"feed");
        Color color = this.colorMap.get(feed.getFeedId());
        if (color == null) {
            color = RiderNuGetFeedColorManager.Companion.j();
        }
        Color color2 = color;
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    static {
        Color[] colorArray = new Color[]{JBColor.GREEN, JBColor.ORANGE, JBColor.CYAN, JBColor.MAGENTA, JBColor.PINK, JBColor.YELLOW, JBColor.BLUE};
        sourceColors = colorArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00040\u00040\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedColorManager$Companion;", "", "()V", "defaultRootColor", "Ljava/awt/Color;", "j", "()Ljava/awt/Color;", "sourceColors", "", "kotlin.jvm.PlatformType", "[Ljava/awt/Color;", "getBackgroundColor", "Lcom/intellij/ui/JBColor;", "baseRootColor", "getIndicatorColor", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        private final Color j() {
            Color color = UIUtil.getTableBackground();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getTableBackground(...)");
            return color;
        }

        @NotNull
        public final JBColor getBackgroundColor(@NotNull Color baseRootColor) {
            Intrinsics.checkNotNullParameter((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor(() -> Companion.j(baseRootColor));
        }

        @NotNull
        public final JBColor getIndicatorColor(@NotNull Color baseRootColor) {
            Intrinsics.checkNotNullParameter((Object)baseRootColor, (String)"baseRootColor");
            return new JBColor(() -> Companion.N(baseRootColor));
        }

        private static final Color j(Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"$baseRootColor");
            return ColorUtil.mix((Color)color, (Color)UIUtil.getTableBackground(), (double)0.75);
        }

        private static final Color N(Color color) {
            Intrinsics.checkNotNullParameter((Object)color, (String)"$baseRootColor");
            return UIUtil.isUnderDarcula() ? color : ColorUtil.darker((Color)ColorUtil.softer((Color)color), (int)3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

