/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget.configs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBList;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rider.model.RdNuGetConfigFile;
import com.jetbrains.rider.nuget.RiderNuGetFacade;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigListState;
import com.jetbrains.rider.nuget.configs.RiderNuGetConfigRenderer;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u001a\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00022\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigList;", "Lcom/intellij/ui/components/JBList;", "Lcom/jetbrains/rider/model/RdNuGetConfigFile;", "facade", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "(Lcom/jetbrains/rider/nuget/RiderNuGetFacade;)V", "getFacade", "()Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "lastSelectedConfigFilePath", "", "onConfigSelection", "Lcom/jetbrains/rd/util/reactive/Signal;", "getOnConfigSelection", "()Lcom/jetbrains/rd/util/reactive/Signal;", "riderModel", "Ljavax/swing/DefaultListModel;", "getRiderModel", "()Ljavax/swing/DefaultListModel;", "applyState", "", "state", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetConfigListState;", "getState", "j", "config", "focusEditor", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetConfigList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetConfigList.kt\ncom/jetbrains/rider/nuget/configs/RiderNuGetConfigList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n350#2,7:82\n*S KotlinDebug\n*F\n+ 1 RiderNuGetConfigList.kt\ncom/jetbrains/rider/nuget/configs/RiderNuGetConfigList\n*L\n59#1:82,7\n*E\n"})
public final class RiderNuGetConfigList
extends JBList<RdNuGetConfigFile> {
    @NotNull
    private final RiderNuGetFacade facade;
    @NotNull
    private final Signal<RdNuGetConfigFile> onConfigSelection;
    @Nullable
    private String lastSelectedConfigFilePath;

    public RiderNuGetConfigList(@NotNull RiderNuGetFacade facade) {
        Intrinsics.checkNotNullParameter((Object)facade, (String)"facade");
        super((Collection)CollectionsKt.emptyList());
        this.facade = facade;
        this.onConfigSelection = new Signal();
        this.setCellRenderer((ListCellRenderer)((Object)new RiderNuGetConfigRenderer()));
        this.setSelectionMode(0);
        this.getEmptyText().setText("There are no config files");
        this.addListSelectionListener(arg_0 -> RiderNuGetConfigList.j(this, arg_0));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(@Nullable KeyEvent e) {
                KeyEvent keyEvent = e;
                boolean bl = keyEvent != null ? keyEvent.getKeyCode() == 10 : false;
                if (bl && this.getSelectedIndex() >= 0) {
                    RdNuGetConfigFile rdNuGetConfigFile = (RdNuGetConfigFile)this.getSelectedValue();
                    Intrinsics.checkNotNull((Object)rdNuGetConfigFile);
                    this.j(rdNuGetConfigFile, true);
                }
            }
        });
        TreeUIHelper.getInstance().installListSpeedSearch((JList)((Object)this));
    }

    @NotNull
    public final RiderNuGetFacade getFacade() {
        return this.facade;
    }

    @NotNull
    public final DefaultListModel<RdNuGetConfigFile> getRiderModel() {
        ListModel listModel2 = this.getModel();
        Intrinsics.checkNotNull((Object)listModel2, (String)"null cannot be cast to non-null type javax.swing.DefaultListModel<com.jetbrains.rider.model.RdNuGetConfigFile>");
        return (DefaultListModel)listModel2;
    }

    @NotNull
    public final Signal<RdNuGetConfigFile> getOnConfigSelection() {
        return this.onConfigSelection;
    }

    public final void applyState(@NotNull RiderNuGetConfigListState state) {
        int n2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Enumeration<RdNuGetConfigFile> enumeration = this.getRiderModel().elements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"elements(...)");
            ArrayList<RdNuGetConfigFile> arrayList = Collections.list(enumeration);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
            List list2 = arrayList;
            boolean bl = false;
            int n3 = 0;
            for (Object e : list2) {
                RdNuGetConfigFile rdNuGetConfigFile = (RdNuGetConfigFile)e;
                boolean bl2 = false;
                if (Intrinsics.areEqual((Object)rdNuGetConfigFile.getConfigFilePath(), (Object)state.getSelectedConfigFilePath())) {
                    n2 = n3;
                    break block2;
                }
                ++n3;
            }
            n2 = -1;
        }
        int n4 = n2;
        this.setSelectedIndex(Math.max(n4, 0));
    }

    @NotNull
    public final RiderNuGetConfigListState getState() {
        RdNuGetConfigFile rdNuGetConfigFile = (RdNuGetConfigFile)this.getSelectedValue();
        return new RiderNuGetConfigListState(rdNuGetConfigFile != null ? rdNuGetConfigFile.getConfigFilePath() : null);
    }

    private final void j(RdNuGetConfigFile rdNuGetConfigFile, boolean bl) {
        String string = rdNuGetConfigFile.getConfigFilePath();
        if (string == null) {
            return;
        }
        String string2 = string;
        VirtualFile virtualFile2 = VfsUtil.findFileByIoFile((File)new File(string2), (boolean)true);
        if (virtualFile2 == null) {
            Object[] objectArray = new Object[]{string2};
            Notifications.Bus.notify((Notification)new Notification("System Messages", RiderNugetBundle.Companion.message("notification.title.error", new Object[0]), RiderNugetBundle.Companion.message("RiderNuGetConfigList.notification.content.there.no.such.file", objectArray), NotificationType.ERROR), (Project)this.facade.getProject());
        } else {
            FileEditorManager.getInstance((Project)this.facade.getProject()).openFile(virtualFile2, bl, true);
        }
    }

    static /* synthetic */ void openFile$default(RiderNuGetConfigList riderNuGetConfigList, RdNuGetConfigFile rdNuGetConfigFile, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        riderNuGetConfigList.j(rdNuGetConfigFile, bl);
    }

    private static final void j(RiderNuGetConfigList riderNuGetConfigList, ListSelectionEvent listSelectionEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderNuGetConfigList), (String)"this$0");
        if (riderNuGetConfigList.getSelectedIndex() >= 0) {
            RdNuGetConfigFile rdNuGetConfigFile = (RdNuGetConfigFile)riderNuGetConfigList.getSelectedValue();
            if (rdNuGetConfigFile != null && !Intrinsics.areEqual((Object)riderNuGetConfigList.lastSelectedConfigFilePath, (Object)rdNuGetConfigFile.getConfigFilePath())) {
                riderNuGetConfigList.lastSelectedConfigFilePath = rdNuGetConfigFile.getConfigFilePath();
                RiderNuGetConfigList.openFile$default(riderNuGetConfigList, rdNuGetConfigFile, false, 2, null);
            }
            Signal<RdNuGetConfigFile> signal = riderNuGetConfigList.onConfigSelection;
            Intrinsics.checkNotNull((Object)rdNuGetConfigFile);
            signal.fire((Object)rdNuGetConfigFile);
        }
    }
}

