/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.nuget;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.UserDataHolder;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.model.RdNuGetDependencyBehavior;
import com.jetbrains.rider.model.RdNuGetFeed;
import com.jetbrains.rider.model.RdNuGetHost;
import com.jetbrains.rider.model.RdNuGetHost_PregeneratedKt;
import com.jetbrains.rider.model.RdNuGetInstallOneRequest;
import com.jetbrains.rider.model.RdNuGetInstallRequest;
import com.jetbrains.rider.model.RdNuGetNotificationMode;
import com.jetbrains.rider.model.RdNuGetOperator;
import com.jetbrains.rider.model.RdNuGetPackageIdentity;
import com.jetbrains.rider.model.RdNuGetPackageMetadata;
import com.jetbrains.rider.model.RdNuGetProject;
import com.jetbrains.rider.model.RdNuGetProjects;
import com.jetbrains.rider.model.RdNuGetRemoteVersion;
import com.jetbrains.rider.model.RdNuGetRemovePackageVersionResult;
import com.jetbrains.rider.model.RdNuGetRestoreRequest;
import com.jetbrains.rider.model.RdNuGetRestoreRequestSource;
import com.jetbrains.rider.model.RdNuGetRestoreStrategy;
import com.jetbrains.rider.model.RdNuGetSmartMetadata;
import com.jetbrains.rider.model.RdNuGetStateInfo;
import com.jetbrains.rider.model.RdNuGetUltraConfig;
import com.jetbrains.rider.model.RdNuGetUninstallRequest;
import com.jetbrains.rider.model.RdNuGetUpdateAllRequest;
import com.jetbrains.rider.nuget.RiderNuGetExtensionsKt;
import com.jetbrains.rider.nuget.RiderNuGetProjectModel;
import com.jetbrains.rider.nuget.RiderNuGetViewSettings;
import com.jetbrains.rider.nuget.RiderNugetBundle;
import com.jetbrains.rider.nuget.configs.RiderNuGetFeedManager;
import com.jetbrains.rider.nuget.confirmations.RiderNuGetInstallConfirmationDialog;
import com.jetbrains.rider.nuget.helpers.RiderNuGetConstants;
import com.jetbrains.rider.nuget.helpers.RiderNuGetNotifier;
import com.jetbrains.rider.nuget.helpers.RiderNuGetProjects;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u0098\u00012\u00020\u0001:\u0002\u0098\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010Q\u001a\u00020+2\u0006\u0010R\u001a\u00020\u000e2\u0006\u0010S\u001a\u00020TH\u0002J\u000e\u0010U\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u000eJ\u0016\u0010W\u001a\u00020X2\u0006\u0010V\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020\u000eJ\u0006\u0010Z\u001a\u00020\u0019J\u0006\u0010[\u001a\u00020\u0019J\u0010\u0010\\\u001a\u00020\u00192\b\b\u0002\u0010]\u001a\u00020^J\f\u0010_\u001a\b\u0012\u0004\u0012\u00020\n0\u001dJ\b\u0010`\u001a\u0004\u0018\u00010\u000eJ\u000e\u0010a\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\nJ\u0014\u0010b\u001a\u00020+2\f\u0010c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u0006\u0010d\u001a\u00020+J\u001e\u0010e\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\u0006\u0010V\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020\u000eJ\u0016\u0010f\u001a\u00020\u00192\u0006\u0010V\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020\u000eJ\u001e\u0010g\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\u000e2\u0006\u0010Y\u001a\u00020\u000eJ\u000e\u0010h\u001a\u00020+2\u0006\u0010i\u001a\u00020\u000eJ\u0006\u0010j\u001a\u00020\u0019J\"\u0010k\u001a\u00020\u00192\u0006\u0010l\u001a\u00020m2\b\b\u0002\u0010]\u001a\u00020^2\b\b\u0002\u0010n\u001a\u00020oJ$\u0010p\u001a\u00020\u00192\b\b\u0002\u0010q\u001a\u00020r2\u0012\u0010s\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00190tJ\u0006\u0010u\u001a\u00020\u0019J\u000e\u0010v\u001a\u00020\u00192\u0006\u0010w\u001a\u00020xJ\u000e\u0010y\u001a\u00020\u00192\u0006\u0010z\u001a\u00020\u000eJ\u000e\u0010{\u001a\u00020\u00192\u0006\u0010|\u001a\u00020+J\u000e\u0010}\u001a\u00020\u00192\u0006\u0010~\u001a\u00020+J\u000f\u0010\u007f\u001a\u00020\u00192\u0007\u0010\u0080\u0001\u001a\u00020+J\u0010\u0010\u0081\u0001\u001a\u00020\u00192\u0007\u0010\u0082\u0001\u001a\u00020\u000eJ\u0018\u0010\u0083\u0001\u001a\u00020\u00192\u0006\u0010R\u001a\u00020\u000e2\u0007\u0010\u0084\u0001\u001a\u00020\nJ\u0011\u0010\u0085\u0001\u001a\u00020\u00192\b\b\u0002\u0010]\u001a\u00020^J'\u0010\u0086\u0001\u001a\u00020\u000e\"\u000b\b\u0000\u0010\u0087\u0001\u0018\u0001*\u00020\u00012\u000e\u0010\u0088\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0087\u00010*H\u0082\bJ\u0007\u0010\u0089\u0001\u001a\u00020\u0019J\u0017\u0010\u008a\u0001\u001a\u00020\u00192\u0006\u0010A\u001a\u00020\u00062\u0006\u0010R\u001a\u00020\u000eJ\u000f\u0010\u008b\u0001\u001a\u00020\u00192\u0006\u0010R\u001a\u00020\u000eJ\u0017\u0010\u008c\u0001\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\u000eJ\u0010\u0010\u008d\u0001\u001a\u00020\u00192\u0007\u0010\u008e\u0001\u001a\u00020+J'\u0010\u008f\u0001\u001a\u00020\u00192\t\b\u0002\u0010\u0090\u0001\u001a\u00020+2\t\b\u0002\u0010\u0091\u0001\u001a\u00020+2\b\b\u0002\u0010q\u001a\u00020rJ\u0007\u0010\u0092\u0001\u001a\u00020\u0019J\u0007\u0010\u0093\u0001\u001a\u00020\u0019J\r\u0010\u0094\u0001\u001a\u00020+*\u00020\u001eH\u0002J\r\u0010\u0094\u0001\u001a\u00020+*\u00020\u000eH\u0002J\u0017\u0010\u0095\u0001\u001a\u00020+*\u00020\u001e2\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010,R\u0011\u0010-\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u000204\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010=\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b?\u0010@R\u0011\u0010A\u001a\u00020B\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010DR\u000e\u0010E\u001a\u00020FX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010G\u001a\b\u0012\u0004\u0012\u00020\n0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010\u001bR\u0011\u0010I\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010\u0010R\u0011\u0010K\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010\u0010R\u0011\u0010M\u001a\u00020N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010P\u00a8\u0006\u0099\u0001"}, d2={"Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "allProjects", "Lcom/jetbrains/rider/model/RdNuGetProjects;", "getAllProjects", "()Lcom/jetbrains/rider/model/RdNuGetProjects;", "contextProjectId", "", "getContextProjectId", "()I", "contextProjectTitle", "", "getContextProjectTitle", "()Ljava/lang/String;", "contextUniqueProjectTitle", "getContextUniqueProjectTitle", "feedManager", "Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "getFeedManager", "()Lcom/jetbrains/rider/nuget/configs/RiderNuGetFeedManager;", "focusSearchBox", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getFocusSearchBox", "()Lcom/jetbrains/rd/util/reactive/Signal;", "foundPackages", "", "Lcom/jetbrains/rider/model/RdNuGetSmartMetadata;", "getFoundPackages", "()Ljava/util/List;", "helpAction", "Lcom/intellij/ide/actions/ContextHelpAction;", "getHelpAction", "()Lcom/intellij/ide/actions/ContextHelpAction;", "host", "Lcom/jetbrains/rider/model/RdNuGetHost;", "getHost", "()Lcom/jetbrains/rider/model/RdNuGetHost;", "isBusy", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "()Lcom/jetbrains/rd/util/reactive/IOptProperty;", "isBusyRightNow", "()Z", "lifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "notifier", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier;", "getNotifier", "()Lcom/jetbrains/rider/nuget/helpers/RiderNuGetNotifier;", "operator", "Lcom/jetbrains/rider/model/RdNuGetOperator;", "getOperator", "()Lcom/jetbrains/rider/model/RdNuGetOperator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectModel", "Lcom/jetbrains/rider/nuget/RiderNuGetProjectModel;", "getProjectModel", "()Lcom/jetbrains/rider/nuget/RiderNuGetProjectModel;", "projects", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects;", "getProjects", "()Lcom/jetbrains/rider/nuget/helpers/RiderNuGetProjects;", "runTaskCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "selectPanel", "getSelectPanel", "targetPackageFeedId", "getTargetPackageFeedId", "targetPackageId", "getTargetPackageId", "viewSettings", "Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "getViewSettings", "()Lcom/jetbrains/rider/nuget/RiderNuGetViewSettings;", "j", "packageId", "properties", "Lcom/intellij/ide/util/PropertiesComponent;", "choosePackage", "id", "choosePackageAndWait", "Lcom/jetbrains/rider/model/RdNuGetPackageMetadata;", "version", "clearCache", "clearChosenPackage", "forceRestore", "strategy", "Lcom/jetbrains/rider/model/RdNuGetRestoreStrategy;", "getContextProjectIds", "getErrorMessageUltraConfig", "getUniqueProjectNameById", "hasUpdates", "packages", "hasUpdatesInContext", "install", "installForAllProjects", "installForProject", "isNuGetOrgFeed", "feedId", "readNuGetConfig", "restore", "mode", "Lcom/jetbrains/rider/model/RdNuGetNotificationMode;", "source", "Lcom/jetbrains/rider/model/RdNuGetRestoreRequestSource;", "runAndWait", "timeout", "Ljava/time/Duration;", "action", "Lkotlin/Function1;", "selectPackagesPanel", "setDependencyBehaviour", "behaviour", "Lcom/jetbrains/rider/model/RdNuGetDependencyBehavior;", "setFeedByName", "feedName", "setForceRemoveOption", "forceRemove", "setIncludePrerelease", "value", "setRemoveDependenciesOption", "removeDependencies", "setSearchTerm", "term", "showLastPackageVersionDialog", "projectId", "silentRestore", "j", "T", "property", "toggleIncludePrerelease", "uninstall", "uninstallFromAllProjects", "uninstallFromProject", "upgradeAllInContext", "confirmation", "waitForSteadyState", "clearCaches", "validConfig", "zeroLatencyUpdate", "zeroLatencyUpdateAndWait", "j", "j", "installedPackage", "Lcom/jetbrains/rider/model/RdNuGetPackageIdentity;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderNuGetFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,314:1\n1747#2,3:315\n288#2,2:318\n1549#2:320\n1620#2,3:321\n1747#2,3:324\n1726#2,3:329\n1747#2,3:332\n1855#2,2:335\n766#2:337\n857#2:338\n288#2,2:339\n858#2:341\n288#2,2:342\n288#2,2:344\n1064#3,2:327\n*S KotlinDebug\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade\n*L\n103#1:315,3\n111#1:318,2\n133#1:320\n133#1:321,3\n139#1:324,3\n146#1:329,3\n150#1:332,3\n171#1:335,2\n181#1:337\n181#1:338\n185#1:339,2\n181#1:341\n283#1:342,2\n161#1:344,2\n143#1:327,2\n*E\n"})
public final class RiderNuGetFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final LifetimeDefinition lifetime;
    @NotNull
    private final RdNuGetHost host;
    @NotNull
    private final RdNuGetOperator operator;
    @NotNull
    private final RiderNuGetNotifier notifier;
    @NotNull
    private final RiderNuGetProjects projects;
    @NotNull
    private final RiderNuGetFeedManager feedManager;
    @NotNull
    private final Signal<Unit> focusSearchBox;
    @NotNull
    private final Signal<Integer> selectPanel;
    @NotNull
    private final AtomicInteger runTaskCount;
    @NotNull
    private final ContextHelpAction helpAction;
    @NotNull
    private static final String LAST_PACKAGE_VERSION_DIALOG_PROPERTY = "lastPackageVersionDialogProperty";

    public RiderNuGetFacade(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.lifetime = UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.host = RdNuGetHost_PregeneratedKt.getNuGetHost((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project));
        this.operator = this.host.getNuGetOperator();
        this.notifier = new RiderNuGetNotifier(this.project);
        this.projects = new RiderNuGetProjects(this.project);
        this.feedManager = new RiderNuGetFeedManager((Lifetime)this.lifetime, this.host.getConfigManager());
        this.focusSearchBox = Signal.Companion.Void();
        this.selectPanel = new Signal();
        this.runTaskCount = new AtomicInteger();
        this.helpAction = new ContextHelpAction("Reference_Windows_NuGet");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final LifetimeDefinition getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final RdNuGetHost getHost() {
        return this.host;
    }

    @NotNull
    public final RdNuGetOperator getOperator() {
        return this.operator;
    }

    @NotNull
    public final RiderNuGetNotifier getNotifier() {
        return this.notifier;
    }

    @NotNull
    public final RiderNuGetProjects getProjects() {
        return this.projects;
    }

    @NotNull
    public final RiderNuGetFeedManager getFeedManager() {
        return this.feedManager;
    }

    @NotNull
    public final RiderNuGetViewSettings getViewSettings() {
        return RiderNuGetViewSettings.Companion.getInstance(this.project);
    }

    @NotNull
    public final RiderNuGetProjectModel getProjectModel() {
        return RiderNuGetProjectModel.Companion.getInstance(this.project);
    }

    @NotNull
    public final Signal<Unit> getFocusSearchBox() {
        return this.focusSearchBox;
    }

    @NotNull
    public final Signal<Integer> getSelectPanel() {
        return this.selectPanel;
    }

    public final void selectPackagesPanel() {
        this.selectPanel.fire((Object)0);
    }

    @NotNull
    public final IOptProperty<Boolean> isBusy() {
        return this.operator.isBusy();
    }

    public final boolean isBusyRightNow() {
        return (Boolean)InterfacesKt.valueOrDefault(this.isBusy(), (Object)true);
    }

    public final int getContextProjectId() {
        return ((Number)InterfacesKt.valueOrDefault((IOptProperty)this.host.getContextProjectId(), (Object)-1)).intValue();
    }

    @NotNull
    public final String getContextProjectTitle() {
        return this.getProjectModel().getProjectNameById(this.getContextProjectId());
    }

    @NotNull
    public final String getContextUniqueProjectTitle() {
        return this.getUniqueProjectNameById(this.getContextProjectId());
    }

    @NotNull
    public final List<RdNuGetSmartMetadata> getFoundPackages() {
        return (List)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), RiderNuGetConstants.Companion.getEmptyPackages());
    }

    @NotNull
    public final String getTargetPackageId() {
        return (String)InterfacesKt.valueOrDefault((IOptProperty)this.host.getTargetPackageId(), (Object)"");
    }

    @NotNull
    public final String getTargetPackageFeedId() {
        return (String)InterfacesKt.valueOrDefault((IOptProperty)this.host.getTargetPackageFeedId(), (Object)"");
    }

    public final void choosePackage(@NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (!Intrinsics.areEqual((Object)this.getTargetPackageId(), (Object)id2)) {
            this.host.getTargetPackageId().set((Object)id2);
            this.zeroLatencyUpdate();
        }
    }

    @NotNull
    public final RdNuGetPackageMetadata choosePackageAndWait(@NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        LifetimeDefinition lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        this.host.getChosenPackageMeta().advise(lifetimeDefinition.getLifetime(), (Function1)new Function1<RdNuGetPackageMetadata, Unit>((Ref.ObjectRef<RdNuGetPackageMetadata>)objectRef, lifetimeDefinition){
            final /* synthetic */ Ref.ObjectRef<RdNuGetPackageMetadata> $view;
            final /* synthetic */ LifetimeDefinition $lifetimeDef;
            {
                this.$view = $view;
                this.$lifetimeDef = $lifetimeDef;
                super(1);
            }

            public final void invoke(@Nullable RdNuGetPackageMetadata it) {
                if (it != null) {
                    this.$view.element = it;
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$lifetimeDef, (boolean)false, (int)1, null);
                }
            }
        });
        this.choosePackage(id2);
        Lifetime lifetime2 = (Lifetime)this.lifetime;
        Function0 function0 = (Function0)new Function0<Boolean>((Ref.ObjectRef<RdNuGetPackageMetadata>)objectRef){
            final /* synthetic */ Ref.ObjectRef<RdNuGetPackageMetadata> $view;
            {
                this.$view = $view;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$view.element != null;
            }
        };
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump$default((Lifetime)lifetime2, (Function0)function0, (Duration)duration, null, (int)8, null);
        Object object = objectRef.element;
        Intrinsics.checkNotNull((Object)object);
        return (RdNuGetPackageMetadata)object;
    }

    public final void setRemoveDependenciesOption(boolean removeDependencies) {
        this.host.getRemoveDependencies().set((Object)removeDependencies);
    }

    public final void setForceRemoveOption(boolean forceRemove) {
        this.host.getForceRemove().set((Object)forceRemove);
    }

    public final void setDependencyBehaviour(@NotNull RdNuGetDependencyBehavior behaviour) {
        Intrinsics.checkNotNullParameter((Object)behaviour, (String)"behaviour");
        this.host.getDependencyBehavior().set((Object)behaviour);
    }

    public final void readNuGetConfig() {
        InterfacesKt.fire((ISignal)this.host.getConfigManager().getReload());
    }

    public final void clearChosenPackage() {
        this.choosePackage("");
    }

    public final void clearCache() {
        InterfacesKt.fire((ISignal)this.host.getClearCache());
    }

    public final void setSearchTerm(@NotNull String term) {
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        this.host.getSearchTerm().set((Object)term);
    }

    @NotNull
    public final RdNuGetProjects getAllProjects() {
        return new RdNuGetProjects(this.projects.getAllProjectIds());
    }

    public final boolean hasUpdates(@NotNull List<RdNuGetSmartMetadata> packages) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(packages, (String)"packages");
            Iterable iterable = packages;
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata = (RdNuGetSmartMetadata)t;
                    boolean bl3 = false;
                    if (!rdNuGetSmartMetadata.getCanBeUpdated()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final String getUniqueProjectNameById(int id2) {
        Object v1;
        Object object;
        List<ProjectModelEntity> list2;
        block2: {
            if (id2 == -1) {
                return "Solution";
            }
            list2 = this.projects.getAllProjectEntities();
            object = list2;
            boolean bl = false;
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                Object t = iterator2.next();
                ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
                boolean bl2 = false;
                Integer n2 = ProjectModelEntityExtensionsKt.getId((ProjectModelEntity)projectModelEntity, (Project)this.project);
                int n3 = id2;
                if (!(n2 != null && n2 == n3)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        ProjectModelEntity projectModelEntity = v1;
        object = ProjectModelEntityExtensionsKt.withUniqueNames(list2, (Project)this.project);
        return object.getOrDefault(projectModelEntity, "Loading...");
    }

    public final void zeroLatencyUpdate() {
        InterfacesKt.fire((ISignal)this.host.getZeroLatencyUpdate());
    }

    public final void zeroLatencyUpdateAndWait() {
        LifetimeDefinition lifetimeDefinition = Lifetime.Companion.getEternal().createNested();
        Lifetime lifetime2 = lifetimeDefinition.getLifetime();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        this.host.getZeroLatencyUpdateFinished().advise(lifetime2, (Function1)new Function1<Unit, Unit>(booleanRef){
            final /* synthetic */ Ref.BooleanRef $updated;
            {
                this.$updated = $updated;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$updated.element = true;
            }
        });
        InterfacesKt.fire((ISignal)this.host.getZeroLatencyUpdate());
        Function0 function0 = (Function0)new Function0<Boolean>(booleanRef){
            final /* synthetic */ Ref.BooleanRef $updated;
            {
                this.$updated = $updated;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.$updated.element;
            }
        };
        Duration duration = Duration.ofSeconds(20L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofSeconds(...)");
        ExtensionsKt.waitAndPump$default((Lifetime)lifetime2, (Function0)function0, (Duration)duration, null, (int)8, null);
        LifetimeDefinition.terminate$default((LifetimeDefinition)lifetimeDefinition, (boolean)false, (int)1, null);
    }

    public final void install(@NotNull RdNuGetProjects projects2, @NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)projects2, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (CollectionsKt.any((Iterable)projects2.getProjectIds()) && !Intrinsics.areEqual((Object)id2, (Object)"") && !Intrinsics.areEqual((Object)version, (Object)"")) {
            Iterable iterable = projects2.getProjectIds();
            ISignal iSignal = this.operator.getInstall();
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                int n2 = ((Number)t).intValue();
                Collection collection2 = collection;
                boolean bl3 = false;
                collection2.add(new RdNuGetInstallOneRequest(n2, id2, version));
            }
            List list2 = (List)collection;
            iSignal.fire((Object)new RdNuGetInstallRequest(list2));
        }
    }

    public final void installForAllProjects(@NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.install(this.getAllProjects(), id2, version);
    }

    public final void installForProject(@NotNull String project, @NotNull String id2, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.install(this.getProjectModel().getProjectsByName(project), id2, version);
    }

    public final boolean hasUpdatesInContext() {
        boolean bl;
        block3: {
            Iterable iterable = (Iterable)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), (Object)CollectionsKt.emptyList());
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata = (RdNuGetSmartMetadata)t;
                    boolean bl3 = false;
                    if (!(rdNuGetSmartMetadata.getCanBeUpdated() && this.j(rdNuGetSmartMetadata))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean j(String string) {
        boolean bl;
        block1: {
            Object object = new Character[]{Character.valueOf('['), Character.valueOf(']'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('*')};
            Set set = SetsKt.setOf((Object[])object);
            object = string;
            boolean bl2 = false;
            for (int k = 0; k < object.length(); ++k) {
                char c;
                char c2 = c = object.charAt(k);
                boolean bl3 = false;
                if (!set.contains(Character.valueOf(c2))) continue;
                bl = false;
                break block1;
            }
            bl = true;
        }
        return bl;
    }

    private final boolean j(RdNuGetSmartMetadata rdNuGetSmartMetadata) {
        boolean bl;
        block3: {
            Iterable iterable = rdNuGetSmartMetadata.getVersionRanges();
            boolean bl2 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = true;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl3 = false;
                    if (this.j(string)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean j(RdNuGetSmartMetadata rdNuGetSmartMetadata, RdNuGetPackageIdentity rdNuGetPackageIdentity) {
        boolean bl;
        boolean bl2;
        block3: {
            bl2 = CollectionsKt.any((Iterable)rdNuGetSmartMetadata.getAvailableVersions()) && !Intrinsics.areEqual((Object)((RdNuGetRemoteVersion)CollectionsKt.last((List)rdNuGetSmartMetadata.getAvailableVersions())).getVersion(), (Object)rdNuGetPackageIdentity.getVersion());
            Iterable iterable = rdNuGetSmartMetadata.getVersionRanges();
            boolean bl3 = false;
            if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                bl = false;
            } else {
                for (Object t : iterable) {
                    String string = (String)t;
                    boolean bl4 = false;
                    if (!(!this.j(string))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean bl5 = bl;
        return bl2 && !bl5;
    }

    public final void upgradeAllInContext(boolean confirmation) {
        List<RdNuGetInstallOneRequest> list2;
        int n2;
        Object object2;
        List<RdNuGetInstallOneRequest> list3 = new ArrayList();
        List list4 = (List)InterfacesKt.valueOrDefault((IOptProperty)this.host.getFoundPackages(), (Object)CollectionsKt.emptyList());
        int n3 = this.getContextProjectId();
        if (n3 == -1) {
            Iterable iterable = this.projects.getAllProjectIds();
            boolean bl = false;
            for (Object object2 : iterable) {
                n2 = ((Number)object2).intValue();
                boolean bl2 = false;
                RiderNuGetFacade.j(this, list4, list3, n2);
            }
        } else {
            RiderNuGetFacade.j(this, list4, list3, n3);
        }
        boolean bl = confirmation;
        if (bl) {
            Object[] objectArray = new Object[]{this.getContextProjectTitle()};
            list2 = RiderNuGetInstallConfirmationDialog.INSTANCE.show(this.getProjectModel(), RiderNugetBundle.Companion.message("RiderNuGetFacade.dialog.title.upgrade.all.packages.in", objectArray), RiderActionsBundle.Companion.message("action.upgrade.text", new Object[0]), list3);
        } else if (!bl) {
            list2 = list3;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Iterable iterable = list2;
        boolean bl3 = false;
        Iterable iterable2 = iterable;
        object2 = new ArrayList();
        n2 = 0;
        Iterator iterator2 = iterable2.iterator();
        while (iterator2.hasNext()) {
            Object v1;
            String string;
            Object object3;
            Object t;
            block12: {
                t = iterator2.next();
                RdNuGetInstallOneRequest rdNuGetInstallOneRequest = (RdNuGetInstallOneRequest)t;
                boolean bl4 = false;
                object3 = this.getProjectModel().getProjectInfoById(rdNuGetInstallOneRequest.getProjectId()).getExplicitPackages();
                string = rdNuGetInstallOneRequest.getPackageVersion();
                boolean bl5 = false;
                Iterator iterator3 = object3.iterator();
                while (iterator3.hasNext()) {
                    Object t2 = iterator3.next();
                    RdNuGetPackageIdentity rdNuGetPackageIdentity = (RdNuGetPackageIdentity)t2;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)rdNuGetPackageIdentity.getId(), (Object)rdNuGetInstallOneRequest.getPackageId())) continue;
                    v1 = t2;
                    break block12;
                }
                v1 = null;
            }
            RdNuGetPackageIdentity rdNuGetPackageIdentity = v1;
            boolean bl7 = !Intrinsics.areEqual((Object)string, (Object)(rdNuGetPackageIdentity != null && (object3 = rdNuGetPackageIdentity.getVersion()) != null ? object3 : ""));
            if (!bl7) continue;
            object2.add(t);
        }
        List list5 = (List)object2;
        if (CollectionsKt.any((Iterable)list5) && list3.size() == list5.size() && StringsKt.isBlank((CharSequence)((CharSequence)InterfacesKt.valueOrDefault((IOptProperty)this.host.getSearchTerm(), (Object)"")))) {
            this.operator.getUpdateAll().fire((Object)new RdNuGetUpdateAllRequest(this.getContextProjectId()));
        } else if (CollectionsKt.any((Iterable)list5)) {
            this.operator.getInstall().fire((Object)new RdNuGetInstallRequest(list5));
        }
    }

    public final void uninstall(@NotNull RdNuGetProjects projects2, @NotNull String packageId) {
        Intrinsics.checkNotNullParameter((Object)projects2, (String)"projects");
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        if (CollectionsKt.any((Iterable)projects2.getProjectIds()) && !Intrinsics.areEqual((Object)packageId, (Object)"")) {
            this.operator.getUninstall().fire((Object)new RdNuGetUninstallRequest(projects2, packageId));
        }
    }

    public final void uninstallFromAllProjects(@NotNull String packageId) {
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        this.uninstall(this.getAllProjects(), packageId);
    }

    public final void uninstallFromProject(@NotNull String project, @NotNull String id2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        this.uninstall(this.getProjectModel().getProjectsByName(project), id2);
    }

    public final void restore(@NotNull RdNuGetNotificationMode mode, @NotNull RdNuGetRestoreStrategy strategy, @NotNull RdNuGetRestoreRequestSource source) {
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.operator.getRestore().fire((Object)new RdNuGetRestoreRequest(mode, strategy, source));
    }

    public static /* synthetic */ void restore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetNotificationMode rdNuGetNotificationMode, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, RdNuGetRestoreRequestSource rdNuGetRestoreRequestSource, int n2, Object object) {
        if ((n2 & 2) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        if ((n2 & 4) != 0) {
            rdNuGetRestoreRequestSource = RdNuGetRestoreRequestSource.Default;
        }
        riderNuGetFacade.restore(rdNuGetNotificationMode, rdNuGetRestoreStrategy, rdNuGetRestoreRequestSource);
    }

    public final void forceRestore(@NotNull RdNuGetRestoreStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        RiderNuGetFacade.restore$default(this, RiderNuGetConstants.Companion.getForceMode(), strategy, null, 4, null);
    }

    public static /* synthetic */ void forceRestore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, int n2, Object object) {
        if ((n2 & 1) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        riderNuGetFacade.forceRestore(rdNuGetRestoreStrategy);
    }

    public final void silentRestore(@NotNull RdNuGetRestoreStrategy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        RiderNuGetFacade.restore$default(this, RiderNuGetConstants.Companion.getSilentMode(), strategy, null, 4, null);
    }

    public static /* synthetic */ void silentRestore$default(RiderNuGetFacade riderNuGetFacade, RdNuGetRestoreStrategy rdNuGetRestoreStrategy, int n2, Object object) {
        if ((n2 & 1) != 0) {
            rdNuGetRestoreStrategy = RdNuGetRestoreStrategy.Default;
        }
        riderNuGetFacade.silentRestore(rdNuGetRestoreStrategy);
    }

    public final void runAndWait(@NotNull Duration timeout, @NotNull Function1<? super RiderNuGetFacade, Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        action2.invoke((Object)this);
        RiderNuGetFacade.waitForSteadyState$default(this, false, false, timeout, 3, null);
    }

    public static /* synthetic */ void runAndWait$default(RiderNuGetFacade riderNuGetFacade, Duration duration, Function1 function1, int n2, Object object) {
        if ((n2 & 1) != 0) {
            Duration duration2 = Duration.ofSeconds(500L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        riderNuGetFacade.runAndWait(duration, (Function1<? super RiderNuGetFacade, Unit>)function1);
    }

    public final void waitForSteadyState(boolean clearCaches, boolean validConfig, @NotNull Duration timeout) {
        Intrinsics.checkNotNullParameter((Object)timeout, (String)"timeout");
        if (clearCaches) {
            this.clearCache();
        }
        this.zeroLatencyUpdateAndWait();
        RdNuGetStateInfo rdNuGetStateInfo = this.host.getStateInfo();
        ExtensionsKt.waitAndPump((Lifetime)((Lifetime)this.lifetime), (Function0)((Function0)new Function0<Boolean>(this, rdNuGetStateInfo, validConfig){
            final /* synthetic */ RiderNuGetFacade this$0;
            final /* synthetic */ RdNuGetStateInfo $state;
            final /* synthetic */ boolean $validConfig;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                this.$validConfig = $validConfig;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)InterfacesKt.valueOrDefault(this.this$0.isBusy(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.$state.isFetching(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.$state.getPackageReferenceTrackerIsBusy(), (Object)true) == false && (((Number)InterfacesKt.valueOrDefault((IOptProperty)this.$state.getTotalFetched(), (Object)0)).intValue() > 0 || !this.$validConfig) && RiderNuGetFacade.access$getRunTaskCount$p(this.this$0).get() == 0;
            }
        }), (Duration)timeout, (Function0)((Function0)new Function0<String>(this, rdNuGetStateInfo){
            final /* synthetic */ RiderNuGetFacade this$0;
            final /* synthetic */ RdNuGetStateInfo $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(0);
            }

            @NotNull
            public final String invoke() {
                RiderNuGetFacade riderNuGetFacade = this.this$0;
                IOptProperty<Boolean> iOptProperty = this.this$0.isBusy();
                boolean bl = false;
                Object object = iOptProperty.getValueOrNull();
                if (object == null || (object = object.toString()) == null) {
                    object = "NA";
                }
                return "IsBusy: " + (String)object + ", State: (" + RiderNuGetExtensionsKt.toUserString((RdNuGetStateInfo)this.$state) + "), RunTaskCount: " + RiderNuGetFacade.access$getRunTaskCount$p(this.this$0).get();
            }
        }));
        this.zeroLatencyUpdateAndWait();
        ExtensionsKt.waitAndPump((Lifetime)((Lifetime)this.lifetime), (Function0)((Function0)new Function0<Boolean>(this, rdNuGetStateInfo){
            final /* synthetic */ RiderNuGetFacade this$0;
            final /* synthetic */ RdNuGetStateInfo $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return (Boolean)InterfacesKt.valueOrDefault(this.this$0.isBusy(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.$state.isFetching(), (Object)true) == false && (Boolean)InterfacesKt.valueOrDefault((IOptProperty)this.$state.getPackageReferenceTrackerIsBusy(), (Object)true) == false && RiderNuGetFacade.access$getRunTaskCount$p(this.this$0).get() == 0;
            }
        }), (Duration)timeout, (Function0)((Function0)new Function0<String>(this, rdNuGetStateInfo){
            final /* synthetic */ RiderNuGetFacade this$0;
            final /* synthetic */ RdNuGetStateInfo $state;
            {
                this.this$0 = $receiver;
                this.$state = $state;
                super(0);
            }

            @NotNull
            public final String invoke() {
                RiderNuGetFacade riderNuGetFacade = this.this$0;
                IOptProperty iOptProperty = this.this$0.isBusy();
                boolean bl = false;
                Object object = iOptProperty.getValueOrNull();
                if (object == null || (object = object.toString()) == null) {
                    object = "NA";
                }
                riderNuGetFacade = this.this$0;
                iOptProperty = this.$state.isFetching();
                bl = false;
                Object object2 = iOptProperty.getValueOrNull();
                if (object2 == null || (object2 = object2.toString()) == null) {
                    object2 = "NA";
                }
                riderNuGetFacade = this.this$0;
                iOptProperty = this.$state.getPackageReferenceTrackerIsBusy();
                bl = false;
                Object object3 = iOptProperty.getValueOrNull();
                if (object3 == null || (object3 = object3.toString()) == null) {
                    object3 = "NA";
                }
                return "IsBusy: " + (String)object + ", IsFetching: " + (String)object2 + ", PackageReferenceTrackerIsBusy: " + (String)object3 + ", RunTaskCount: " + RiderNuGetFacade.access$getRunTaskCount$p(this.this$0).get();
            }
        }));
    }

    public static /* synthetic */ void waitForSteadyState$default(RiderNuGetFacade riderNuGetFacade, boolean bl, boolean bl2, Duration duration, int n2, Object object) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            Duration duration2 = Duration.ofSeconds(500L);
            Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ofSeconds(...)");
            duration = duration2;
        }
        riderNuGetFacade.waitForSteadyState(bl, bl2, duration);
    }

    private final /* synthetic */ <T> String j(IOptProperty<T> iOptProperty) {
        boolean bl = false;
        Object object = iOptProperty.getValueOrNull();
        if (object == null || (object = object.toString()) == null) {
            object = "NA";
        }
        return object;
    }

    @NotNull
    public final ContextHelpAction getHelpAction() {
        return this.helpAction;
    }

    public final void toggleIncludePrerelease() {
        this.host.getIncludePrerelease().set((Object)(!BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.host.getIncludePrerelease())) ? 1 : 0));
    }

    public final void setIncludePrerelease(boolean value) {
        this.host.getIncludePrerelease().set((Object)value);
    }

    @NotNull
    public final List<Integer> getContextProjectIds() {
        return this.getContextProjectId() == -1 ? this.getAllProjects().getProjectIds() : CollectionsKt.listOf((Object)this.getContextProjectId());
    }

    @Nullable
    public final String getErrorMessageUltraConfig() {
        RdNuGetUltraConfig rdNuGetUltraConfig = (RdNuGetUltraConfig)this.host.getConfigManager().getUltraConfig().getValueOrNull();
        return rdNuGetUltraConfig != null ? rdNuGetUltraConfig.getErrorMessage() : null;
    }

    public final void setFeedByName(@NotNull String feedName) {
        Intrinsics.checkNotNullParameter((Object)feedName, (String)"feedName");
        RdNuGetFeed rdNuGetFeed = this.feedManager.getFeedByName(feedName);
        Intrinsics.checkNotNull((Object)rdNuGetFeed);
        this.feedManager.setVisibleOnly(rdNuGetFeed);
    }

    public final boolean isNuGetOrgFeed(@NotNull String feedId) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)feedId, (String)"feedId");
            Iterable iterable = BeGetterExtensionsKt.valueOrEmpty((IOptProperty)this.host.getConfigManager().getKnownFeeds());
            boolean bl = false;
            for (Object t : iterable) {
                RdNuGetFeed rdNuGetFeed = (RdNuGetFeed)t;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)rdNuGetFeed.getFeedId(), (Object)feedId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        RdNuGetFeed rdNuGetFeed = v0;
        return rdNuGetFeed != null ? rdNuGetFeed.isNuGetOrg() : false;
    }

    public final void showLastPackageVersionDialog(@NotNull String packageId, int projectId) {
        Intrinsics.checkNotNullParameter((Object)packageId, (String)"packageId");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.project);
        boolean bl = propertiesComponent.getBoolean(LAST_PACKAGE_VERSION_DIALOG_PROPERTY, false);
        if (!bl) {
            Intrinsics.checkNotNull((Object)propertiesComponent);
            if (this.j(packageId, propertiesComponent)) {
                this.host.getNuGetOperator().getRequestRemovePackageVersionAccept().fire((Object)new RdNuGetRemovePackageVersionResult(projectId, packageId));
            }
            return;
        }
        this.host.getNuGetOperator().getRequestRemovePackageVersionAccept().fire((Object)new RdNuGetRemovePackageVersionResult(projectId, packageId));
    }

    private final boolean j(String string, PropertiesComponent propertiesComponent) {
        Object[] objectArray = new Object[]{string};
        return ((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(RiderBundle.message("dialog.title.you.ve.deleted.last.packagereference.for.in.this.solution", objectArray), RiderBundle.message("dialog.message.do.you.want.to.also.delete.packageversion.item.for.this.package", new Object[0])).doNotAsk((DoNotAskOption)new DoNotAskOption.Adapter(propertiesComponent){
            final /* synthetic */ PropertiesComponent $properties;
            {
                this.$properties = $properties;
            }

            public boolean isSelectedByDefault() {
                return false;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            public void rememberChoice(boolean isSelected, int exitCode) {
                this.$properties.setValue("lastPackageVersionDialogProperty", isSelected);
            }
        })).ask(this.project);
    }

    private static final void j(RiderNuGetFacade riderNuGetFacade, List<RdNuGetSmartMetadata> list2, List<RdNuGetInstallOneRequest> list3, int n2) {
        RdNuGetProject rdNuGetProject = riderNuGetFacade.getProjectModel().getProjectInfoById(n2);
        for (RdNuGetPackageIdentity rdNuGetPackageIdentity : rdNuGetProject.getExplicitPackages()) {
            RdNuGetSmartMetadata rdNuGetSmartMetadata;
            Object v0;
            block2: {
                Iterable iterable = list2;
                boolean bl = false;
                for (Object t : iterable) {
                    RdNuGetSmartMetadata rdNuGetSmartMetadata2 = (RdNuGetSmartMetadata)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)rdNuGetSmartMetadata2.getId(), (Object)rdNuGetPackageIdentity.getId())) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            if ((rdNuGetSmartMetadata = (RdNuGetSmartMetadata)v0) == null || !rdNuGetSmartMetadata.getCanBeUpdated() || !riderNuGetFacade.j(rdNuGetSmartMetadata, rdNuGetPackageIdentity)) continue;
            list3.add(new RdNuGetInstallOneRequest(n2, rdNuGetPackageIdentity.getId(), ((RdNuGetRemoteVersion)CollectionsKt.last((List)rdNuGetSmartMetadata.getAvailableVersions())).getVersion()));
        }
    }

    public static final /* synthetic */ AtomicInteger access$getRunTaskCount$p(RiderNuGetFacade $this) {
        return $this.runTaskCount;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/nuget/RiderNuGetFacade$Companion;", "", "()V", "LAST_PACKAGE_VERSION_DIALOG_PROPERTY", "", "getInstance", "Lcom/jetbrains/rider/nuget/RiderNuGetFacade;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderNuGetFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,314:1\n31#2,2:315\n*S KotlinDebug\n*F\n+ 1 RiderNuGetFacade.kt\ncom/jetbrains/rider/nuget/RiderNuGetFacade$Companion\n*L\n35#1:315,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderNuGetFacade getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RiderNuGetFacade> clazz = RiderNuGetFacade.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RiderNuGetFacade)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

