/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.network;

import com.intellij.CommonBundle;
import com.intellij.diagnostic.PluginException;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.net.ssl.CertificateListener;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.net.ssl.ConfirmingTrustManager;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.model.RdCertificateManagerHost;
import com.jetbrains.rider.model.RdCertificateManagerHost_PregeneratedKt;
import com.jetbrains.rider.model.RdCheckServerTrustedArgs;
import com.jetbrains.rider.model.RdLocalCertificateManager;
import com.jetbrains.rider.model.RdX509CertificateRaw;
import com.jetbrains.rider.network.RiderCertificateManagerHost;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0006\u0010\u0014\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rdLocalHost", "Lcom/jetbrains/rider/model/RdLocalCertificateManager;", "j", "()Lcom/jetbrains/rider/model/RdLocalCertificateManager;", "rejectedCertificates", "", "Lcom/jetbrains/rider/model/RdX509CertificateRaw;", "j", "", "args", "Lcom/jetbrains/rider/model/RdCheckServerTrustedArgs;", "model", "Lcom/jetbrains/rider/model/RdCertificateManagerHost;", "N", "j", "sync", "Activity", "Companion", "Listener", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderCertificateManagerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1549#2:133\n1620#2,3:134\n*S KotlinDebug\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost\n*L\n94#1:133\n94#1:134,3\n*E\n"})
public final class RiderCertificateManagerHost
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final List<RdX509CertificateRaw> rejectedCertificates;

    public RiderCertificateManagerHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rejectedCertificates = new ArrayList();
    }

    private final RdLocalCertificateManager j() {
        return RdCertificateManagerHost_PregeneratedKt.getRdCertificateManagerHost((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getLocal();
    }

    private final void j(RdCheckServerTrustedArgs rdCheckServerTrustedArgs, RdCertificateManagerHost rdCertificateManagerHost) {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Certificate certificate = certificateFactory.generateCertificate(new ByteArrayInputStream(rdCheckServerTrustedArgs.getCertificate().getCertData()));
        Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
        X509Certificate x509Certificate = (X509Certificate)certificate;
        try {
            ConfirmingTrustManager.CertificateConfirmationParameters certificateConfirmationParameters = ConfirmingTrustManager.CertificateConfirmationParameters.askConfirmation((boolean)true, (String)rdCheckServerTrustedArgs.getMessage(), this::j);
            Intrinsics.checkNotNullExpressionValue((Object)certificateConfirmationParameters, (String)"askConfirmation(...)");
            ConfirmingTrustManager.CertificateConfirmationParameters certificateConfirmationParameters2 = certificateConfirmationParameters;
            X509Certificate[] x509CertificateArray = new X509Certificate[]{x509Certificate};
            CertificateManager.Companion.getInstance().getTrustManager().checkServerTrusted(x509CertificateArray, "RSA", certificateConfirmationParameters2);
        }
        catch (CertificateException certificateException) {
            this.rejectedCertificates.add(rdCheckServerTrustedArgs.getCertificate());
            rdCertificateManagerHost.getLocal().getRejectedCertificates().set((Object)CollectionsKt.toList((Iterable)this.rejectedCertificates));
        }
    }

    private final void N() {
        ConfirmingTrustManager.MutableTrustManager mutableTrustManager = CertificateManager.Companion.getInstance().getCustomTrustManager();
        CertificateListener certificateListener = new CertificateListener(this){
            final /* synthetic */ RiderCertificateManagerHost this$0;
            {
                this.this$0 = $receiver;
            }

            public void certificateRemoved(@Nullable X509Certificate certificate) {
                this.this$0.sync();
            }

            public void certificateAdded(@Nullable X509Certificate certificate) {
                this.this$0.sync();
            }
        };
        this.getServiceLifetime().bracketIfAlive((Function0)new Function0<Unit>(mutableTrustManager, certificateListener){
            final /* synthetic */ ConfirmingTrustManager.MutableTrustManager $customTrustManager;
            final /* synthetic */ installCertificateListener.listener.1 $listener;
            {
                this.$customTrustManager = $customTrustManager;
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$customTrustManager.addListener((CertificateListener)this.$listener);
            }
        }, (Function0)new Function0<Unit>(mutableTrustManager, certificateListener){
            final /* synthetic */ ConfirmingTrustManager.MutableTrustManager $customTrustManager;
            final /* synthetic */ installCertificateListener.listener.1 $listener;
            {
                this.$customTrustManager = $customTrustManager;
                this.$listener = $listener;
                super(0);
            }

            public final void invoke() {
                this.$customTrustManager.removeListener((CertificateListener)this.$listener);
            }
        });
    }

    public final void sync() {
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), arg_0 -> RiderCertificateManagerHost.j(this, arg_0), () -> RiderCertificateManagerHost.j(this));
    }

    private final void j() {
        NotificationListener.Adapter adapter = new NotificationListener.Adapter(this){
            final /* synthetic */ RiderCertificateManagerHost this$0;
            {
                this.this$0 = $receiver;
            }

            protected void hyperlinkActivated(@NotNull Notification notification2, @NotNull HyperlinkEvent e) {
                Intrinsics.checkNotNullParameter((Object)notification2, (String)"notification");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!RiderCertificateManagerHost.access$getProject$p(this.this$0).isDisposed() && Intrinsics.areEqual((Object)e.getDescription(), (Object)"settings")) {
                    notification2.hideBalloon();
                    try {
                        ShowSettingsUtil.getInstance().showSettingsDialog(RiderCertificateManagerHost.access$getProject$p(this.this$0), RiderBundle.message("RiderCertificateManagerHelper.configurable.name.server.certificates", new Object[0]));
                    }
                    catch (PluginException pluginException) {
                        // empty catch block
                    }
                }
            }
        };
        Object[] objectArray = SystemInfo.isMac ? CommonBundle.message((String)"title.settings.mac", (Object[])new Object[0]) : CommonBundle.message((String)"action.settings.path", (Object[])new Object[0]);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] objectArray2 = objectArray;
        objectArray = new Object[]{objectArray2};
        new Notification("Certificate Manager", RiderDesignersBundle.Companion.message("RiderCertificateManagerHelper.notification.title.certificate.was.successfully.accepted", new Object[0]), RiderDesignersBundle.Companion.message("RiderCertificateManagerHelper.notification.content.you.can.manage.full.list.of.certificates", objectArray), NotificationType.INFORMATION).setListener((NotificationListener)adapter).notify(this.project);
    }

    private static final boolean j(RiderCertificateManagerHost riderCertificateManagerHost, Object object) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderCertificateManagerHost), (String)"this$0");
        return !RLifetimeKt.isAlive((Lifetime)riderCertificateManagerHost.getServiceLifetime());
    }

    private static final void j(RiderCertificateManagerHost riderCertificateManagerHost) {
        Intrinsics.checkNotNullParameter((Object)((Object)riderCertificateManagerHost), (String)"this$0");
        List list2 = CertificateManager.Companion.getInstance().getCustomTrustManager().getCertificates();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getCertificates(...)");
        Iterable iterable = list2;
        boolean bl = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean bl2 = false;
        for (Object t : iterable2) {
            X509Certificate x509Certificate = (X509Certificate)t;
            Collection collection2 = collection;
            boolean bl3 = false;
            byte[] byArray = x509Certificate.getEncoded();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getEncoded(...)");
            collection2.add(new RdX509CertificateRaw(byArray));
        }
        List list3 = (List)collection;
        riderCertificateManagerHost.j().getAcceptedCertificates().set((Object)list3);
    }

    public static final /* synthetic */ void access$checkServerTrusted(RiderCertificateManagerHost $this, RdCheckServerTrustedArgs args, RdCertificateManagerHost model2) {
        $this.j(args, model2);
    }

    public static final /* synthetic */ Project access$getProject$p(RiderCertificateManagerHost $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Activity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider"})
    public static final class Activity
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            Companion.getInstance(project).N();
            Companion.getInstance(project).sync();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/network/RiderCertificateManagerHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderCertificateManagerHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n31#2,2:133\n*S KotlinDebug\n*F\n+ 1 RiderCertificateManagerHost.kt\ncom/jetbrains/rider/network/RiderCertificateManagerHost$Companion\n*L\n44#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderCertificateManagerHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<RiderCertificateManagerHost> clazz = RiderCertificateManagerHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (RiderCertificateManagerHost)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/network/RiderCertificateManagerHost$Listener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/RdCertificateManagerHost;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class Listener
    implements SolutionExtListener<RdCertificateManagerHost> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session, @NotNull RdCertificateManagerHost model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            model2.getLocal().getCheckServerTrusted().advise(lifetime2, (Function1)new Function1<RdCheckServerTrustedArgs, Unit>(session, model2){
                final /* synthetic */ ClientProjectSession $session;
                final /* synthetic */ RdCertificateManagerHost $model;
                {
                    this.$session = $session;
                    this.$model = $model;
                    super(1);
                }

                public final void invoke(@NotNull RdCheckServerTrustedArgs args) {
                    Intrinsics.checkNotNullParameter((Object)args, (String)"args");
                    RiderCertificateManagerHost.access$checkServerTrusted(RiderCertificateManagerHost.Companion.getInstance(this.$session.getProject()), args, this.$model);
                }
            });
        }
    }
}

