/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetImageItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItemWithFile;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.AssetEnvironment;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageReadResults;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcImageAssetItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014R\u0014\u0010\u000b\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcPdfImageItemPresenter;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageAssetItemPresenterBase;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageItem;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "environment", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetImageItem;Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;)V", "caption", "", "getCaption", "()Ljava/lang/String;", "openFileMenuItem", "Lcom/intellij/openapi/ui/JBMenuItem;", "tooltip", "getTooltip", "createPopupMenuItems", "", "getIcon", "Ljavax/swing/Icon;", "cachedImage", "Ljava/awt/image/BufferedImage;", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "readImage", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageReadResults;", "file", "Ljava/io/File;", "intellij.rider"})
public final class XcPdfImageItemPresenter
extends XcImageAssetItemPresenterBase<XcAssetImageItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final JBMenuItem openFileMenuItem;

    public XcPdfImageItemPresenter(@NotNull Lifetime lifetime2, @NotNull Project project, @NotNull XcAssetImageItem model2, @NotNull AssetEnvironment environment) {
        JBMenuItem jBMenuItem;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(lifetime2, (XcAssetItemWithFile)model2, environment);
        this.project = project;
        JBMenuItem jBMenuItem2 = jBMenuItem = new JBMenuItem(RiderMultiPlatformBundle.Companion.message("rider.xcassets.vectors.open.menuItem", new Object[0]));
        XcPdfImageItemPresenter xcPdfImageItemPresenter = this;
        boolean bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcPdfImageItemPresenter.j(environment, this, arg_0));
        xcPdfImageItemPresenter.openFileMenuItem = jBMenuItem;
    }

    @Override
    @NotNull
    protected String getCaption() {
        return "Vector\r" + ModelUtilsKt.getLuminosity((XcAssetItem)this.getModel()) + " appearance";
    }

    @Override
    @NotNull
    protected String getTooltip() {
        String string = PresenterUtilsKt.getImageTooltipText(null, this.getCurrentFile(), this.getErrorStateMessage());
        if (string == null) {
            string = RiderMultiPlatformBundle.Companion.message("rider.xcassets.vectors.failedTooltip", new Object[0]);
        }
        return string;
    }

    @Override
    @NotNull
    public XcItemOperationResult handleAddAction() {
        File file2 = PresenterUtilsKt.selectWithFileDialogOrNull(this.project, RiderMultiPlatformBundle.Companion.message("rider.xcassets.vectors.choose.title", new Object[0]));
        if (file2 == null) {
            return XcItemOperationResult.Canceled;
        }
        File file3 = file2;
        return this.trySetupNewImage(file3);
    }

    @Override
    @NotNull
    protected ImageReadResults readImage(@Nullable File file2) {
        if (file2 == null || !file2.exists()) {
            return ImageReadResults.Companion.failed(XcItemOperationResult.FileNotFound, RiderMultiPlatformBundle.Companion.message("rider.xcassets.vectors.selectFile.invalidFile", new Object[0]));
        }
        String string = FilesKt.getExtension((File)file2).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (!Intrinsics.areEqual((Object)"pdf", (Object)string)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"getName(...)");
            return ImageReadResults.Companion.failed(XcItemOperationResult.WrongFormat, RiderMultiPlatformBundle.Companion.message("rider.xcassets.vectors.selectFile.invalidFileExtension", objectArray));
        }
        return ImageReadResults.Companion.getSuccess();
    }

    @Override
    @NotNull
    public Icon getIcon(@Nullable BufferedImage cachedImage) {
        AssetItemControl assetItemControl = this.getAssetControl();
        Intrinsics.checkNotNull((Object)assetItemControl);
        return assetItemControl.getStyle().getNoPreviewIcon();
    }

    @Override
    @NotNull
    protected List<JBMenuItem> createPopupMenuItems() {
        List list2;
        if (this.isEmpty()) {
            list2 = CollectionsKt.listOf((Object)this.getSetPictureMenuItem());
        } else {
            Object[] objectArray = new JBMenuItem[]{this.getSetPictureMenuItem(), this.getUnsetPictureMenuItem(), this.getRevealFileMenuItem(), this.openFileMenuItem};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    private static final void j(AssetEnvironment assetEnvironment, XcPdfImageItemPresenter xcPdfImageItemPresenter, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)assetEnvironment, (String)"$environment");
        Intrinsics.checkNotNullParameter((Object)xcPdfImageItemPresenter, (String)"this$0");
        File file2 = assetEnvironment.getFolder().searchExistedFile(((XcAssetImageItem)xcPdfImageItemPresenter.getModel()).getFileName());
        if (file2 != null) {
            RevealFileAction.openDirectory((File)file2);
        }
    }
}

