/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetInputSource;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.SelectionLogic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.SelectionIconState;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import icons.ReSharperIcons;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\b\u00105\u001a\u00020\bH$J\u0010\u00106\u001a\u00020\b2\u0006\u00107\u001a\u00020\u000bH\u0002J\u001e\u00108\u001a\u00020\b2\u0006\u00107\u001a\u00020\u000b2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0010\u0010<\u001a\u00020\b2\u0006\u00107\u001a\u00020\u000bH\u0002J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H$J\u000e\u0010A\u001a\b\u0012\u0004\u0012\u00020;0:H$J\u000e\u0010B\u001a\u00020>2\u0006\u0010?\u001a\u00020@J\b\u0010C\u001a\u00020DH&J\b\u0010E\u001a\u00020\bH&J\b\u0010F\u001a\u00020\bH\u0004J\u000f\u0010G\u001a\u0004\u0018\u00010\bH\u0004\u00a2\u0006\u0002\u0010HJ\u0010\u0010I\u001a\u00020\b2\u0006\u0010J\u001a\u00020\u0011H\u0004J\b\u0010K\u001a\u00020\bH\u0004J\u0010\u0010L\u001a\u00020\u001d2\u0006\u0010M\u001a\u00020NH$J\u0010\u0010O\u001a\u00020D2\u0006\u0010M\u001a\u00020PH$J\b\u0010Q\u001a\u00020\bH\u0002J\b\u0010R\u001a\u00020\bH\u0002R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0011X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0012\u0010\u001c\u001a\u00020\u001dX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR$\u0010 \u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b \u0010\u001e\"\u0004\b!\u0010\"R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010%\u001a\u0004\b#\u0010$R\u000e\u0010&\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010'\u001a\u00020(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u001c\u0010-\u001a\u0004\u0018\u00010.X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0012\u00103\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0013\u00a8\u0006S"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "TModel", "", "itemPresenterLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "onContentChanged", "Lkotlin/Function0;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "assetControl", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;", "getAssetControl", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;", "setAssetControl", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/AssetItemControl;)V", "caption", "", "getCaption", "()Ljava/lang/String;", "currentLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "errorStateMessage", "getErrorStateMessage", "setErrorStateMessage", "(Ljava/lang/String;)V", "hint", "getHint", "isEmpty", "", "()Z", "value", "isSelected", "setSelected", "(Z)V", "getModel", "()Ljava/lang/Object;", "Ljava/lang/Object;", "myIsSelected", "selectionOrder", "", "getSelectionOrder", "()I", "setSelectionOrder", "(I)V", "selector", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "getSelector", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "setSelector", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;)V", "tooltip", "getTooltip", "afterDraw", "N", "control", "j", "menuItems", "", "Lcom/intellij/openapi/ui/JBMenuItem;", "j", "createContentUI", "Ljavax/swing/JComponent;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "createPopupMenuItems", "draw", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "handleDeleteAction", "modelChanged", "selectMe", "()Lkotlin/Unit;", "setErrorState", "error", "setNormalState", "tryDrag", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "tryDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "N", "j", "intellij.rider"})
public abstract class XcItemPresenterBase<TModel> {
    private final TModel model;
    @NotNull
    private final Function0<Unit> onContentChanged;
    @Nullable
    private String errorStateMessage;
    @NotNull
    private final SequentialLifetimes currentLifetime;
    @Nullable
    private SelectionLogic selector;
    private int selectionOrder;
    @Nullable
    private AssetItemControl assetControl;
    private boolean myIsSelected;
    @NotNull
    private final String hint;

    public XcItemPresenterBase(@NotNull Lifetime itemPresenterLifetime, TModel model2, @NotNull Function0<Unit> onContentChanged) {
        Intrinsics.checkNotNullParameter((Object)itemPresenterLifetime, (String)"itemPresenterLifetime");
        Intrinsics.checkNotNullParameter(onContentChanged, (String)"onContentChanged");
        this.model = model2;
        this.onContentChanged = onContentChanged;
        this.currentLifetime = new SequentialLifetimes(itemPresenterLifetime);
        this.selectionOrder = -1;
        this.hint = "";
    }

    public /* synthetic */ XcItemPresenterBase(Lifetime lifetime2, Object object, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(lifetime2, object, (Function0<Unit>)function0);
    }

    public final TModel getModel() {
        return this.model;
    }

    @Nullable
    protected final String getErrorStateMessage() {
        return this.errorStateMessage;
    }

    protected final void setErrorStateMessage(@Nullable String string) {
        this.errorStateMessage = string;
    }

    @Nullable
    public final SelectionLogic getSelector() {
        return this.selector;
    }

    public final void setSelector(@Nullable SelectionLogic selectionLogic) {
        this.selector = selectionLogic;
    }

    public final int getSelectionOrder() {
        return this.selectionOrder;
    }

    public final void setSelectionOrder(int n2) {
        this.selectionOrder = n2;
    }

    public final boolean isSelected() {
        return this.myIsSelected;
    }

    public final void setSelected(boolean value) {
        this.myIsSelected = value;
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl != null) {
            assetItemControl.setSelected(value);
        }
    }

    public abstract boolean isEmpty();

    @Nullable
    protected final AssetItemControl getAssetControl() {
        return this.assetControl;
    }

    protected final void setAssetControl(@Nullable AssetItemControl assetItemControl) {
        this.assetControl = assetItemControl;
    }

    @NotNull
    protected abstract String getCaption();

    @NotNull
    protected abstract String getTooltip();

    @NotNull
    protected String getHint() {
        return this.hint;
    }

    @NotNull
    public final JComponent draw(@NotNull XcAssetsStyle style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        AssetItemControl assetItemControl = new AssetItemControl((Lifetime)this.currentLifetime.next(), style, this.getCaption(), this.createContentUI(style), this.getHint());
        this.j(assetItemControl);
        this.N(assetItemControl);
        this.assetControl = assetItemControl;
        this.afterDraw();
        this.N();
        this.j();
        return assetItemControl;
    }

    private final void N() {
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl == null) {
            return;
        }
        AssetItemControl assetItemControl2 = assetItemControl;
        List<JBMenuItem> list2 = this.createPopupMenuItems();
        if (CollectionsKt.any((Iterable)list2)) {
            this.j(assetItemControl2, list2);
        }
    }

    private final void j() {
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl != null) {
            assetItemControl.setToolTipText(PresenterUtilsKt.wrapToHtmlMultiline(this.getTooltip()));
        }
    }

    @NotNull
    protected abstract List<JBMenuItem> createPopupMenuItems();

    @NotNull
    public abstract XcItemOperationResult handleAddAction();

    public abstract void handleDeleteAction();

    protected abstract void afterDraw();

    @NotNull
    protected abstract JComponent createContentUI(@NotNull XcAssetsStyle var1);

    protected abstract boolean tryDrag(@NotNull DropTargetDragEvent var1);

    @NotNull
    protected abstract XcItemOperationResult tryDrop(@NotNull DropTargetDropEvent var1);

    protected final void modelChanged() {
        this.onContentChanged.invoke();
        this.j();
        this.N();
    }

    @Nullable
    protected final Unit selectMe() {
        Unit unit;
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic != null) {
            selectionLogic.select(this);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    protected final void setErrorState(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.errorStateMessage = error;
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl != null) {
            assetItemControl.setLabelIcon(ReSharperIcons.Common.Error);
        }
    }

    protected final void setNormalState() {
        AssetItemControl assetItemControl = this.assetControl;
        if (assetItemControl != null) {
            assetItemControl.setLabelIcon(null);
        }
    }

    private final void j(AssetItemControl assetItemControl, List<? extends JBMenuItem> list2) {
        JBPopupMenu jBPopupMenu = new JBPopupMenu();
        assetItemControl.setComponentPopupMenu((JPopupMenu)jBPopupMenu);
        for (JBMenuItem jBMenuItem : list2) {
            jBPopupMenu.add((JMenuItem)jBMenuItem);
        }
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic == null) {
            return;
        }
        SelectionLogic selectionLogic2 = selectionLogic;
        jBPopupMenu.addPopupMenuListener(new PopupMenuListener(selectionLogic2, this){
            final /* synthetic */ SelectionLogic $actualSelector;
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            {
                this.$actualSelector = $actualSelector;
                this.this$0 = $receiver;
            }

            public void popupMenuWillBecomeVisible(@Nullable PopupMenuEvent e) {
                this.$actualSelector.select(this.this$0);
            }

            public void popupMenuWillBecomeInvisible(@Nullable PopupMenuEvent e) {
            }

            public void popupMenuCanceled(@Nullable PopupMenuEvent e) {
            }
        });
    }

    private final void j(AssetItemControl assetItemControl) {
        SelectionLogic selectionLogic = this.selector;
        if (selectionLogic == null) {
            return;
        }
        SelectionLogic selectionLogic2 = selectionLogic;
        assetItemControl.addMouseListener(new MouseAdapter(this, selectionLogic2){
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            final /* synthetic */ SelectionLogic $actualSelector;
            {
                this.this$0 = $receiver;
                this.$actualSelector = $actualSelector;
            }

            public void mouseClicked(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void mousePressed(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    XcItemOperationResult xcItemOperationResult = this.this$0.handleAddAction();
                    XcAssetsStatistic.addAssetItem.log(this.this$0.getClass(), (Object)((Object)XcAssetInputSource.MouseClick), (Object)((Object)xcItemOperationResult));
                } else {
                    if (e.getClickCount() != 1) {
                        return;
                    }
                    if (e.isShiftDown()) {
                        this.$actualSelector.selectWithShift(this.this$0);
                    } else if (e.isControlDown()) {
                        this.$actualSelector.selectWithControl(this.this$0);
                    } else if (e.isMetaDown()) {
                        this.$actualSelector.selectWithControl(this.this$0);
                    } else {
                        this.$actualSelector.select(this.this$0);
                    }
                }
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void mouseExited(@Nullable MouseEvent e) {
            }
        });
    }

    private final void N(AssetItemControl assetItemControl) {
        new DropTarget(assetItemControl, new DropTargetListener(this, assetItemControl){
            final /* synthetic */ XcItemPresenterBase<TModel> this$0;
            final /* synthetic */ AssetItemControl $control;
            {
                this.this$0 = $receiver;
                this.$control = $control;
            }

            public void dragEnter(@NotNull DropTargetDragEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                if (this.this$0.tryDrag(dtde)) {
                    this.$control.setDropHighlight(SelectionIconState.CAN_BE_DROPPED);
                    dtde.acceptDrag(1);
                } else {
                    this.$control.setDropHighlight(SelectionIconState.IMPOSSIBLE_TO_DROP);
                    dtde.rejectDrag();
                }
            }

            public void dragOver(@Nullable DropTargetDragEvent dtde) {
            }

            public void dropActionChanged(@Nullable DropTargetDragEvent dtde) {
            }

            public void dragExit(@Nullable DropTargetEvent dte) {
                this.$control.setDropHighlight(SelectionIconState.EMPTY);
            }

            public void drop(@NotNull DropTargetDropEvent dtde) {
                Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
                dtde.acceptDrop(1);
                this.$control.setDropHighlight(SelectionIconState.EMPTY);
                XcItemOperationResult xcItemOperationResult = this.this$0.tryDrop(dtde);
                if (xcItemOperationResult == XcItemOperationResult.Success) {
                    dtde.dropComplete(true);
                    this.this$0.selectMe();
                } else {
                    dtde.dropComplete(false);
                }
                XcAssetsStatistic.addAssetItem.log(this.this$0.getClass(), (Object)((Object)XcAssetInputSource.DragNDrop), (Object)((Object)xcItemOperationResult));
            }
        });
    }
}

