/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.dnd.FileCopyPasteUtil;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.Messages;
import com.intellij.ui.components.JBLabel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetInputSource;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetFolder;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItemWithFile;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.AssetEnvironment;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageInfo;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageReadResults;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.SelectionLogic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsUiUtilsKt;
import icons.ReSharperIcons;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0004J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0004J\u000e\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001b0)H\u0014J\u0012\u0010*\u001a\u00020+2\b\u0010,\u001a\u0004\u0018\u00010-H\u0016J\b\u0010.\u001a\u00020#H\u0016J\u0010\u0010/\u001a\u00020\u00172\u0006\u00100\u001a\u00020\rH\u0002J\u0018\u00101\u001a\u00020#2\u0006\u00102\u001a\u00020+2\u0006\u00103\u001a\u00020\rH\u0002J\u0012\u00104\u001a\u0002052\b\u00100\u001a\u0004\u0018\u00010\rH$J\u0010\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u000208H\u0004J\u0010\u00109\u001a\u00020:2\u0006\u00107\u001a\u00020;H\u0004J\u0010\u0010<\u001a\u00020:2\u0006\u00103\u001a\u00020\rH\u0004R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001dR\u0014\u0010 \u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001d\u00a8\u0006="}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageAssetItemPresenterBase;", "TModel", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetItemWithFile;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "asset", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetItemWithFile;Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;)V", "getAsset", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;", "currentFile", "Ljava/io/File;", "getCurrentFile", "()Ljava/io/File;", "imageInfo", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageInfo;", "getImageInfo", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageInfo;", "setImageInfo", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageInfo;)V", "isEmpty", "", "()Z", "myCurrentFile", "revealFileMenuItem", "Lcom/intellij/openapi/ui/JBMenuItem;", "getRevealFileMenuItem", "()Lcom/intellij/openapi/ui/JBMenuItem;", "setPictureMenuItem", "getSetPictureMenuItem", "unsetPictureMenuItem", "getUnsetPictureMenuItem", "afterDraw", "", "createContentUI", "Lcom/intellij/ui/components/JBLabel;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "createPopupMenuItems", "", "getIcon", "Ljavax/swing/Icon;", "cachedImage", "Ljava/awt/image/BufferedImage;", "handleDeleteAction", "j", "file", "j", "icon", "originFile", "readImage", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageReadResults;", "tryDrag", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "tryDrop", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "Ljava/awt/dnd/DropTargetDropEvent;", "trySetupNewImage", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcImageItemPresenterBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcImageItemPresenterBase.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageAssetItemPresenterBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public abstract class XcImageAssetItemPresenterBase<TModel extends XcAssetItemWithFile>
extends XcItemPresenterBase<TModel> {
    @NotNull
    private final AssetEnvironment asset;
    @NotNull
    private ImageInfo imageInfo;
    @Nullable
    private File myCurrentFile;
    @NotNull
    private final JBMenuItem setPictureMenuItem;
    @NotNull
    private final JBMenuItem unsetPictureMenuItem;
    @NotNull
    private final JBMenuItem revealFileMenuItem;

    public XcImageAssetItemPresenterBase(@NotNull Lifetime lifetime2, @NotNull TModel model2, final @NotNull AssetEnvironment asset2) {
        JBMenuItem jBMenuItem;
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter(model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)asset2, (String)"asset");
        super(lifetime2, model2, (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                asset2.saveContentsJson();
            }
        }));
        this.asset = asset2;
        this.imageInfo = PresenterUtilsKt.emptyImageInfo();
        JBMenuItem jBMenuItem2 = jBMenuItem = new JBMenuItem(RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.set.menuItem", new Object[0]), ReSharperIcons.Common.Edit);
        XcImageAssetItemPresenterBase xcImageAssetItemPresenterBase = this;
        boolean bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcImageAssetItemPresenterBase.j(this, jBMenuItem2, arg_0));
        xcImageAssetItemPresenterBase.setPictureMenuItem = jBMenuItem;
        jBMenuItem2 = jBMenuItem = new JBMenuItem(RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.remove.menuItem", new Object[0]), ReSharperIcons.Common.Delete);
        xcImageAssetItemPresenterBase = this;
        bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcImageAssetItemPresenterBase.N(this, arg_0));
        xcImageAssetItemPresenterBase.unsetPictureMenuItem = jBMenuItem;
        jBMenuItem2 = jBMenuItem = new JBMenuItem(RevealFileAction.getActionName());
        xcImageAssetItemPresenterBase = this;
        bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcImageAssetItemPresenterBase.j(this, arg_0));
        xcImageAssetItemPresenterBase.revealFileMenuItem = jBMenuItem;
    }

    @NotNull
    public final AssetEnvironment getAsset() {
        return this.asset;
    }

    @NotNull
    protected final ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    protected final void setImageInfo(@NotNull ImageInfo imageInfo) {
        Intrinsics.checkNotNullParameter((Object)imageInfo, (String)"<set-?>");
        this.imageInfo = imageInfo;
    }

    @Override
    public final boolean isEmpty() {
        CharSequence charSequence = ((XcAssetItemWithFile)this.getModel()).getFileName();
        return charSequence == null || charSequence.length() == 0;
    }

    @Nullable
    protected final File getCurrentFile() {
        return this.myCurrentFile;
    }

    @NotNull
    protected final JBMenuItem getSetPictureMenuItem() {
        return this.setPictureMenuItem;
    }

    @NotNull
    protected final JBMenuItem getUnsetPictureMenuItem() {
        return this.unsetPictureMenuItem;
    }

    @NotNull
    protected final JBMenuItem getRevealFileMenuItem() {
        return this.revealFileMenuItem;
    }

    @Override
    public void handleDeleteAction() {
        String string = ((XcAssetItemWithFile)this.getModel()).getFileName();
        CharSequence charSequence = string;
        if (charSequence == null || charSequence.length() == 0) {
            this.setNormalState();
            return;
        }
        int n2 = this.asset.getCountOfUsage(string);
        AssetItemControl assetItemControl = this.getAssetControl();
        if (assetItemControl != null) {
            assetItemControl.disableContent();
        }
        ((XcAssetItemWithFile)this.getModel()).setFileName(null);
        this.asset.getFolder().editScope((Function0<Unit>)((Function0)new Function0<Unit>(n2, this, string){
            final /* synthetic */ int $countOfUsage;
            final /* synthetic */ XcImageAssetItemPresenterBase<TModel> this$0;
            final /* synthetic */ String $pathBefore;
            {
                this.$countOfUsage = $countOfUsage;
                this.this$0 = $receiver;
                this.$pathBefore = $pathBefore;
                super(0);
            }

            public final void invoke() {
                if (this.$countOfUsage <= 1) {
                    this.this$0.getAsset().getFolder().removeFile(this.$pathBefore);
                }
                this.this$0.setImageInfo(PresenterUtilsKt.emptyImageInfo());
                XcImageAssetItemPresenterBase.access$setMyCurrentFile$p(this.this$0, null);
                this.this$0.setNormalState();
                this.this$0.modelChanged();
            }
        }));
    }

    @NotNull
    protected final JBLabel createContentUI(@NotNull XcAssetsStyle style) {
        JBLabel jBLabel;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        JBLabel jBLabel2 = jBLabel = new JBLabel();
        boolean bl = false;
        jBLabel2.setBackground(null);
        return jBLabel;
    }

    @Override
    protected final void afterDraw() {
        Object object = ((XcAssetItemWithFile)this.getModel()).getFileName();
        if (object == null || object.length() == 0) {
            return;
        }
        object = this.asset.getFolder().searchExistedFile(((XcAssetItemWithFile)this.getModel()).getFileName());
        if (object == null) {
            Object[] objectArray = new Object[1];
            String string = ((XcAssetItemWithFile)this.getModel()).getFileName();
            if (string == null) {
                string = "";
            }
            objectArray[0] = string;
            this.setErrorState(RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.notFound.errorStateTooltip", objectArray));
            return;
        }
        ImageReadResults imageReadResults = this.readImage((File)object);
        if (!imageReadResults.isValid()) {
            this.setErrorState(imageReadResults.getErrorMessage());
            return;
        }
        this.myCurrentFile = object;
        this.imageInfo = PresenterUtilsKt.getImageInfo(imageReadResults.getLoadedImage());
        Icon icon2 = this.getIcon(imageReadResults.getLoadedImage());
        this.j(icon2, (File)object);
        this.setNormalState();
    }

    @Override
    protected final boolean tryDrag(@NotNull DropTargetDragEvent dtde) {
        Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
        Transferable transferable = dtde.getTransferable();
        Intrinsics.checkNotNullExpressionValue((Object)transferable, (String)"getTransferable(...)");
        return XcAssetsUiUtilsKt.hasFiles(transferable);
    }

    @Override
    @NotNull
    protected final XcItemOperationResult tryDrop(@NotNull DropTargetDropEvent dtde) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
        List list3 = list2 = FileCopyPasteUtil.getFileList((Transferable)dtde.getTransferable());
        if (!(list3 != null ? list3.size() == 1 : false)) {
            return XcItemOperationResult.InvalidDndContent;
        }
        File file2 = (File)list2.get(0);
        File file3 = this.asset.getFolder().searchExistedFile(((XcAssetItemWithFile)this.getModel()).getFileName());
        if (Intrinsics.areEqual((Object)file2.getAbsolutePath(), (Object)(file3 != null ? file3.getAbsolutePath() : null))) {
            return XcItemOperationResult.NotAffected;
        }
        if (!this.isEmpty() && Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.replaceSingleConfirmation.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return XcItemOperationResult.Canceled;
        }
        Intrinsics.checkNotNull((Object)file2);
        return this.trySetupNewImage(file2);
    }

    @Override
    @NotNull
    protected List<JBMenuItem> createPopupMenuItems() {
        List list2;
        if (this.isEmpty()) {
            list2 = CollectionsKt.listOf((Object)this.setPictureMenuItem);
        } else {
            Object[] objectArray = new JBMenuItem[]{this.setPictureMenuItem, this.unsetPictureMenuItem, this.revealFileMenuItem};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        return list2;
    }

    @NotNull
    protected final XcItemOperationResult trySetupNewImage(@NotNull File originFile) {
        Intrinsics.checkNotNullParameter((Object)originFile, (String)"originFile");
        ImageReadResults imageReadResults = this.readImage(originFile);
        if (!imageReadResults.isValid()) {
            Messages.showErrorDialog((String)imageReadResults.getErrorMessage(), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.invalidImage.title", new Object[0]));
            return imageReadResults.getOperationResult();
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = XcItemOperationResult.Success;
        this.asset.getFolder().editScope((Function0<Unit>)((Function0)new Function0<Unit>(this, originFile, (Ref.ObjectRef<XcItemOperationResult>)objectRef, imageReadResults){
            final /* synthetic */ XcImageAssetItemPresenterBase<TModel> this$0;
            final /* synthetic */ File $originFile;
            final /* synthetic */ Ref.ObjectRef<XcItemOperationResult> $results;
            final /* synthetic */ ImageReadResults $validationResults;
            {
                this.this$0 = $receiver;
                this.$originFile = $originFile;
                this.$results = $results;
                this.$validationResults = $validationResults;
                super(0);
            }

            public final void invoke() {
                String string;
                if (XcImageAssetItemPresenterBase.access$needToCreateCopy(this.this$0, this.$originFile)) {
                    v0 = this.this$0.getAsset().getFolder().copyToDirectory(this.$originFile);
                } else {
                    XcAssetFolder xcAssetFolder = this.this$0.getAsset().getFolder();
                    String string2 = this.$originFile.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    xcAssetFolder.includeInWorkspaceModelIfNotIncluded(string2);
                    v0 = string = this.$originFile.getName();
                }
                if (Intrinsics.areEqual((Object)string, (Object)((XcAssetItemWithFile)this.this$0.getModel()).getFileName())) {
                    this.$results.element = XcItemOperationResult.NotAffected;
                    return;
                }
                File file2 = this.this$0.getAsset().getFolder().searchExistedFile(string);
                if (file2 == null) {
                    Messages.showErrorDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.cannotCopy.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.images.cannotCopy.title", new Object[0]));
                    this.$results.element = XcItemOperationResult.FileNotFound;
                    return;
                }
                this.this$0.setNormalState();
                this.this$0.setImageInfo(PresenterUtilsKt.getImageInfo(this.$validationResults.getLoadedImage()));
                Icon icon2 = this.this$0.getIcon(this.$validationResults.getLoadedImage());
                XcImageAssetItemPresenterBase.access$setMyCurrentFile$p(this.this$0, file2);
                ((XcAssetItemWithFile)this.this$0.getModel()).setFileName(string);
                XcImageAssetItemPresenterBase.access$paintIcon(this.this$0, icon2, file2);
                this.this$0.modelChanged();
            }
        }));
        this.selectMe();
        return (XcItemOperationResult)((Object)objectRef.element);
    }

    private final boolean j(File file2) {
        if (!((Object)file2.getParentFile().toPath()).equals(this.asset.getFolder().getRoot().toNioPath())) {
            return true;
        }
        String string = file2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        int n2 = this.asset.getCountOfUsage(string);
        return n2 != 0;
    }

    @NotNull
    public Icon getIcon(@Nullable BufferedImage cachedImage) {
        BufferedImage bufferedImage = cachedImage;
        if (bufferedImage == null) {
            AssetItemControl assetItemControl = this.getAssetControl();
            Intrinsics.checkNotNull((Object)assetItemControl);
            return assetItemControl.getStyle().getNoPreviewIcon();
        }
        BufferedImage bufferedImage2 = bufferedImage;
        AssetItemControl assetItemControl = this.getAssetControl();
        Intrinsics.checkNotNull((Object)assetItemControl);
        return new ImageIcon(XcAssetsUiUtilsKt.shrinkPicture(bufferedImage2, assetItemControl.getStyle().getAssetItemContentSize()));
    }

    @NotNull
    protected abstract ImageReadResults readImage(@Nullable File var1);

    private final void j(Icon icon2, File file2) {
        block0: {
            AssetItemControl assetItemControl = this.getAssetControl();
            JComponent jComponent = assetItemControl != null ? assetItemControl.getContentUI() : null;
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.ui.components.JBLabel");
            JBLabel jBLabel = (JBLabel)jComponent;
            jBLabel.setIcon(icon2);
            AssetItemControl assetItemControl2 = this.getAssetControl();
            if (assetItemControl2 == null) break block0;
            String string = file2.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            AssetItemControl.enableContent$default(assetItemControl2, PresenterUtilsKt.createTransferableFile(string), null, 2, null);
        }
    }

    private static final void j(XcImageAssetItemPresenterBase xcImageAssetItemPresenterBase, JBMenuItem jBMenuItem, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)xcImageAssetItemPresenterBase, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jBMenuItem, (String)"$this_apply");
        XcItemOperationResult xcItemOperationResult = xcImageAssetItemPresenterBase.handleAddAction();
        XcAssetsStatistic.addAssetItem.log(jBMenuItem.getClass(), (Object)XcAssetInputSource.ActionMenu, (Object)xcItemOperationResult);
    }

    private static final void N(XcImageAssetItemPresenterBase xcImageAssetItemPresenterBase, ActionEvent actionEvent) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)xcImageAssetItemPresenterBase, (String)"this$0");
            if (Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.removeSingleConfirmation.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                XcAssetsStatistic.removeCanceledAssetItem.log(xcImageAssetItemPresenterBase.getClass(), (Object)XcAssetInputSource.ActionMenu, (Object)1);
                return;
            }
            xcImageAssetItemPresenterBase.handleDeleteAction();
            XcAssetsStatistic.removeAssetItem.log(xcImageAssetItemPresenterBase.getClass(), (Object)XcAssetInputSource.ActionMenu, (Object)1);
            SelectionLogic selectionLogic = xcImageAssetItemPresenterBase.getSelector();
            if (selectionLogic == null) break block1;
            selectionLogic.deselectAll();
        }
    }

    private static final void j(XcImageAssetItemPresenterBase xcImageAssetItemPresenterBase, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)xcImageAssetItemPresenterBase, (String)"this$0");
        File file2 = xcImageAssetItemPresenterBase.asset.getFolder().searchExistedFile(((XcAssetItemWithFile)xcImageAssetItemPresenterBase.getModel()).getFileName());
        if (file2 != null) {
            RevealFileAction.openFile((File)file2);
        }
    }

    public static final /* synthetic */ void access$setMyCurrentFile$p(XcImageAssetItemPresenterBase $this, File file2) {
        $this.myCurrentFile = file2;
    }

    public static final /* synthetic */ boolean access$needToCreateCopy(XcImageAssetItemPresenterBase $this, File file2) {
        return $this.j(file2);
    }

    public static final /* synthetic */ void access$paintIcon(XcImageAssetItemPresenterBase $this, Icon icon2, File originFile) {
        $this.j(icon2, originFile);
    }
}

