/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.project.Project;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetAppIconItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItemWithFile;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcIconUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.AssetEnvironment;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.ImageReadResults;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcImageAssetItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import java.awt.image.BufferedImage;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014R\u0014\u0010\r\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcIconItemPresenter;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcImageAssetItemPresenterBase;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetAppIconItem;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "iconCaption", "", "model", "environment", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetAppIconItem;Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/AssetEnvironment;)V", "caption", "getCaption", "()Ljava/lang/String;", "hint", "getHint", "tooltip", "getTooltip", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "readImage", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/ImageReadResults;", "file", "Ljava/io/File;", "intellij.rider"})
public final class XcIconItemPresenter
extends XcImageAssetItemPresenterBase<XcAssetAppIconItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final String iconCaption;

    public XcIconItemPresenter(@NotNull Lifetime lifetime2, @NotNull Project project, @NotNull String iconCaption, @NotNull XcAssetAppIconItem model2, @NotNull AssetEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)iconCaption, (String)"iconCaption");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        super(lifetime2, (XcAssetItemWithFile)model2, environment);
        this.project = project;
        this.iconCaption = iconCaption;
    }

    public /* synthetic */ XcIconItemPresenter(Lifetime lifetime2, Project project, String string, XcAssetAppIconItem xcAssetAppIconItem, AssetEnvironment assetEnvironment, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string = "";
        }
        this(lifetime2, project, string, xcAssetAppIconItem, assetEnvironment);
    }

    @Override
    @NotNull
    protected String getHint() {
        return XcIconUtilsKt.getScreenHint((XcAssetAppIconItem)this.getModel());
    }

    @Override
    @NotNull
    protected String getCaption() {
        return ((CharSequence)this.iconCaption).length() == 0 ? ((XcAssetAppIconItem)this.getModel()).getScale().getValue() + "x" : ((XcAssetAppIconItem)this.getModel()).getScale().getValue() + "x\r" + this.iconCaption;
    }

    @Override
    @NotNull
    protected String getTooltip() {
        String string = PresenterUtilsKt.getImageTooltipText(this.getImageInfo(), this.getCurrentFile(), this.getErrorStateMessage());
        if (string == null) {
            string = RiderMultiPlatformBundle.Companion.message("rider.xcassets.appiconset.notset.tooltip", new Object[0]);
        }
        return string;
    }

    @Override
    @NotNull
    public XcItemOperationResult handleAddAction() {
        File file2 = PresenterUtilsKt.selectWithFileDialogOrNull(this.project, RiderMultiPlatformBundle.Companion.message("rider.xcassets.appiconset.selectfile.title", new Object[0]));
        if (file2 == null) {
            return XcItemOperationResult.Canceled;
        }
        File file3 = file2;
        return this.trySetupNewImage(file3);
    }

    @Override
    @NotNull
    protected ImageReadResults readImage(@Nullable File file2) {
        if (file2 == null || !file2.exists()) {
            return ImageReadResults.Companion.failed$default(ImageReadResults.Companion, XcItemOperationResult.FileNotFound, null, 2, null);
        }
        if (!StringsKt.equals((String)FilesKt.getExtension((File)file2), (String)"png", (boolean)true)) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"getName(...)");
            return ImageReadResults.Companion.failed(XcItemOperationResult.WrongFormat, RiderMultiPlatformBundle.Companion.message("rider.xcassets.appiconset.selectfile.invalidfileExtension", objectArray));
        }
        BufferedImage bufferedImage = PresenterUtilsKt.openImageOrNull(file2);
        if (bufferedImage == null) {
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNullExpressionValue((Object)file2.getName(), (String)"getName(...)");
            return ImageReadResults.Companion.failed(XcItemOperationResult.WrongFormat, RiderMultiPlatformBundle.Companion.message("rider.xcassets.appiconset.selectfile.invalidFile", objectArray));
        }
        BufferedImage bufferedImage2 = bufferedImage;
        int n2 = XcIconUtilsKt.getIconSize((XcAssetAppIconItem)this.getModel());
        if (bufferedImage2.getWidth() != n2 || bufferedImage2.getHeight() != n2) {
            this.setImageInfo(PresenterUtilsKt.emptyImageInfo());
            Object[] objectArray = new Object[]{n2, bufferedImage2.getWidth(), bufferedImage2.getHeight()};
            return ImageReadResults.Companion.failed(XcItemOperationResult.WrongSize, RiderMultiPlatformBundle.Companion.message("rider.xcassets.appiconset.selectfile.invalidDimension", objectArray));
        }
        return ImageReadResults.Companion.success(bufferedImage2);
    }
}

