/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.Messages;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColor;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColorAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcJsonModelsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.PresenterUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemOperationResult;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.AssetItemControl;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.ColoredRect;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import icons.ReSharperIcons;
import java.awt.Color;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0017\u001a\u00020\fH\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0014J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\fH\u0016J\b\u0010\"\u001a\u00020\fH\u0002J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020 2\u0006\u0010'\u001a\u00020*H\u0014R\u0014\u0010\u000e\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\t8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006+"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "model", "hint", "", "onColorChanged", "Lkotlin/Function0;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "caption", "getCaption", "()Ljava/lang/String;", "getHint", "isEmpty", "", "()Z", "tooltip", "getTooltip", "afterDraw", "createContentUI", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/ColoredRect;", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "createPopupMenuItems", "", "Lcom/intellij/openapi/ui/JBMenuItem;", "handleAddAction", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemOperationResult;", "handleDeleteAction", "w", "j", "color", "Ljava/awt/Color;", "tryDrag", "dtde", "Ljava/awt/dnd/DropTargetDragEvent;", "tryDrop", "Ljava/awt/dnd/DropTargetDropEvent;", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcColorItemPresenter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcColorItemPresenter.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,114:1\n1#2:115\n12474#3,2:116\n12474#3,2:118\n*S KotlinDebug\n*F\n+ 1 XcColorItemPresenter.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcColorItemPresenter\n*L\n68#1:116,2\n71#1:118,2\n*E\n"})
public final class XcColorItemPresenter
extends XcItemPresenterBase<XcColorAssetItem> {
    @NotNull
    private final Project project;
    @NotNull
    private final String hint;

    public XcColorItemPresenter(@NotNull Lifetime lifetime2, @NotNull Project project, @NotNull XcColorAssetItem model2, @NotNull String hint, @NotNull Function0<Unit> onColorChanged) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
        Intrinsics.checkNotNullParameter(onColorChanged, (String)"onColorChanged");
        super(lifetime2, model2, onColorChanged);
        this.project = project;
        this.hint = hint;
    }

    public /* synthetic */ XcColorItemPresenter(Lifetime lifetime2, Project project, XcColorAssetItem xcColorAssetItem, String string, Function0 function0, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            string = "";
        }
        if ((n2 & 0x10) != 0) {
            function0 = 1.INSTANCE;
        }
        this(lifetime2, project, xcColorAssetItem, string, (Function0<Unit>)function0);
    }

    @Override
    @NotNull
    protected String getHint() {
        return this.hint;
    }

    @Override
    @NotNull
    protected String getCaption() {
        return ModelUtilsKt.getLuminosity((XcAssetItem)this.getModel()) + " appearance";
    }

    @Override
    @NotNull
    protected String getTooltip() {
        String string;
        if (this.isEmpty()) {
            string = this.getCaption() + "\r\n" + RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.notSet.tooltip", new Object[0]);
        } else {
            String string2 = this.getCaption();
            Object object = ((XcColorAssetItem)this.getModel()).getColor();
            if (object == null || (object = ((XcColor)object).getColor()) == null) {
                object = Color.BLACK;
            }
            Object object2 = object;
            Intrinsics.checkNotNull((Object)object2);
            String string3 = this.j((Color)object2).toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
            string = string2 + "\r\n" + string3;
        }
        return string;
    }

    @Override
    public boolean isEmpty() {
        XcColor xcColor = ((XcColorAssetItem)this.getModel()).getColor();
        return (xcColor != null ? xcColor.getComponents() : null) == null;
    }

    @Override
    @NotNull
    public XcItemOperationResult handleAddAction() {
        Object object = ((XcColorAssetItem)this.getModel()).getColor();
        if (object == null || (object = ((XcColor)object).getColor()) == null) {
            object = Color.BLACK;
        }
        Object object2 = object;
        Intrinsics.checkNotNull((Object)object2);
        PresenterUtilsKt.selectColorFromColorPicker(this.project, (Color)object2, (Function1<? super Color, Unit>)((Function1)new Function1<Color, Unit>(this){
            final /* synthetic */ XcColorItemPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Color it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                XcColor xcColor = ((XcColorAssetItem)this.this$0.getModel()).getColor();
                if (Intrinsics.areEqual((Object)(xcColor != null ? xcColor.getColor() : null), (Object)it)) {
                    return;
                }
                ((XcColorAssetItem)this.this$0.getModel()).setColor(new XcColor("srgb", XcJsonModelsKt.colorComponentFromColor(it)));
                XcColorItemPresenter.access$paintCurrentColor(this.this$0);
                this.this$0.modelChanged();
            }
        }));
        return XcItemOperationResult.Success;
    }

    @Override
    public void handleDeleteAction() {
        ((XcColorAssetItem)this.getModel()).setColor(new XcColor("srgb", null));
        this.w();
        this.modelChanged();
    }

    @Override
    @NotNull
    protected ColoredRect createContentUI(@NotNull XcAssetsStyle style) {
        ColoredRect coloredRect;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        ColoredRect coloredRect2 = coloredRect = new ColoredRect(style.getAssetItemContentSize(), style.getBorderThickness(), style.getBorderCornerRadius(), style.getBackColor(), Color.red);
        boolean bl = false;
        coloredRect2.setBackground(null);
        return coloredRect;
    }

    @Override
    protected void afterDraw() {
        this.w();
    }

    @Override
    protected boolean tryDrag(@NotNull DropTargetDragEvent dtde) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
            DataFlavor[] dataFlavorArray = dtde.getTransferable().getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] objectArray = dataFlavorArray;
            boolean bl2 = false;
            for (Object object : objectArray) {
                DataFlavor dataFlavor = (DataFlavor)object;
                boolean bl3 = false;
                if (!dataFlavor.isFlavorTextType()) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    protected XcItemOperationResult tryDrop(@NotNull DropTargetDropEvent dtde) {
        XcItemOperationResult xcItemOperationResult;
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)dtde, (String)"dtde");
            DataFlavor[] dataFlavorArray = dtde.getTransferable().getTransferDataFlavors();
            Intrinsics.checkNotNullExpressionValue((Object)dataFlavorArray, (String)"getTransferDataFlavors(...)");
            Object[] object = dataFlavorArray;
            boolean color2 = false;
            for (Object object2 : object) {
                DataFlavor dataFlavor = (DataFlavor)object2;
                boolean bl2 = false;
                if (!dataFlavor.isFlavorTextType()) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (!bl) {
            return XcItemOperationResult.InvalidDndContent;
        }
        String string = (String)dtde.getTransferable().getTransferData(DataFlavor.stringFlavor);
        Color color = PresenterUtilsKt.tryParseColor(string);
        if (color == null) {
            return XcItemOperationResult.InvalidDndContent;
        }
        Color color2 = color;
        XcColor xcColor = ((XcColorAssetItem)this.getModel()).getColor();
        if (Intrinsics.areEqual((Object)(xcColor != null ? xcColor.getColor() : null), (Object)color2)) {
            return XcItemOperationResult.NotAffected;
        }
        if (!this.isEmpty() && Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.replace.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
            return XcItemOperationResult.Canceled;
        }
        ((XcColorAssetItem)this.getModel()).setColor(new XcColor("srgb", XcJsonModelsKt.colorComponentFromColor(color2)));
        this.modelChanged();
        try {
            this.w();
            xcItemOperationResult = XcItemOperationResult.Success;
        }
        catch (Exception exception) {
            xcItemOperationResult = XcItemOperationResult.Exception;
        }
        return xcItemOperationResult;
    }

    @Override
    @NotNull
    protected List<JBMenuItem> createPopupMenuItems() {
        JBMenuItem jBMenuItem;
        JBMenuItem jBMenuItem2 = jBMenuItem = new JBMenuItem(RiderMultiPlatformBundle.Companion.message("rider.xcassets.colorset.openpicker.menuItem", new Object[0]), ReSharperIcons.Common.ColorSelection16x16);
        boolean bl = false;
        jBMenuItem2.addActionListener(arg_0 -> XcColorItemPresenter.j(this, arg_0));
        return CollectionsKt.listOf((Object)jBMenuItem);
    }

    private final void w() {
        block1: {
            Object object = ((XcColorAssetItem)this.getModel()).getColor();
            if (object == null || (object = ((XcColor)object).getColor()) == null) {
                object = new Color(0, 0, 0, 0);
            }
            Object object2 = object;
            AssetItemControl assetItemControl = this.getAssetControl();
            JComponent jComponent = assetItemControl != null ? assetItemControl.getContentUI() : null;
            Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.jetbrains.rider.multiPlatform.xcAssets.ui.ColoredRect");
            ColoredRect coloredRect = (ColoredRect)jComponent;
            coloredRect.setCurrentColor((Color)object2);
            AssetItemControl assetItemControl2 = this.getAssetControl();
            if (assetItemControl2 == null) break block1;
            AssetItemControl.enableContent$default(assetItemControl2, new StringSelection(this.j((Color)object2)), null, 2, null);
        }
    }

    private final String j(Color color) {
        String string = "%02x";
        Object[] objectArray = new Object[]{color.getRed()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getGreen()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getBlue()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        string = "%02x";
        objectArray = new Object[]{color.getAlpha()};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        return "#" + string2 + string3 + string4 + string5;
    }

    private static final void j(XcColorItemPresenter xcColorItemPresenter, ActionEvent actionEvent) {
        Intrinsics.checkNotNullParameter((Object)xcColorItemPresenter, (String)"this$0");
        xcColorItemPresenter.handleAddAction();
    }

    public static final /* synthetic */ void access$paintCurrentColor(XcColorItemPresenter $this) {
        $this.w();
    }
}

