/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.presenters;

import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0015\u001a\u00020\u00142\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u0013J\u0014\u0010\u0017\u001a\u00020\u00142\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0002J\u0006\u0010\u0019\u001a\u00020\u0014J\b\u0010\u001a\u001a\u00020\u0014H\u0002J\u0012\u0010\u001b\u001a\u00020\u00142\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0006\u0010\u001c\u001a\u00020\u0014J\u0012\u0010\u001d\u001a\u00020\u00142\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010\u001e\u001a\u00020\u00142\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0012\u0010\u001f\u001a\u00020\u00142\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0006\u0010 \u001a\u00020\u0014R&\u0010\u0003\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R \u0010\u0011\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "", "()V", "allOrderedItems", "Ljava/util/ArrayList;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemPresenterBase;", "Lkotlin/collections/ArrayList;", "currentlySelectedItems", "lastSelectionIndex", "", "registratedCount", "getRegistratedCount", "()I", "selectedItems", "", "getSelectedItems", "()Ljava/util/List;", "selectedListChangedObservers", "", "Lkotlin/Function1;", "", "addSelectedListChangedChanged", "delegate", "j", "item", "deselectAll", "j", "registrate", "removeAllListeners", "select", "selectWithControl", "selectWithShift", "unregistrateAll", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSelectionLogic.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SelectionLogic.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,111:1\n1855#2,2:112\n1855#2,2:114\n*S KotlinDebug\n*F\n+ 1 SelectionLogic.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic\n*L\n45#1:112,2\n104#1:114,2\n*E\n"})
public final class SelectionLogic {
    @NotNull
    private final ArrayList<XcItemPresenterBase<?>> allOrderedItems = new ArrayList();
    @NotNull
    private final ArrayList<XcItemPresenterBase<?>> currentlySelectedItems = new ArrayList();
    private int lastSelectionIndex;
    @NotNull
    private final List<Function1<SelectionLogic, Unit>> selectedListChangedObservers = new ArrayList();

    public final int getRegistratedCount() {
        return this.allOrderedItems.size();
    }

    @NotNull
    public final List<XcItemPresenterBase<?>> getSelectedItems() {
        return this.currentlySelectedItems;
    }

    public final void addSelectedListChangedChanged(@NotNull Function1<? super SelectionLogic, Unit> delegate) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        this.selectedListChangedObservers.add(delegate);
    }

    public final void removeAllListeners() {
        this.selectedListChangedObservers.clear();
    }

    public final void registrate(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.allOrderedItems.add(item);
        item.setSelectionOrder(((Collection)this.allOrderedItems).size() - 1);
    }

    public final void unregistrateAll() {
        this.allOrderedItems.clear();
        this.lastSelectionIndex = 0;
        this.currentlySelectedItems.clear();
    }

    public final void deselectAll() {
        Iterable iterable = this.allOrderedItems;
        boolean bl = false;
        for (Object t : iterable) {
            XcItemPresenterBase xcItemPresenterBase = (XcItemPresenterBase)t;
            boolean bl2 = false;
            xcItemPresenterBase.setSelected(false);
        }
        if (this.currentlySelectedItems.size() > 0) {
            this.currentlySelectedItems.clear();
            this.j();
        }
    }

    public final void select(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.deselectAll();
        this.j(item);
        this.j();
    }

    public final void selectWithShift(@NotNull XcItemPresenterBase<?> item) {
        int n2;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (this.currentlySelectedItems.isEmpty() || this.lastSelectionIndex < 0) {
            this.select(item);
            return;
        }
        int n3 = Math.min(item.getSelectionOrder(), this.lastSelectionIndex);
        int n4 = n3;
        if (n4 <= (n2 = Math.max(item.getSelectionOrder(), this.lastSelectionIndex))) {
            while (true) {
                XcItemPresenterBase<?> xcItemPresenterBase;
                Intrinsics.checkNotNullExpressionValue(this.allOrderedItems.get(n4), (String)"get(...)");
                if (!xcItemPresenterBase.isSelected()) {
                    xcItemPresenterBase.setSelected(true);
                    this.currentlySelectedItems.add(xcItemPresenterBase);
                }
                if (n4 == n2) break;
                ++n4;
            }
        }
        this.j();
    }

    public final void selectWithControl(@NotNull XcItemPresenterBase<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        if (!item.isSelected()) {
            this.j(item);
            return;
        }
        item.setSelected(false);
        this.currentlySelectedItems.remove(item);
        if (this.lastSelectionIndex == item.getSelectionOrder()) {
            for (XcItemPresenterBase<?> xcItemPresenterBase : this.currentlySelectedItems) {
                this.lastSelectionIndex = Math.min(this.lastSelectionIndex, xcItemPresenterBase.getSelectionOrder());
            }
        }
        this.j();
    }

    private final void j() {
        Iterable iterable = this.selectedListChangedObservers;
        boolean bl = false;
        for (Object t : iterable) {
            Function1 function1 = (Function1)t;
            boolean bl2 = false;
            function1.invoke((Object)this);
        }
    }

    private final void j(XcItemPresenterBase<?> xcItemPresenterBase) {
        xcItemPresenterBase.setSelected(true);
        this.currentlySelectedItems.add(xcItemPresenterBase);
        this.lastSelectionIndex = xcItemPresenterBase.getSelectionOrder();
    }
}

