/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.models;

import com.google.gson.GsonBuilder;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetEditorUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.AssetAppearance;
import com.jetbrains.rider.multiPlatform.xcAssets.models.Idiom;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetColorset;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColor;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcColorAssetItem;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcColorItemPresenter;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemPresenterBase;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcItemsGroupPresenter;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\f\u001a\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0001\u00a8\u0006\u0016"}, d2={"createEmptyAssetColorItem", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorAssetItem;", "idiom", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/Idiom;", "appearance", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/AssetAppearance;", "readColorXcAssets", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetColorset;", "reader", "Ljava/io/Reader;", "readColorXcAssetsFromString", "text", "", "saveColorset", "", "set", "path", "trySetToDeviceItem", "", "device", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcItemsGroupPresenter;", "image", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nXcColorUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XcColorUtils.kt\ncom/jetbrains/rider/multiPlatform/xcAssets/models/XcColorUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,42:1\n1#2:43\n*E\n"})
public final class XcColorUtilsKt {
    @NotNull
    public static final XcAssetColorset readColorXcAssetsFromString(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return XcColorUtilsKt.readColorXcAssets(new StringReader(text2));
    }

    @NotNull
    public static final XcAssetColorset readColorXcAssets(@NotNull Reader reader) {
        XcAssetColorset xcAssetColorset;
        XcAssetColorset xcAssetColorset2;
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        XcAssetColorset xcAssetColorset3 = xcAssetColorset2 = (XcAssetColorset)new GsonBuilder().setLenient().create().fromJson(reader, XcAssetColorset.class);
        if ((xcAssetColorset3 != null ? xcAssetColorset3.getColors() : null) == null) {
            xcAssetColorset = new XcAssetColorset(CollectionsKt.emptyList(), xcAssetColorset2.getInfo());
        } else {
            Intrinsics.checkNotNull((Object)xcAssetColorset2);
            xcAssetColorset = xcAssetColorset2;
        }
        return xcAssetColorset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void saveColorset(@NotNull XcAssetColorset set, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)set, (String)"set");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Closeable closeable = new FileWriter(path);
        Throwable throwable = null;
        try {
            FileWriter fileWriter = (FileWriter)closeable;
            boolean bl = false;
            ModelUtilsKt.serializeToJson(set, fileWriter);
            fileWriter = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public static final boolean trySetToDeviceItem(@NotNull XcItemsGroupPresenter device, @NotNull XcColorAssetItem image) {
        Intrinsics.checkNotNullParameter((Object)device, (String)"device");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        for (XcItemPresenterBase<?> xcItemPresenterBase : device.getItems()) {
            Intrinsics.checkNotNull(xcItemPresenterBase, (String)"null cannot be cast to non-null type com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcColorItemPresenter");
            XcColorItemPresenter xcColorItemPresenter = (XcColorItemPresenter)xcItemPresenterBase;
            if (!((XcColorAssetItem)xcColorItemPresenter.getModel()).fits(image)) continue;
            ((XcColorAssetItem)xcColorItemPresenter.getModel()).setColor(image.getColor());
            return true;
        }
        return false;
    }

    @NotNull
    public static final XcColorAssetItem createEmptyAssetColorItem(@NotNull Idiom idiom, @NotNull AssetAppearance appearance) {
        Intrinsics.checkNotNullParameter((Object)((Object)idiom), (String)"idiom");
        Intrinsics.checkNotNullParameter((Object)((Object)appearance), (String)"appearance");
        return new XcColorAssetItem(idiom, new XcColor("srgb", null), XcAssetEditorUtilsKt.toAppearances(appearance));
    }
}

