/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.editors;

import com.google.gson.JsonSyntaxException;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FailedEditorBuilder;
import com.intellij.openapi.fileEditor.impl.FailedEditorPaneKt;
import com.intellij.openapi.fileEditor.impl.MultilineWrapMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.ContentsJsonFailure;
import com.jetbrains.rider.multiPlatform.xcAssets.UserConfirmationResults;
import com.jetbrains.rider.multiPlatform.xcAssets.XcAssetsStatistic;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.TypeOfFsChanges;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetFolder;
import com.jetbrains.rider.multiPlatform.xcAssets.editors.XcAssetEditorUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.models.XcAssetInfo;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.SelectionLogic;
import com.jetbrains.rider.multiPlatform.xcAssets.presenters.XcAssetPresenter;
import com.jetbrains.rider.multiPlatform.xcAssets.ui.XcAssetsStyle;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0007\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H$J\r\u0010(\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010)J\u001d\u0010*\u001a\u00020'2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010.J\u0012\u0010/\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H$J\b\u00100\u001a\u000201H\u0016J\u0015\u00102\u001a\u00020'2\u0006\u0010-\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u00103J\b\u00104\u001a\u000201H\u0002J\b\u00105\u001a\u000201H\u0002J\u0006\u00106\u001a\u00020\u0014J\u0006\u00107\u001a\u00020\u0006J\u0017\u00108\u001a\u0004\u0018\u00010\r2\u0006\u0010-\u001a\u00028\u0000H$\u00a2\u0006\u0002\u00109J\u0006\u0010:\u001a\u00020\u0014J\u0006\u0010;\u001a\u00020\u0017J\u0006\u0010<\u001a\u00020\u0017J\u0015\u0010=\u001a\u00028\u00002\u0006\u0010>\u001a\u00020?H$\u00a2\u0006\u0002\u0010@J\n\u0010A\u001a\u0004\u0018\u00010'H\u0002J\u0015\u0010B\u001a\u0002012\u0006\u0010-\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010CJ\u0006\u0010D\u001a\u000201J\u0010\u0010E\u001a\u0002012\u0006\u0010&\u001a\u00020'H\u0014R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006F"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/editors/XcAssetEditorBase;", "TAssetModel", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "assetFolder", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "getAssetFolder", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "info", "Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "getInfo", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "myInfo", "myIsValid", "", "presenterSequentialLifetime", "Lcom/jetbrains/rd/util/lifetime/SequentialLifetimes;", "selector", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "getSelector", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;", "setSelector", "(Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/SelectionLogic;)V", "style", "Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "getStyle", "()Lcom/jetbrains/rider/multiPlatform/xcAssets/ui/XcAssetsStyle;", "createBottomPanel", "Ljavax/swing/JComponent;", "presenter", "Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "createEmptyModel", "()Ljava/lang/Object;", "createPresenter", "presenterLifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "createPropertyPanel", "dispose", "", "j", "(Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/presenters/XcAssetPresenter;", "j", "N", "getComponent", "getFile", "getInfoFrom", "(Ljava/lang/Object;)Lcom/jetbrains/rider/multiPlatform/xcAssets/models/XcAssetInfo;", "getPreferredFocusedComponent", "isModified", "isValid", "parseModel", "input", "", "(Ljava/lang/String;)Ljava/lang/Object;", "j", "saveModel", "(Ljava/lang/Object;)V", "selectNotify", "synchronizeWorkspaceModel", "intellij.rider"})
public abstract class XcAssetEditorBase<TAssetModel>
extends DesignerEditorBase {
    @NotNull
    private final VirtualFile root;
    @NotNull
    private SelectionLogic selector;
    @NotNull
    private final BorderLayoutPanel mainPanel;
    private boolean myIsValid;
    @NotNull
    private XcAssetInfo myInfo;
    @NotNull
    private final XcAssetFolder assetFolder;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SequentialLifetimes presenterSequentialLifetime;
    @NotNull
    private final XcAssetsStyle style;

    public XcAssetEditorBase(@NotNull Project project, @NotNull VirtualFile root2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        super(project);
        this.root = root2;
        this.selector = new SelectionLogic();
        this.mainPanel = new BorderLayoutPanel();
        this.myIsValid = true;
        this.myInfo = XcAssetEditorUtilsKt.getDefaultInfo();
        Logger logger2 = Logger.getInstance((String)"#com.intellij.xamarin.XcAssetFileEditorImpl");
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        this.presenterSequentialLifetime = new SequentialLifetimes(this.getLifetime());
        this.style = XcAssetEditorUtilsKt.getAssetStyle();
        this.assetFolder = new XcAssetFolder(this.getLifetime(), this.root, project, (Function1<? super TypeOfFsChanges, Unit>)((Function1)new Function1<TypeOfFsChanges, Unit>(){

            public final void invoke(@NotNull TypeOfFsChanges source) {
                Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
                XcAssetPresenter xcAssetPresenter = this.j();
                if (xcAssetPresenter != null && source == TypeOfFsChanges.HasToBeProcessed) {
                    this.synchronizeWorkspaceModel(xcAssetPresenter);
                }
            }
        }));
        this.j();
    }

    @NotNull
    protected final SelectionLogic getSelector() {
        return this.selector;
    }

    protected final void setSelector(@NotNull SelectionLogic selectionLogic) {
        Intrinsics.checkNotNullParameter((Object)selectionLogic, (String)"<set-?>");
        this.selector = selectionLogic;
    }

    @NotNull
    protected final XcAssetFolder getAssetFolder() {
        return this.assetFolder;
    }

    @NotNull
    protected final XcAssetInfo getInfo() {
        return this.myInfo;
    }

    @NotNull
    protected final XcAssetsStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.root;
    }

    public final boolean isValid() {
        return this.root.isValid() && this.myIsValid;
    }

    public final boolean isModified() {
        return false;
    }

    public void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
    }

    @NotNull
    public final BorderLayoutPanel getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public final BorderLayoutPanel getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    public final void selectNotify() {
        Document document2 = FileDocumentManager.getInstance().getCachedDocument(this.root);
        if (document2 != null) {
            FileDocumentManager.getInstance().saveDocument(document2);
        }
    }

    @NotNull
    protected abstract XcAssetPresenter createPresenter(@NotNull Lifetime var1, TAssetModel var2);

    @Nullable
    protected abstract XcAssetInfo getInfoFrom(TAssetModel var1);

    protected abstract TAssetModel parseModel(@NotNull String var1);

    protected abstract TAssetModel createEmptyModel();

    @Nullable
    protected abstract JComponent createPropertyPanel(@NotNull XcAssetPresenter var1);

    @Nullable
    protected abstract JComponent createBottomPanel(@NotNull XcAssetPresenter var1);

    protected void synchronizeWorkspaceModel(@NotNull XcAssetPresenter presenter) {
        Intrinsics.checkNotNullParameter((Object)presenter, (String)"presenter");
    }

    protected final void saveModel(TAssetModel model2) {
        Intrinsics.checkNotNull(model2, (String)"null cannot be cast to non-null type kotlin.Any");
        this.assetFolder.writeContentsJson(ModelUtilsKt.serializeToTextJson(model2));
    }

    private final XcAssetPresenter j() {
        TAssetModel TAssetModel;
        String string = this.assetFolder.readContentsJson();
        if (string == null) {
            this.logger.warn("Cannot open editor " + ((Object)((Object)this)).getClass().getName() + " because Contents.json is missing}");
            this.N();
            return null;
        }
        if (((CharSequence)string).length() == 0) {
            this.logger.warn("Cannot open editor " + ((Object)((Object)this)).getClass().getName() + " because Contents.json is empty}");
            this.j();
            return null;
        }
        try {
            TAssetModel = this.parseModel(string);
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            String string2 = ((Object)((Object)this)).getClass().getName();
            String string3 = jsonSyntaxException.getMessage();
            if (string3 == null) {
                string3 = jsonSyntaxException.toString();
            }
            this.logger.warn("Cannot open editor " + string2 + ": " + string3);
            this.j();
            return null;
        }
        TAssetModel TAssetModel2 = TAssetModel;
        return this.j(TAssetModel2);
    }

    private final XcAssetPresenter j(TAssetModel TAssetModel) {
        this.myIsValid = false;
        XcAssetInfo xcAssetInfo = this.getInfoFrom(TAssetModel);
        if (xcAssetInfo == null) {
            xcAssetInfo = XcAssetEditorUtilsKt.getDefaultInfo();
        }
        this.myInfo = xcAssetInfo;
        this.selector.unregistrateAll();
        XcAssetPresenter xcAssetPresenter = this.createPresenter((Lifetime)this.presenterSequentialLifetime.next(), TAssetModel);
        JComponent jComponent = this.createPropertyPanel(xcAssetPresenter);
        JComponent jComponent2 = this.createBottomPanel(xcAssetPresenter);
        this.mainPanel.removeAll();
        JBScrollPane jBScrollPane = new JBScrollPane((Component)xcAssetPresenter.draw(this.style));
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jBScrollPane.setBorder((Border)new EmptyBorder(0, 0, 0, 0));
        if (jComponent != null) {
            this.mainPanel.addToTop((Component)jComponent);
        }
        if (jComponent2 != null) {
            this.mainPanel.addToBottom((Component)jComponent2);
        }
        this.mainPanel.addToCenter((Component)jBScrollPane);
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
        this.myIsValid = true;
        return xcAssetPresenter;
    }

    private final void N() {
        this.myIsValid = false;
        XcAssetsStatistic.corruptedAsset.log(((Object)((Object)this)).getClass(), (Object)ContentsJsonFailure.JsonIsMissing);
        this.mainPanel.removeAll();
        Object[] objectArray = new Object[]{"Contents.json"};
        this.mainPanel.addToCenter((Component)FailedEditorPaneKt.failedEditorPane((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsMissing.message", objectArray), (boolean)true, (MultilineWrapMode)MultilineWrapMode.DoNotWrap, (Function1)((Function1)new Function1<FailedEditorBuilder, Unit>(this){
            final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FailedEditorBuilder $this$failedEditorPane) {
                Intrinsics.checkNotNullParameter((Object)$this$failedEditorPane, (String)"$this$failedEditorPane");
                String string = RevealFileAction.getActionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
                $this$failedEditorPane.link(string, (Function0)new Function0<Unit>($this$failedEditorPane, this.this$0){
                    final /* synthetic */ FailedEditorBuilder $this_failedEditorPane;
                    final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
                    {
                        this.$this_failedEditorPane = $this_failedEditorPane;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        XcAssetsStatistic.revealCorruptedAsset.log(this.$this_failedEditorPane.getClass(), (Object)((Object)ContentsJsonFailure.JsonIsMissing));
                        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)XcAssetEditorBase.access$getRoot$p(this.this$0)));
                    }
                });
                Object[] objectArray = new Object[]{"Contents.json"};
                $this$failedEditorPane.link(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsMissing.generate.link", objectArray), (Function0)new Function0<Unit>($this$failedEditorPane, this.this$0){
                    final /* synthetic */ FailedEditorBuilder $this_failedEditorPane;
                    final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
                    {
                        this.$this_failedEditorPane = $this_failedEditorPane;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        XcAssetsStatistic.recreateCorruptedContentsJson.log(this.$this_failedEditorPane.getClass(), (Object)((Object)ContentsJsonFailure.JsonIsMissing), (Object)((Object)UserConfirmationResults.ConfirmedNotAsked));
                        this.this$0.saveModel(this.this$0.createEmptyModel());
                        XcAssetEditorBase.access$refreshUI(this.this$0);
                    }
                });
            }
        })));
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    private final void j() {
        this.myIsValid = false;
        XcAssetsStatistic.corruptedAsset.log(((Object)((Object)this)).getClass(), (Object)ContentsJsonFailure.JsonIsCorrupted);
        this.mainPanel.removeAll();
        Object[] objectArray = new Object[]{"Contents.json"};
        this.mainPanel.addToCenter((Component)FailedEditorPaneKt.failedEditorPane((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.message", objectArray), (boolean)true, (MultilineWrapMode)MultilineWrapMode.DoNotWrap, (Function1)((Function1)new Function1<FailedEditorBuilder, Unit>(this){
            final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull FailedEditorBuilder $this$failedEditorPane) {
                Intrinsics.checkNotNullParameter((Object)$this$failedEditorPane, (String)"$this$failedEditorPane");
                String string = RevealFileAction.getActionName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getActionName(...)");
                $this$failedEditorPane.link(string, (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        XcAssetsStatistic.revealCorruptedAsset.log(((Object)((Object)this.this$0)).getClass(), (Object)((Object)ContentsJsonFailure.JsonIsCorrupted));
                        RevealFileAction.openDirectory((File)VfsUtil.virtualToIoFile((VirtualFile)XcAssetEditorBase.access$getRoot$p(this.this$0)));
                    }
                });
                Object[] objectArray = new Object[]{"Contents.json"};
                $this$failedEditorPane.link(RiderMultiPlatformBundle.Companion.message(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.link", objectArray), new Object[0]), (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        VirtualFile virtualFile2 = this.this$0.getAssetFolder().getAssetJsonFile();
                        if (virtualFile2 != null) {
                            XcAssetsStatistic.navigateToCorruptedContentsEditor.log(((Object)((Object)this.this$0)).getClass());
                            FileEditorManager.getInstance((Project)this.this$0.getProject()).openFile(virtualFile2, true);
                        } else {
                            Object[] objectArray = new Object[]{"Contents.json"};
                            Messages.showErrorDialog((Project)this.this$0.getProject(), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.fileNotFound.dialog.message", new Object[0]), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.edit.fileNotFound.dialog.title", objectArray));
                            XcAssetEditorBase.access$refreshUI(this.this$0);
                        }
                    }
                });
                objectArray = new Object[]{"Contents.json"};
                $this$failedEditorPane.link(RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.generate.link", objectArray), (Function0)new Function0<Unit>(this.this$0){
                    final /* synthetic */ XcAssetEditorBase<TAssetModel> this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Object[] objectArray = new Object[]{"Contents.json"};
                        if (Messages.showOkCancelDialog((String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.editor.failed.contentsCorrupted.generate.dialog.message", objectArray), (String)RiderMultiPlatformBundle.Companion.message("rider.xcassets.confirm.title", new Object[0]), (String)RiderActionsBundle.Companion.message("button.ok", new Object[0]), (String)RiderActionsBundle.Companion.message("action.cancel.text", new Object[0]), (Icon)Messages.getQuestionIcon()) == 0) {
                            XcAssetsStatistic.recreateCorruptedContentsJson.log(((Object)((Object)this.this$0)).getClass(), (Object)((Object)ContentsJsonFailure.JsonIsCorrupted), (Object)((Object)UserConfirmationResults.Confirmed));
                            this.this$0.saveModel(this.this$0.createEmptyModel());
                            XcAssetEditorBase.access$refreshUI(this.this$0);
                        } else {
                            XcAssetsStatistic.recreateCorruptedContentsJson.log(((Object)((Object)this.this$0)).getClass(), (Object)((Object)ContentsJsonFailure.JsonIsCorrupted), (Object)((Object)UserConfirmationResults.Canceled));
                        }
                    }
                });
            }
        })));
        this.mainPanel.revalidate();
        this.mainPanel.repaint();
    }

    public static final /* synthetic */ VirtualFile access$getRoot$p(XcAssetEditorBase $this) {
        return $this.root;
    }
}

