/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform.xcAssets.assetFolder;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.AssetFolderUtilsKt;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.RootChangesObserverForEditor;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.TypeOfFsChanges;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetContentsFile;
import com.jetbrains.rider.multiPlatform.xcAssets.assetFolder.XcAssetFolder;
import com.jetbrains.rider.multiPlatform.xcAssets.models.ModelUtilsKt;
import com.jetbrains.rider.projectView.actions.addExisting.AddExistingFileSession;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityReference;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\u0018\u0000 12\u00020\u0001:\u00011B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001fJ\u0014\u0010 \u001a\u00020\u000b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\"J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$J\u001a\u0010%\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u0005H\u0002J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0016H\u0002J\u000e\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0016J\b\u0010,\u001a\u0004\u0018\u00010\u0016J\u000e\u0010-\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u0016J\u0012\u0010.\u001a\u0004\u0018\u00010\u001f2\b\u0010+\u001a\u0004\u0018\u00010\u0016J\u000e\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\u0016R\u0013\u0010\r\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "onFileChanges", "Lkotlin/Function1;", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/TypeOfFsChanges;", "", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "assetJsonFile", "getAssetJsonFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "contentsFile", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetContentsFile;", "fsObserver", "Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/RootChangesObserverForEditor;", "getRoot", "rootPath", "", "j", "()Ljava/lang/String;", "rootPointer", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "j", "()Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntityReference;", "copyToDirectory", "source", "Ljava/io/File;", "editScope", "editAction", "Lkotlin/Function0;", "getAllFileNames", "", "j", "virtualFile", "j", "relative", "N", "includeInWorkspaceModelIfNotIncluded", "fileName", "readContentsJson", "removeFile", "searchExistedFile", "writeContentsJson", "content", "Companion", "intellij.rider"})
public final class XcAssetFolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VirtualFile root;
    @NotNull
    private final Project project;
    @NotNull
    private final XcAssetContentsFile contentsFile;
    @Nullable
    private final VirtualFile assetJsonFile;
    @NotNull
    private final RootChangesObserverForEditor fsObserver;

    public XcAssetFolder(@NotNull Lifetime lifetime2, @NotNull VirtualFile root2, @NotNull Project project, @NotNull Function1<? super TypeOfFsChanges, Unit> onFileChanges) {
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)root2, (String)"root");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(onFileChanges, (String)"onFileChanges");
        this.root = root2;
        this.project = project;
        this.contentsFile = new XcAssetContentsFile(this.root, this.project);
        this.assetJsonFile = this.contentsFile.getFile();
        this.fsObserver = RootChangesObserverForEditor.Companion.getInstance(this.project);
        this.fsObserver.startFsListenerIfNotStarted(this, this.root, lifetime2, onFileChanges);
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    private final String j() {
        String string = this.root.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private final ProjectModelEntityReference j() {
        return this.j(this.project, this.root);
    }

    @Nullable
    public final VirtualFile getAssetJsonFile() {
        return this.assetJsonFile;
    }

    public final void editScope(@NotNull Function0<Unit> editAction) {
        Intrinsics.checkNotNullParameter(editAction, (String)"editAction");
        this.fsObserver.registrateEdit(this, editAction);
    }

    public final void removeFile(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, fileName){
            final /* synthetic */ XcAssetFolder this$0;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$fileName = $fileName;
                super(0);
            }

            public final void invoke() {
                CommandProcessor.getInstance().executeCommand(XcAssetFolder.access$getProject$p(this.this$0), () -> removeFile.1.j(this.this$0, this.$fileName), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.removefile", new Object[0]), null);
            }

            private static final Unit j(VirtualFile virtualFile2, XcAssetFolder xcAssetFolder) {
                Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$fileToRemove");
                Intrinsics.checkNotNullParameter((Object)xcAssetFolder, (String)"this$0");
                virtualFile2.delete((Object)xcAssetFolder);
                return Unit.INSTANCE;
            }

            private static final void j(XcAssetFolder xcAssetFolder, String string) {
                Intrinsics.checkNotNullParameter((Object)xcAssetFolder, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)string, (String)"$fileName");
                ProjectModelEntityReference projectModelEntityReference = XcAssetFolder.access$getRootPointer(xcAssetFolder);
                ProjectModelEntity projectModelEntity = projectModelEntityReference != null ? projectModelEntityReference.getEntity(XcAssetFolder.access$getProject$p(xcAssetFolder)) : null;
                ProjectModelEntity projectModelEntity2 = projectModelEntity;
                if (projectModelEntity2 == null || (projectModelEntity2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectModelEntity2)) == null) {
                    return;
                }
                ProjectModelEntity projectModelEntity3 = projectModelEntity2;
                VirtualFile virtualFile2 = projectModelEntity3.findChild(string);
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile2;
                ApplicationKt.getApplication().runWriteAction(() -> removeFile.1.j(virtualFile3, xcAssetFolder));
            }
        }));
    }

    public final void writeContentsJson(@NotNull String content2) {
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, content2){
            final /* synthetic */ XcAssetFolder this$0;
            final /* synthetic */ String $content;
            {
                this.this$0 = $receiver;
                this.$content = $content;
                super(0);
            }

            public final void invoke() {
                XcAssetFolder.access$getContentsFile$p(this.this$0).writeContent(this.$content);
            }
        }));
    }

    @Nullable
    public final String readContentsJson() {
        return this.contentsFile.readContent();
    }

    public final void includeInWorkspaceModelIfNotIncluded(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        File file2 = this.j(fileName);
        WorkspaceModel workspaceModel2 = WorkspaceModel.Companion.getInstance(this.project);
        Path path = file2.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.singleOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)workspaceModel2, (Path)path, (Project)this.project));
        if (projectModelEntity != null) {
            return;
        }
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, file2){
            final /* synthetic */ XcAssetFolder this$0;
            final /* synthetic */ File $source;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                super(0);
            }

            public final void invoke() {
                CommandProcessor.getInstance().executeCommand(XcAssetFolder.access$getProject$p(this.this$0), () -> includeInWorkspaceModelIfNotIncluded.1.j(this.this$0, this.$source), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.addFile", new Object[0]), null);
            }

            private static final void j(XcAssetFolder xcAssetFolder, File file2) {
                Intrinsics.checkNotNullParameter((Object)xcAssetFolder, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"$source");
                ProjectModelEntityReference projectModelEntityReference = XcAssetFolder.access$getRootPointer(xcAssetFolder);
                if (projectModelEntityReference == null || (projectModelEntityReference = projectModelEntityReference.getEntity(XcAssetFolder.access$getProject$p(xcAssetFolder))) == null) {
                    return;
                }
                ProjectModelEntityReference projectModelEntityReference2 = projectModelEntityReference;
                AddExistingFileSession.Companion.run(XcAssetFolder.access$getProject$p(xcAssetFolder), (Function1<? super AddExistingFileSession, Unit>)((Function1)new Function1<AddExistingFileSession, Unit>((ProjectModelEntity)projectModelEntityReference2, file2){
                    final /* synthetic */ ProjectModelEntity $folderEntity;
                    final /* synthetic */ File $source;
                    {
                        this.$folderEntity = $folderEntity;
                        this.$source = $source;
                        super(1);
                    }

                    public final void invoke(@NotNull AddExistingFileSession it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        Path path = this.$source.toPath();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
                        AddExistingFileSession.add$default(it, this.$folderEntity, path, null, 4, null);
                    }
                }));
            }
        }));
    }

    @Nullable
    public final String copyToDirectory(@NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!source.exists()) {
            return null;
        }
        String string = source.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        File file2 = this.N(string);
        this.fsObserver.registrateEdit(this, (Function0<Unit>)((Function0)new Function0<Unit>(this, source, file2){
            final /* synthetic */ XcAssetFolder this$0;
            final /* synthetic */ File $source;
            final /* synthetic */ File $destination;
            {
                this.this$0 = $receiver;
                this.$source = $source;
                this.$destination = $destination;
                super(0);
            }

            public final void invoke() {
                CommandProcessor.getInstance().executeCommand(XcAssetFolder.access$getProject$p(this.this$0), () -> copyToDirectory.1.j(this.this$0, this.$source, this.$destination), RiderMultiPlatformBundle.Companion.message("rider.xcassets.command.movefile", new Object[0]), null);
            }

            private static final VirtualFile j(File file2, XcAssetFolder xcAssetFolder, VirtualFile virtualFile2, File file3) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"$source");
                Intrinsics.checkNotNullParameter((Object)xcAssetFolder, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$folder");
                Intrinsics.checkNotNullParameter((Object)file3, (String)"$destination");
                VirtualFile virtualFile3 = DocumentUtilKt.toVirtualFile$default((File)file2, (boolean)false, (int)1, null);
                if (virtualFile3 == null) {
                    return null;
                }
                VirtualFile virtualFile4 = virtualFile3;
                return VfsUtil.copyFile((Object)xcAssetFolder, (VirtualFile)virtualFile4, (VirtualFile)virtualFile2, (String)file3.getName());
            }

            private static final void j(XcAssetFolder xcAssetFolder, File file2, File file3) {
                Intrinsics.checkNotNullParameter((Object)xcAssetFolder, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"$source");
                Intrinsics.checkNotNullParameter((Object)file3, (String)"$destination");
                ProjectModelEntityReference projectModelEntityReference = XcAssetFolder.access$getRootPointer(xcAssetFolder);
                ProjectModelEntity projectModelEntity = projectModelEntityReference != null ? projectModelEntityReference.getEntity(XcAssetFolder.access$getProject$p(xcAssetFolder)) : null;
                ProjectModelEntity projectModelEntity2 = projectModelEntity;
                if (projectModelEntity2 == null || (projectModelEntity2 = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectModelEntity2)) == null) {
                    return;
                }
                ProjectModelEntity projectModelEntity3 = projectModelEntity2;
                VirtualFile virtualFile2 = (VirtualFile)ApplicationKt.getApplication().runWriteAction(() -> copyToDirectory.1.j(file2, xcAssetFolder, (VirtualFile)projectModelEntity3, file3));
                if (virtualFile2 == null) {
                    return;
                }
                VirtualFile virtualFile3 = virtualFile2;
                AddExistingFileSession.Companion.run(XcAssetFolder.access$getProject$p(xcAssetFolder), (Function1<? super AddExistingFileSession, Unit>)((Function1)new Function1<AddExistingFileSession, Unit>(projectModelEntity, virtualFile3){
                    final /* synthetic */ ProjectModelEntity $folderEntity;
                    final /* synthetic */ VirtualFile $fileToAdd;
                    {
                        this.$folderEntity = $folderEntity;
                        this.$fileToAdd = $fileToAdd;
                        super(1);
                    }

                    public final void invoke(@NotNull AddExistingFileSession it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        AddExistingFileSession.add$default(it, this.$folderEntity, this.$fileToAdd, null, 4, null);
                    }
                }));
            }
        }));
        return file2.getName();
    }

    @Nullable
    public final File searchExistedFile(@Nullable String fileName) {
        Object object = fileName;
        if (object == null || object.length() == 0) {
            return null;
        }
        object = this.j(fileName);
        if (!((File)object).exists()) {
            return null;
        }
        return object;
    }

    @NotNull
    public final List<String> getAllFileNames() {
        Object object = new File(this.j()).list();
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private final File N(String string) {
        File file2 = this.j(string);
        while (file2.exists()) {
            String string2 = ModelUtilsKt.getNextFileName(FilesKt.getNameWithoutExtension((File)file2)) + "." + FilesKt.getExtension((File)file2);
            file2 = this.j(string2);
        }
        return file2;
    }

    private final File j(String string) {
        String[] stringArray = new String[]{string};
        File file2 = Path.of(this.j(), stringArray).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
        return file2;
    }

    private final ProjectModelEntityReference j(Project project, VirtualFile virtualFile2) {
        ProjectModelEntity projectModelEntity = AssetFolderUtilsKt.getEntity(project, virtualFile2);
        return projectModelEntity != null ? ProjectModelEntityExtensionsKt.toReference((ProjectModelEntity)projectModelEntity) : null;
    }

    public static final /* synthetic */ Project access$getProject$p(XcAssetFolder $this) {
        return $this.project;
    }

    public static final /* synthetic */ ProjectModelEntityReference access$getRootPointer(XcAssetFolder $this) {
        return $this.j();
    }

    public static final /* synthetic */ XcAssetContentsFile access$getContentsFile$p(XcAssetFolder $this) {
        return $this.contentsFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0001\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/multiPlatform/xcAssets/assetFolder/XcAssetFolder$Companion;", "", "()V", "createAssetFolderOnDisk", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "parentEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "commandText", "", "folderPath", "Ljava/io/File;", "assetContents", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final VirtualFile createAssetFolderOnDisk(@NotNull Project project, @NotNull ProjectModelEntity parentEntity, @NlsContexts.Command @NotNull String commandText, @NotNull File folderPath, @NotNull Object assetContents) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentEntity, (String)"parentEntity");
            Intrinsics.checkNotNullParameter((Object)commandText, (String)"commandText");
            Intrinsics.checkNotNullParameter((Object)folderPath, (String)"folderPath");
            Intrinsics.checkNotNullParameter((Object)assetContents, (String)"assetContents");
            VirtualFileUrl virtualFileUrl = parentEntity.getUrl();
            if (virtualFileUrl == null || (virtualFileUrl = VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl)) == null) {
                return null;
            }
            VirtualFileUrl virtualFileUrl2 = virtualFileUrl;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            CommandProcessor.getInstance().executeCommand(project, () -> Companion.j(objectRef, project, (VirtualFile)virtualFileUrl2, folderPath, assetContents, parentEntity), commandText, null);
            return (VirtualFile)objectRef.element;
        }

        private static final Pair j(VirtualFile virtualFile2, File file2, Object object) {
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$parentFile");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"$folderPath");
            Intrinsics.checkNotNullParameter((Object)object, (String)"$assetContents");
            VirtualFile virtualFile3 = virtualFile2.createChildDirectory((Object)Companion, file2.getName());
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"createChildDirectory(...)");
            VirtualFile virtualFile4 = virtualFile3;
            VirtualFile virtualFile5 = virtualFile4.createChildData((Object)Companion, "Contents.json");
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile5, (String)"createChildData(...)");
            VirtualFile virtualFile6 = virtualFile5;
            VfsUtil.saveText((VirtualFile)virtualFile6, (String)ModelUtilsKt.serializeToTextJson(object));
            return new Pair((Object)virtualFile4, (Object)virtualFile6);
        }

        private static final void j(Ref.ObjectRef objectRef, Project project, VirtualFile virtualFile2, File file2, Object object, ProjectModelEntity projectModelEntity) {
            Intrinsics.checkNotNullParameter((Object)objectRef, (String)"$resultFile");
            Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
            Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"$parentFile");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"$folderPath");
            Intrinsics.checkNotNullParameter((Object)object, (String)"$assetContents");
            Intrinsics.checkNotNullParameter((Object)projectModelEntity, (String)"$parentEntity");
            Pair pair = (Pair)ApplicationKt.getApplication().runWriteAction(() -> Companion.j(virtualFile2, file2, object));
            VirtualFile virtualFile3 = (VirtualFile)pair.component1();
            VirtualFile virtualFile4 = (VirtualFile)pair.component2();
            objectRef.element = virtualFile3;
            AddExistingFileSession.Companion.run(project, (Function1<? super AddExistingFileSession, Unit>)((Function1)new Function1<AddExistingFileSession, Unit>(projectModelEntity, virtualFile4){
                final /* synthetic */ ProjectModelEntity $parentEntity;
                final /* synthetic */ VirtualFile $contentsFile;
                {
                    this.$parentEntity = $parentEntity;
                    this.$contentsFile = $contentsFile;
                    super(1);
                }

                public final void invoke(@NotNull AddExistingFileSession it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AddExistingFileSession.add$default(it, this.$parentEntity, this.$contentsFile, null, 4, null);
                }
            }));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

