/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.multiPlatform;

import com.intellij.openapi.project.Project;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.multiPlatform.RiderMultiPlatformBundle;
import com.jetbrains.rider.projectView.notifications.InstallPluginNotification;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/multiPlatform/AndroidPluginNotification;", "Lcom/jetbrains/rider/projectView/notifications/InstallPluginNotification;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "message", "", "getMessage", "()Ljava/lang/String;", "pluginId", "getPluginId", "pluginName", "getPluginName", "isPluginRequired", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nAndroidPluginNotification.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidPluginNotification.kt\ncom/jetbrains/rider/multiPlatform/AndroidPluginNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,25:1\n1747#2,3:26\n*S KotlinDebug\n*F\n+ 1 AndroidPluginNotification.kt\ncom/jetbrains/rider/multiPlatform/AndroidPluginNotification\n*L\n19#1:26,3\n*E\n"})
public final class AndroidPluginNotification
extends InstallPluginNotification {
    public AndroidPluginNotification(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @Override
    @NotNull
    public String getPluginName() {
        return "Android";
    }

    @Override
    @NotNull
    public String getPluginId() {
        return "com.jetbrains.rider.android";
    }

    @Override
    @NotNull
    public String getMessage() {
        return RiderMultiPlatformBundle.Companion.message("rider.androidPlugin.notification.message", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isPluginRequired() {
        boolean bl;
        Iterable iterable = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.getProject()));
        boolean bl2 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator2 = iterable.iterator();
        do {
            boolean bl3;
            if (!iterator2.hasNext()) return false;
            Object t = iterator2.next();
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)t;
            boolean bl4 = false;
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor = projectModelEntity.getDescriptor();
            if (!(rdProjectModelItemDescriptor instanceof RdProjectDescriptor)) return false;
            RdProjectDescriptor rdProjectDescriptor = (RdProjectDescriptor)rdProjectModelItemDescriptor;
            if (rdProjectDescriptor == null) {
                return false;
            }
            RdProjectDescriptor rdProjectDescriptor2 = rdProjectDescriptor;
            if (rdProjectDescriptor2.getSpecificType() == RdProjectType.Android) return true;
            String string = rdProjectDescriptor2.getUserData();
            if (string != null) {
                if (StringsKt.contains((CharSequence)string, (CharSequence)"RequiredAndroidPlugin=true", (boolean)true)) {
                    return true;
                }
                bl3 = false;
            } else {
                bl3 = false;
            }
            if (bl3) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }
}

