/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.microservices.endpointsProviders;

import com.intellij.microservices.endpoints.EndpointsViewListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rider.microservices.endpointsProviders.WebFrameworkChecker;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityVisitor;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "assembliesToCheck", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "referencesCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getReferencesCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setReferencesCounter", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "j", "", "hasFramework", "", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nWebFrameworkChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebFrameworkChecker.kt\ncom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n23#2:70\n*S KotlinDebug\n*F\n+ 1 WebFrameworkChecker.kt\ncom/jetbrains/rider/microservices/endpointsProviders/WebFrameworkChecker\n*L\n21#1:70\n*E\n"})
public abstract class WebFrameworkChecker
extends LifetimedService {
    @NotNull
    private final Project project;
    @NotNull
    private final Set<String> assembliesToCheck;
    @NotNull
    private final Logger logger;
    @NotNull
    private AtomicInteger referencesCounter;

    public WebFrameworkChecker(@NotNull Project project, @NotNull Set<String> assembliesToCheck) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(assembliesToCheck, (String)"assembliesToCheck");
        this.project = project;
        this.assembliesToCheck = assembliesToCheck;
        WebFrameworkChecker webFrameworkChecker = this;
        boolean bl = false;
        Logger logger2 = Logger.getInstance(WebFrameworkChecker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        this.referencesCounter = new AtomicInteger(0);
        webFrameworkChecker = WorkspaceModelEvents.Companion.getInstance(this.project);
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)webFrameworkChecker.getSynced()), (Lifetime)this.getServiceLifetime(), (Function1)((Function1)new Function1<Lifetime, Unit>((WorkspaceModelEvents)webFrameworkChecker){
            final /* synthetic */ WorkspaceModelEvents $events;
            {
                this.$events = $events;
                super(1);
            }

            public final void invoke(@NotNull Lifetime lt) {
                Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
                ProjectModelEntityVisitor projectModelEntityVisitor = new ProjectModelEntityVisitor(this){
                    final /* synthetic */ WebFrameworkChecker this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    @NotNull
                    protected ProjectModelEntityVisitor.Result visitReference(@NotNull ProjectModelEntity entity) {
                        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                        if (WebFrameworkChecker.access$getAssembliesToCheck$p(this.this$0).contains(entity.getName())) {
                            this.this$0.getReferencesCounter().incrementAndGet();
                        }
                        return ProjectModelEntityVisitor.Result.Stop;
                    }

                    @NotNull
                    protected ProjectModelEntityVisitor.Result visitUnknownNode(@NotNull ProjectModelEntity entity) {
                        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
                        return ProjectModelEntityVisitor.Result.Continue;
                    }
                };
                ApplicationKt.getApplication().executeOnPooledThread(() -> 1.j(projectModelEntityVisitor, this, this.$events));
            }

            private static final void j(visitor.1 var0, WebFrameworkChecker webFrameworkChecker, WorkspaceModelEvents workspaceModelEvents) {
                Intrinsics.checkNotNullParameter((Object)((Object)var0), (String)"$visitor");
                Intrinsics.checkNotNullParameter((Object)((Object)webFrameworkChecker), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)workspaceModelEvents, (String)"$events");
                var0.visit(webFrameworkChecker.project);
                webFrameworkChecker.j();
                webFrameworkChecker.getLogger().trace("Initialized for " + CollectionsKt.joinToString$default((Iterable)webFrameworkChecker.assembliesToCheck, null, null, null, (int)0, null, null, (int)63, null) + ", referencesCounter = " + webFrameworkChecker.getReferencesCounter().get());
                workspaceModelEvents.getAddSignal().advise(webFrameworkChecker.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.AddEntityEvent, Unit>(webFrameworkChecker){
                    final /* synthetic */ WebFrameworkChecker this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull WorkspaceModelEvents.AddEntityEvent add) {
                        Intrinsics.checkNotNullParameter((Object)add, (String)"add");
                        if (WebFrameworkChecker.access$getAssembliesToCheck$p(this.this$0).contains(add.getEntity().getName())) {
                            this.this$0.getReferencesCounter().incrementAndGet();
                            this.this$0.getLogger().trace("Added entity " + add.getEntity().getName() + ", referencesCounter = " + this.this$0.getReferencesCounter().get());
                            WebFrameworkChecker.access$dispatchChange(this.this$0);
                        }
                    }
                });
                workspaceModelEvents.getRemoveSignal().advise(webFrameworkChecker.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.RemoveEntityEvent, Unit>(webFrameworkChecker){
                    final /* synthetic */ WebFrameworkChecker this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull WorkspaceModelEvents.RemoveEntityEvent remove) {
                        Intrinsics.checkNotNullParameter((Object)remove, (String)"remove");
                        if (WebFrameworkChecker.access$getAssembliesToCheck$p(this.this$0).contains(remove.getEntity().getName())) {
                            this.this$0.getReferencesCounter().decrementAndGet();
                            this.this$0.getLogger().trace("Removed entity " + remove.getEntity().getName() + ", referencesCounter = " + this.this$0.getReferencesCounter().get());
                            WebFrameworkChecker.access$dispatchChange(this.this$0);
                        }
                    }
                });
            }
        }));
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    @NotNull
    public final AtomicInteger getReferencesCounter() {
        return this.referencesCounter;
    }

    public final void setReferencesCounter(@NotNull AtomicInteger atomicInteger) {
        Intrinsics.checkNotNullParameter((Object)atomicInteger, (String)"<set-?>");
        this.referencesCounter = atomicInteger;
    }

    public final boolean hasFramework() {
        return this.referencesCounter.get() > 0;
    }

    private final void j() {
        ((EndpointsViewListener)this.project.getMessageBus().syncPublisher(EndpointsViewListener.Companion.getTOPIC())).endpointsChanged(new EndpointsViewListener.ChangeEvent(this.project, EndpointsViewListener.ChangeType.PROVIDERS));
    }
}

