/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.internal;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.jetbrains.rider.debugger.DebuggerHelperHost;
import com.jetbrains.rider.internal.CrossgenOptions;
import com.jetbrains.rider.internal.RunCrossgenActionKt;
import com.jetbrains.rider.internal.RunCrossgenTask;
import com.jetbrains.rider.model.InstructionSet;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/internal/RunCrossgenActionWithOptions;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
public final class RunCrossgenActionWithOptions
extends AnAction
implements DumbAware {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Object object = project;
        Intrinsics.checkNotNull((Object)object);
        Project project2 = object;
        object = new CrossgenDialog(project2);
        if (!object.showAndGet()) {
            return;
        }
        CrossgenOptions crossgenOptions = ((CrossgenDialog)((Object)object)).getOptions();
        if (crossgenOptions.getUseComposite()) {
            ProgressManager.getInstance().run((Task)new RunCrossgenTask(project2, crossgenOptions));
            return;
        }
        EnumSet<Object> enumSet = crossgenOptions.getInstructionSet();
        if (enumSet == null) {
            enumSet = EnumSet.of((Enum)InstructionSet.sse2);
        }
        EnumSet<InstructionSet> enumSet2 = enumSet;
        Intrinsics.checkNotNull(enumSet2);
        RunCrossgenActionKt.access$runCrossgenOnBackend(project2, enumSet2, crossgenOptions.getAllowParallel(), crossgenOptions.getNiOnly());
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Project project = e.getProject();
        if (project == null) {
            project = ProjectManager.getInstance().getDefaultProject();
        }
        Project project2 = project;
        Intrinsics.checkNotNull((Object)project2);
        presentation2.setEnabled(DebuggerHelperHost.Companion.getInstance(project2).isReady());
    }
}

