/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.interactive.repl.hosting;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.BasicGutterContentProvider;
import com.intellij.execution.console.GutterContentProvider;
import com.intellij.execution.console.LanguageConsoleBuilder;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.console.ProcessBackedConsoleExecuteActionHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.AbstractConsoleRunnerWithHistory;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.util.ExecUtil;
import com.intellij.icons.AllIcons;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.project.ProjectKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.interactive.RiderInteractiveBundle;
import com.jetbrains.rider.interactive.repl.history.CommandHistory;
import com.jetbrains.rider.interactive.repl.history.HistoryKeyListener;
import com.jetbrains.rider.interactive.repl.history.actions.CommandHistoryAction;
import com.jetbrains.rider.interactive.repl.history.actions.ExportTranscriptAction;
import com.jetbrains.rider.interactive.repl.hosting.AbstractReplHost;
import com.jetbrains.rider.interactive.repl.util.EditorUtilities;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001PB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\n\u00100\u001a\u0004\u0018\u00010\u0012H&J\b\u00101\u001a\u00020\u0002H\u0014J\u0010\u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u0006H&J \u00102\u001a\u00020\u00062\u0006\u00103\u001a\u00020\u00062\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H&J\b\u00108\u001a\u000209H\u0014J\n\u0010:\u001a\u0004\u0018\u00010;H\u0014J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020;H\u0014J\u0010\u0010?\u001a\u00020;2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J&\u0010@\u001a\b\u0012\u0004\u0012\u00020B0A2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020F2\u0006\u0010\u0019\u001a\u00020\u0018H\u0014J\b\u0010G\u001a\u00020\bH\u0014J\b\u0010H\u001a\u00020IH\u0016J\u0006\u0010J\u001a\u00020IJ\u0016\u0010K\u001a\u00020L2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u0018\u0010M\u001a\u00020L2\u0006\u00103\u001a\u00020\u00062\u0006\u0010N\u001a\u00020\u0006H\u0016J\b\u0010O\u001a\u00020IH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00188D@DX\u0084\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0013\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010)\u001a\u0004\u0018\u00010*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010!R\u0016\u0010.\u001a\u0004\u0018\u00010*X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010,\u00a8\u0006Q"}, d2={"Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplConsoleRunner;", "Lcom/intellij/execution/runners/AbstractConsoleRunnerWithHistory;", "Lcom/intellij/execution/console/LanguageConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "icon", "Ljavax/swing/Icon;", "language", "Lcom/intellij/lang/Language;", "fileExtension", "replHost", "Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljavax/swing/Icon;Lcom/intellij/lang/Language;Ljava/lang/String;Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;)V", "commandHistory", "Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "getCommandLine", "()Lcom/intellij/execution/configurations/GeneralCommandLine;", "setCommandLine", "(Lcom/intellij/execution/configurations/GeneralCommandLine;)V", "<set-?>", "Lcom/intellij/execution/ui/RunContentDescriptor;", "contentDescriptor", "getContentDescriptor", "()Lcom/intellij/execution/ui/RunContentDescriptor;", "setContentDescriptor", "(Lcom/intellij/execution/ui/RunContentDescriptor;)V", "contentDescriptor$delegate", "Lkotlin/properties/ReadWriteProperty;", "getFileExtension", "()Ljava/lang/String;", "getIcon", "()Ljavax/swing/Icon;", "getLanguage", "()Lcom/intellij/lang/Language;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "projectDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getProjectDir", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTitle", "workingDir", "getWorkingDir", "createCommandLine", "createConsoleView", "createExecutableTextFrom", "visibleText", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "createExecuteActionHandler", "Lcom/intellij/execution/console/ProcessBackedConsoleExecuteActionHandler;", "createProcess", "Ljava/lang/Process;", "createProcessHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "process", "j", "fillToolBarActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "toolbarActions", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "defaultExecutor", "Lcom/intellij/execution/Executor;", "getConsoleIcon", "isAutoFocusContent", "", "isValid", "sendFile", "", "sendText", "executableText", "shouldForceUtf8ConsoleOnWindows", "ResetInteractiveAction", "intellij.rider"})
public abstract class AbstractReplConsoleRunner
extends AbstractConsoleRunnerWithHistory<LanguageConsoleView> {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final String title;
    @NotNull
    private final Icon icon;
    @NotNull
    private final Language language;
    @NotNull
    private final String fileExtension;
    @NotNull
    private final AbstractReplHost replHost;
    @NotNull
    private final Logger logger;
    @Nullable
    private final VirtualFile projectDir;
    @Nullable
    private final VirtualFile workingDir;
    @NotNull
    private final ReadWriteProperty contentDescriptor$delegate;
    @NotNull
    private final CommandHistory commandHistory;
    @Nullable
    private GeneralCommandLine commandLine;

    public AbstractReplConsoleRunner(@NotNull Project project, @Nls(capitalization=Nls.Capitalization.Title) @NotNull String title2, @NotNull Icon icon2, @NotNull Language language, @NotNull String fileExtension, @NotNull AbstractReplHost replHost) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)fileExtension, (String)"fileExtension");
        Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
        super(project, title2, null);
        this.title = title2;
        this.icon = icon2;
        this.language = language;
        this.fileExtension = fileExtension;
        this.replHost = replHost;
        Logger logger2 = Logger.getInstance(AbstractReplConsoleRunner.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        this.logger = logger2;
        VirtualFile virtualFile2 = this.projectDir = ProjectKt.isDirectoryBased((Project)this.replHost.getProject()) ? ProjectUtil.guessProjectDir((Project)this.replHost.getProject()) : null;
        this.workingDir = (virtualFile2 != null ? virtualFile2.exists() : false) ? this.projectDir : VfsUtil.getUserHomeDir();
        this.contentDescriptor$delegate = Delegates.INSTANCE.notNull();
        this.commandHistory = new CommandHistory();
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final Icon getIcon() {
        return this.icon;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final String getFileExtension() {
        return this.fileExtension;
    }

    @Nullable
    protected final VirtualFile getProjectDir() {
        return this.projectDir;
    }

    @Nullable
    protected final VirtualFile getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    protected final RunContentDescriptor getContentDescriptor() {
        return (RunContentDescriptor)this.contentDescriptor$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    protected final void setContentDescriptor(@NotNull RunContentDescriptor runContentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)runContentDescriptor, (String)"<set-?>");
        this.contentDescriptor$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)runContentDescriptor);
    }

    @Nullable
    public final GeneralCommandLine getCommandLine() {
        return this.commandLine;
    }

    public final void setCommandLine(@Nullable GeneralCommandLine generalCommandLine) {
        this.commandLine = generalCommandLine;
    }

    public final boolean isValid() {
        ProcessHandler processHandler2 = this.getProcessHandler();
        return !(processHandler2 != null ? processHandler2.isProcessTerminated() : true);
    }

    public boolean isAutoFocusContent() {
        return false;
    }

    @NotNull
    protected Icon getConsoleIcon() {
        return this.icon;
    }

    public final void sendFile(@NotNull Editor editor2, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = editor2.getSelectionModel().hasSelection();
        String string = EditorUtilities.Companion.getTextToSend(editor2, bl);
        if (((CharSequence)string).length() > 0) {
            String string2 = this.createExecutableTextFrom(string, editor2, file2);
            this.sendText(string, string2);
        }
        if (!bl && this.replHost.getMoveCaretOnSendLine()) {
            editor2.getCaretModel().moveCaretRelatively(0, 1, false, false, true);
        }
    }

    @Nullable
    public abstract GeneralCommandLine createCommandLine();

    public boolean shouldForceUtf8ConsoleOnWindows() {
        return false;
    }

    @NotNull
    public abstract String createExecutableTextFrom(@NotNull String var1, @NotNull Editor var2, @NotNull PsiFile var3);

    @NotNull
    public abstract String createExecutableTextFrom(@NotNull String var1);

    public void sendText(@NotNull String visibleText, @NotNull String executableText) {
        Intrinsics.checkNotNullParameter((Object)visibleText, (String)"visibleText");
        Intrinsics.checkNotNullParameter((Object)executableText, (String)"executableText");
        this.getConsoleView().print(visibleText, ConsoleViewContentType.USER_INPUT);
        this.getConsoleView().print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
        EditorUtil.scrollToTheEnd((Editor)((Editor)this.getConsoleView().getHistoryViewer()));
        this.commandHistory.addEntry(new CommandHistory.Entry(visibleText, executableText));
        RunContentManager.getInstance((Project)this.getProject()).selectRunContent(this.getContentDescriptor());
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(this.getExecutor().getId());
        if (toolWindow != null) {
            toolWindow.show(null);
        }
        OutputStream outputStream = this.getProcessHandler().getProcessInput();
        if (outputStream == null) {
            throw new IllegalStateException("Broken interactive stream".toString());
        }
        OutputStream outputStream2 = outputStream;
        try {
            byte[] byArray = executableText.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            outputStream2.write(byArray);
            outputStream2.flush();
        }
        catch (IOException iOException) {
            this.logger.warn("Interactive stream is closed.", (Throwable)iOException);
        }
    }

    @NotNull
    protected ProcessBackedConsoleExecuteActionHandler createExecuteActionHandler() {
        ProcessHandler processHandler2 = this.getProcessHandler();
        return new ProcessBackedConsoleExecuteActionHandler(this, processHandler2){
            final /* synthetic */ AbstractReplConsoleRunner this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, false);
            }

            public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
                Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
                String string = consoleView.getConsoleEditor().getDocument().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                String string2 = string;
                String string3 = this.this$0.createExecutableTextFrom(string2);
                this.this$0.sendText(string2, string3);
                consoleView.setInputText("");
            }
        };
    }

    @Nullable
    protected Process createProcess() {
        this.commandLine = this.createCommandLine();
        GeneralCommandLine generalCommandLine = this.commandLine;
        if (generalCommandLine == null || !new File(generalCommandLine.getExePath()).exists()) {
            return null;
        }
        return SystemInfo.isWindows && this.shouldForceUtf8ConsoleOnWindows() ? this.j(generalCommandLine) : generalCommandLine.createProcess();
    }

    @NotNull
    protected List<AnAction> fillToolBarActions(@NotNull DefaultActionGroup toolbarActions, @NotNull Executor defaultExecutor, @NotNull RunContentDescriptor contentDescriptor) {
        Intrinsics.checkNotNullParameter((Object)toolbarActions, (String)"toolbarActions");
        Intrinsics.checkNotNullParameter((Object)defaultExecutor, (String)"defaultExecutor");
        Intrinsics.checkNotNullParameter((Object)contentDescriptor, (String)"contentDescriptor");
        this.setContentDescriptor(contentDescriptor);
        Object[] objectArray = new AnAction[]{this.createCloseAction(defaultExecutor, contentDescriptor), new ResetInteractiveAction(this.replHost), new CommandHistoryAction(this.commandHistory, this.replHost), new ExportTranscriptAction(this.commandHistory, "// Transcript from interactive session", this.language, this.fileExtension)};
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList(...)");
        ArrayList arrayList2 = arrayList;
        toolbarActions.addAll((Collection)arrayList2);
        arrayList2.add(this.createConsoleExecAction(this.getConsoleExecuteActionHandler()));
        return arrayList2;
    }

    @NotNull
    protected LanguageConsoleView createConsoleView() {
        BasicGutterContentProvider basicGutterContentProvider = new BasicGutterContentProvider(){

            public void beforeEvaluate(@NotNull Editor e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        };
        LanguageConsoleView languageConsoleView = new LanguageConsoleBuilder().gutterContentProvider((GutterContentProvider)basicGutterContentProvider).build(this.getProject(), this.language);
        Intrinsics.checkNotNullExpressionValue((Object)languageConsoleView, (String)"build(...)");
        LanguageConsoleView languageConsoleView2 = languageConsoleView;
        Project project = this.replHost.getProject();
        EditorEx editorEx = languageConsoleView2.getConsoleEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"getConsoleEditor(...)");
        HistoryKeyListener historyKeyListener = new HistoryKeyListener(project, editorEx, this.commandHistory, false, 8, null);
        languageConsoleView2.getConsoleEditor().getContentComponent().addKeyListener(historyKeyListener);
        this.commandHistory.getListeners().add(historyKeyListener);
        return languageConsoleView2;
    }

    @NotNull
    protected OSProcessHandler createProcessHandler(@NotNull Process process2) {
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        GeneralCommandLine generalCommandLine = this.commandLine;
        Intrinsics.checkNotNull((Object)generalCommandLine);
        String string = generalCommandLine.getCommandLineString();
        Charset charset = Charsets.UTF_8;
        return new OSProcessHandler(process2, string, charset){

            public boolean isSilentlyDestroyOnClose() {
                return true;
            }
        };
    }

    private final Process j(GeneralCommandLine generalCommandLine) {
        if (!SystemInfo.isWindows) {
            Process process2 = generalCommandLine.createProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process2, (String)"createProcess(...)");
            return process2;
        }
        ProcessBuilder processBuilder = generalCommandLine.toProcessBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)processBuilder, (String)"toProcessBuilder(...)");
        ProcessBuilder processBuilder2 = processBuilder;
        Object object = new String[5];
        object[0] = "chcp";
        object[1] = "65001";
        object[2] = ">nul";
        object[3] = "&&";
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine.getExePath(), (String)"getExePath(...)");
        Collection collection = CollectionsKt.listOf((Object[])object);
        List list2 = generalCommandLine.getParametersList().getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        List list3 = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        Object object2 = object = processBuilder2.command();
        boolean bl = false;
        object2.clear();
        object2.add(ExecUtil.getWindowsShellName());
        object2.add("/c");
        object2.add(ParametersListUtil.join((List)list3));
        Process process3 = processBuilder2.start();
        Intrinsics.checkNotNullExpressionValue((Object)process3, (String)"start(...)");
        return process3;
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(AbstractReplConsoleRunner.class, "contentDescriptor", "getContentDescriptor()Lcom/intellij/execution/ui/RunContentDescriptor;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplConsoleRunner$ResetInteractiveAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "replHost", "Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;", "(Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.rider"})
    private static final class ResetInteractiveAction
    extends AnAction {
        @NotNull
        private final AbstractReplHost replHost;

        public ResetInteractiveAction(@NotNull AbstractReplHost replHost) {
            Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
            super(RiderInteractiveBundle.Companion.message("action.reset.text", new Object[0]), null, AllIcons.Actions.Restart);
            this.replHost = replHost;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.replHost.resetConsole$intellij_rider();
        }
    }
}

