/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.interactive.repl.history.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.jetbrains.rider.actions.RiderActionsBundle;
import com.jetbrains.rider.interactive.RiderInteractiveBundle;
import com.jetbrains.rider.interactive.repl.history.CommandHistory;
import com.jetbrains.rider.interactive.repl.hosting.AbstractReplHost;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/interactive/repl/history/actions/CommandHistoryAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "commandHistory", "Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;", "replHost", "Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;", "(Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;)V", "getCommandHistory", "()Lcom/jetbrains/rider/interactive/repl/history/CommandHistory;", "getReplHost", "()Lcom/jetbrains/rider/interactive/repl/hosting/AbstractReplHost;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.rider"})
public final class CommandHistoryAction
extends DumbAwareAction {
    @NotNull
    private final CommandHistory commandHistory;
    @NotNull
    private final AbstractReplHost replHost;

    public CommandHistoryAction(@NotNull CommandHistory commandHistory, @NotNull AbstractReplHost replHost) {
        Intrinsics.checkNotNullParameter((Object)commandHistory, (String)"commandHistory");
        Intrinsics.checkNotNullParameter((Object)replHost, (String)"replHost");
        super(RiderActionsBundle.Companion.message("CommandHistoryAction.action.replay.recent.commands.text", new Object[0]), RiderActionsBundle.Companion.message("CommandHistoryAction.action.show.replay.recently.executed.commands.description", new Object[0]), AllIcons.Vcs.History);
        this.commandHistory = commandHistory;
        this.replHost = replHost;
    }

    @NotNull
    public final CommandHistory getCommandHistory() {
        return this.commandHistory;
    }

    @NotNull
    public final AbstractReplHost getReplHost() {
        return this.replHost;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Component component2;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String string = RiderInteractiveBundle.Companion.message("CommandHistoryAction.popup.title.recent.commands.recent.first", new Object[0]);
        Object object = CollectionsKt.asReversed(this.commandHistory.entries());
        BaseListPopupStep<CommandHistory.Entry> baseListPopupStep = new BaseListPopupStep<CommandHistory.Entry>(this, string, (List<CommandHistory.Entry>)object){
            final /* synthetic */ CommandHistoryAction this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            @Nullable
            public PopupStep<?> onChosen(@NotNull CommandHistory.Entry selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                this.this$0.getReplHost().sendToConsole$intellij_rider(selectedValue.getVisibleText(), selectedValue.getExecutableText());
                return PopupStep.FINAL_CHOICE;
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)baseListPopupStep);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        string = listPopup;
        Object object2 = object = e.getInputEvent();
        Component component3 = component2 = object2 != null ? ((ComponentEvent)object2).getComponent() : null;
        if (component2 != null) {
            string.showUnderneathOf(component2);
        } else {
            string.showInBestPositionFor(e.getDataContext());
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabled(!((Collection)this.commandHistory.entries()).isEmpty());
    }
}

