/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.find.scopes;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import com.intellij.psi.search.ProjectAwareVirtualFile;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fR\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker;", "", "project", "Lcom/intellij/openapi/project/Project;", "withExternalItems", "", "(Lcom/intellij/openapi/project/Project;Z)V", "configPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "ignoredPaths", "", "installationPath", "scratchesPath", "solutionDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "contains", "file", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nRiderScopeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderScopeUtils.kt\ncom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1#2:105\n1747#3,3:106\n*S KotlinDebug\n*F\n+ 1 RiderScopeUtils.kt\ncom/jetbrains/rider/ideaInterop/find/scopes/SolutionFilesChecker\n*L\n83#1:106,3\n*E\n"})
public final class SolutionFilesChecker {
    @NotNull
    private final Project project;
    private final boolean withExternalItems;
    private final Path installationPath;
    private final Path configPath;
    @NotNull
    private final List<Path> ignoredPaths;
    private final Path scratchesPath;
    @Nullable
    private final VirtualFile solutionDirectory;

    public SolutionFilesChecker(@NotNull Project project, boolean withExternalItems) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.withExternalItems = withExternalItems;
        this.installationPath = Paths.get(PathManager.getHomePath(), new String[0]);
        this.configPath = Paths.get(PathManager.getScratchPath(), new String[0]);
        SolutionFilesChecker solutionFilesChecker = this;
        if (PluginManagerCore.isRunningFromSources()) {
            Path path;
            Path path2 = Paths.get(PathManager.getCommunityHomePath(), new String[0]).getParent().normalize();
            String string = PathManager.getArchivedCompliedClassesLocation();
            if (string != null) {
                String string2 = string;
                SolutionFilesChecker solutionFilesChecker2 = solutionFilesChecker;
                boolean bl = false;
                path = Paths.get(string2, new String[0]).normalize();
                solutionFilesChecker = solutionFilesChecker2;
            } else {
                path = null;
            }
            Path path3 = path;
            Object[] objectArray = new Path[]{this.installationPath, this.configPath, path2, path3};
            list2 = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            Object[] objectArray = new Path[]{this.installationPath, this.configPath};
            list2 = CollectionsKt.listOf((Object[])objectArray);
        }
        solutionFilesChecker.ignoredPaths = list2;
        this.scratchesPath = this.configPath.resolve("scratches");
        this.solutionDirectory = DocumentUtilKt.toVirtualFile((File)SolutionHostExtensionsKt.getSolutionDirectory((Project)this.project), (boolean)true);
    }

    public final boolean contains(@NotNull VirtualFile file2) {
        VirtualFile virtualFile2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (file2 instanceof ProjectAwareVirtualFile) {
            return ((ProjectAwareVirtualFile)file2).isInProject(this.project);
        }
        VirtualFileSystem virtualFileSystem = file2.getFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileSystem, (String)"getFileSystem(...)");
        VirtualFileSystem virtualFileSystem2 = virtualFileSystem;
        VirtualFile virtualFile3 = virtualFile2 = virtualFileSystem2 instanceof ArchiveFileSystem ? ((ArchiveFileSystem)virtualFileSystem2).getLocalByEntry(file2) : file2;
        if (virtualFile2 != null && virtualFile2.isInLocalFileSystem()) {
            boolean bl;
            block8: {
                Path path = virtualFile2.toNioPath();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
                Path path2 = path;
                if (path2.startsWith(this.scratchesPath)) {
                    return this.withExternalItems;
                }
                Iterable iterable = this.ignoredPaths;
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t : iterable) {
                        Path path3 = (Path)t;
                        boolean bl3 = false;
                        if (!path2.startsWith(path3)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
        }
        if (this.solutionDirectory != null && this.withExternalItems && VfsUtil.isAncestor((VirtualFile)this.solutionDirectory, (VirtualFile)file2, (boolean)true)) {
            return true;
        }
        return WorkspaceModelExtensionsKt.shouldBeIndexedWithoutLibraries((Project)this.project, (VirtualFile)file2);
    }
}

