/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.find;

import com.intellij.find.FindModel;
import com.intellij.find.FindModelExtension;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.IndexableFilesIndex;
import com.jetbrains.rider.ideaInterop.find.scopes.RiderExternalScope;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/ideaInterop/find/RiderFindModelExtension;", "Lcom/intellij/find/FindModelExtension;", "()V", "iterateAdditionalFiles", "", "findModel", "Lcom/intellij/find/FindModel;", "project", "Lcom/intellij/openapi/project/Project;", "consumer", "Lcom/intellij/util/Processor;", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider"})
public final class RiderFindModelExtension
implements FindModelExtension {
    public boolean iterateAdditionalFiles(@NotNull FindModel findModel, @NotNull Project project, @NotNull Processor<? super VirtualFile> consumer) {
        Intrinsics.checkNotNullParameter((Object)findModel, (String)"findModel");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        SearchScope searchScope2 = findModel.getCustomScope();
        Condition condition = FindInProjectUtil.createFileMaskCondition((String)findModel.getFileFilter());
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"createFileMaskCondition(...)");
        Condition condition2 = condition;
        if (searchScope2 instanceof RiderExternalScope) {
            VirtualFile virtualFile2 = ((RiderExternalScope)searchScope2).getRootDirectory();
            if (virtualFile2 == null) {
                return false;
            }
            VirtualFile virtualFile3 = virtualFile2;
            VfsIterator vfsIterator = VfsIterator.Companion.create(project);
            if (vfsIterator != null) {
                vfsIterator.visitChildrenRecursively(virtualFile3, arg_0 -> RiderFindModelExtension.j(condition2, project, consumer, arg_0));
            }
            return true;
        }
        return false;
    }

    private static final boolean j(Condition condition, Project project, Processor processor2, VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)condition, (String)"$patternCondition");
        Intrinsics.checkNotNullParameter((Object)project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)processor2, (String)"$consumer");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"file");
        if (!condition.value((Object)virtualFile2.getName())) {
            return true;
        }
        if (IndexableFilesIndex.getInstance((Project)project).shouldBeIndexed(virtualFile2)) {
            return false;
        }
        return processor2.process((Object)virtualFile2);
    }
}

