/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.ideaInterop.fileTypes.csharp.highlighting.kotoparser;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rider.colors.RiderLanguageTextAttributeKeys;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpTextAttributeKeys;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.CSharpCompositeElementType;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpElementTypes;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u00012\u00020\u0002:\u0001\u001aB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000f\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0017H\u0082\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/rider/ideaInterop/fileTypes/csharp/highlighting/kotoparser/CSharpHeuristicHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiFile;)V", "highlightings", "", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "typeTypes", "", "Lcom/jetbrains/rider/languages/fileTypes/csharp/kotoparser/CSharpCompositeElementType;", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "j", "node", "Lcom/intellij/lang/ASTNode;", "j", "Lcom/intellij/psi/tree/IElementType;", "Companion", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nCSharpHeuristicHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CSharpHeuristicHighlightingPass.kt\ncom/jetbrains/rider/ideaInterop/fileTypes/csharp/highlighting/kotoparser/CSharpHeuristicHighlightingPass\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,129:1\n1855#2,2:130\n*S KotlinDebug\n*F\n+ 1 CSharpHeuristicHighlightingPass.kt\ncom/jetbrains/rider/ideaInterop/fileTypes/csharp/highlighting/kotoparser/CSharpHeuristicHighlightingPass\n*L\n36#1:130,2\n*E\n"})
public final class CSharpHeuristicHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final List<HighlightInfo> highlightings;
    @NotNull
    private final List<CSharpCompositeElementType> typeTypes;
    @NotNull
    private static final HighlightSeverity severity = new HighlightSeverity("CSHARP_LIGHT_SYNTAX", 300);
    @NotNull
    private static final HighlightInfoType.HighlightInfoTypeImpl highlightInfoType = new HighlightInfoType.HighlightInfoTypeImpl(severity, RiderLanguageTextAttributeKeys.INSTANCE.getIDENTIFIER());

    public CSharpHeuristicHighlightingPass(@NotNull Document document2, @NotNull Project project, @NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        super(file2.getProject(), document2);
        this.project = project;
        this.file = file2;
        this.highlightings = new ArrayList();
        Object[] objectArray = new CSharpCompositeElementType[]{CSharpElementTypes.INSTANCE.getDUMMY_TYPE_DECLARATION(), CSharpElementTypes.INSTANCE.getCLASS_DECLARATION(), CSharpElementTypes.INSTANCE.getATTRIBUTE_DECLARATION(), CSharpElementTypes.INSTANCE.getCLASSRECORD_DECLARATION(), CSharpElementTypes.INSTANCE.getDELEGATE_DECLARATION(), CSharpElementTypes.INSTANCE.getSTRUCT_DECLARATION(), CSharpElementTypes.INSTANCE.getSTRUCT_RECORD_DECLARATION(), CSharpElementTypes.INSTANCE.getENUM_DECLARATION(), CSharpElementTypes.INSTANCE.getINTERFACE_DECLARATION()};
        this.typeTypes = CollectionsKt.listOf((Object[])objectArray);
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
        if (SolutionHostExtensionsKt.getSolution((Project)this.project).getSolutionLifecycle().getFullStartupFinished().getValueOrNull() != null) {
            return;
        }
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.astTraverser((ASTNode)((ASTNode)this.file.getNode()));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"astTraverser(...)");
        SyntaxTraverser syntaxTraverser2 = syntaxTraverser;
        Iterable iterable = (Iterable)syntaxTraverser2;
        boolean bl = false;
        for (Object t : iterable) {
            ASTNode aSTNode = (ASTNode)t;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)aSTNode);
            HighlightInfo highlightInfo = this.j(aSTNode);
            if (highlightInfo == null) continue;
            this.highlightings.add(highlightInfo);
        }
    }

    public void doApplyInformationToEditor() {
        UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.getDocument(), (int)0, (int)this.getDocument().getTextLength(), (Collection)this.highlightings, null, (int)this.getId());
    }

    private final HighlightInfo j(ASTNode aSTNode) {
        TextAttributesKey textAttributesKey;
        IElementType iElementType = aSTNode.getElementType();
        if (CSharpTokenType.KEYWORDS.contains(iElementType) ? true : CSharpTokenType.CONTEXTUAL_KEYWORDS.contains(iElementType)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getKEYWORD();
        } else if (CSharpTokenType.STRINGS.contains(iElementType)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getSTRING();
        } else if (CSharpTokenType.PREPROCESSOR.contains(iElementType)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getPREPROCESSOR_KEYWORD();
        } else if (CSharpTokenType.COMMENTS.contains(iElementType)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getCOMMENT();
        } else if (CSharpTokenType.OPERATORS.contains(iElementType)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getOPERATOR_SIGN();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.FLOAT_LITERAL) ? true : Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.INTEGER_LITERAL)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getNUMBER();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.CHARACTER_LITERAL)) {
            textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getSTRING();
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)CSharpTokenType.IDENTIFIER)) {
            IElementType iElementType2;
            ASTNode aSTNode2;
            ASTNode aSTNode3 = aSTNode2 = aSTNode.getTreeParent();
            Object object = iElementType2 = aSTNode3 != null ? aSTNode3.getElementType() : null;
            if (Intrinsics.areEqual((Object)iElementType2, (Object)CSharpElementTypes.INSTANCE.getMETH_CALL_ROLE())) {
                textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getMETHOD();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)CSharpElementTypes.INSTANCE.getFIELD_USAGE_ROLE())) {
                textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getFIELD();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)CSharpElementTypes.INSTANCE.getTYPE_USAGE_ROLE())) {
                textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getCLASS();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)CSharpElementTypes.INSTANCE.getCONTEXTUAL_KEYWORD_WRAPPER())) {
                textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getKEYWORD();
            } else if (Intrinsics.areEqual((Object)iElementType2, (Object)CSharpElementTypes.INSTANCE.getDECLARATION_IDENTIFIER())) {
                ASTNode aSTNode4;
                ASTNode aSTNode5 = aSTNode4 = aSTNode2.getTreeParent();
                Object object2 = aSTNode5 != null ? aSTNode5.getElementType() : null;
                if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getTYPE_USAGE_ROLE()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getEXTERN_ALIAS_DIRECTIVE())) {
                    textAttributesKey = null;
                } else if (((((Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getUSING_SYMBOL_DIRECTIVE()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getDUMMY_TYPE_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getCLASS_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getATTRIBUTE_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getCLASSRECORD_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getDELEGATE_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getCLASS();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getSTRUCT_DECLARATION()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getSTRUCT_RECORD_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getSTRUCT();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getENUM_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getENUM();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getINTERFACE_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getINTERFACE();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getNAMESPACE_FILE_SCOPE_HEADER()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getNAMESPACE_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getNAMESPACE();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getMETHOD_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getMETHOD();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getPROPERTY_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getPROPERTY();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getPARAMETER_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getPARAMETER();
                } else if (((Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getENUM_MEMBER_DECLARATION()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getEVENT_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getCONST_DECLARATION())) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getFIELD_DECLARATION())) {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getFIELD();
                } else if (Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getPARENT_LIST()) ? true : Intrinsics.areEqual((Object)object2, (Object)CSharpElementTypes.INSTANCE.getCTOR_DECLARATION())) {
                    Intrinsics.checkNotNull((Object)aSTNode4);
                    IElementType iElementType3 = this.j(aSTNode4);
                    textAttributesKey = (Intrinsics.areEqual((Object)iElementType3, (Object)CSharpElementTypes.INSTANCE.getSTRUCT_DECLARATION()) ? true : Intrinsics.areEqual((Object)iElementType3, (Object)CSharpElementTypes.INSTANCE.getSTRUCT_RECORD_DECLARATION())) ? CSharpTextAttributeKeys.INSTANCE.getSTRUCT() : CSharpTextAttributeKeys.INSTANCE.getCLASS();
                } else {
                    textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getIDENTIFIER();
                }
            } else {
                textAttributesKey = CSharpTextAttributeKeys.INSTANCE.getIDENTIFIER();
            }
        } else {
            textAttributesKey = null;
        }
        if (textAttributesKey == null) {
            return null;
        }
        TextAttributesKey textAttributesKey2 = textAttributesKey;
        return HighlightInfo.newHighlightInfo((HighlightInfoType)((HighlightInfoType)highlightInfoType)).severity(severity).range(aSTNode.getPsi()).textAttributes(textAttributesKey2).create();
    }

    private final IElementType j(ASTNode aSTNode) {
        IElementType iElementType;
        while (true) {
            ASTNode aSTNode2;
            if (aSTNode.getTreeParent() == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)aSTNode2.getElementType(), (String)"getElementType(...)");
            if (CollectionsKt.contains((Iterable)this.typeTypes, (Object)iElementType)) break;
            aSTNode = aSTNode2;
        }
        return iElementType;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/ideaInterop/fileTypes/csharp/highlighting/kotoparser/CSharpHeuristicHighlightingPass$Companion;", "", "()V", "highlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType$HighlightInfoTypeImpl;", "severity", "Lcom/intellij/lang/annotation/HighlightSeverity;", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

