/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.hotReload;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.ui.bedsl.extensions.BeCommonExtensionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rider.debugger.settings.DotNetDebuggerSettings;
import com.jetbrains.rider.model.HotReloadModel;
import com.jetbrains.rider.model.HotReloadModel_PregeneratedKt;
import com.jetbrains.rider.model.HotReloadSupportedInfo;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0086@\u00a2\u0006\u0002\u0010\u0013J\u0006\u0010\u0014\u001a\u00020\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0018R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/hotReload/HotReloadHost;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "blazorWasmHotReloadEnabled", "Lcom/jetbrains/rd/util/reactive/OptProperty;", "", "getBlazorWasmHotReloadEnabled", "()Lcom/jetbrains/rd/util/reactive/OptProperty;", "debugHotReloadEnabled", "getDebugHotReloadEnabled", "runtimeHotReloadEnabled", "getRuntimeHotReloadEnabled", "checkProjectConfigRuntimeHotReload", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "info", "Lcom/jetbrains/rider/model/HotReloadSupportedInfo;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/HotReloadSupportedInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "hotReloadWhenDebugAllowed", "notifyWarning", "", "title", "", "message", "Companion", "ProtocolListener", "intellij.rider"})
public final class HotReloadHost {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final OptProperty<Boolean> debugHotReloadEnabled;
    @NotNull
    private final OptProperty<Boolean> runtimeHotReloadEnabled;
    @NotNull
    private final OptProperty<Boolean> blazorWasmHotReloadEnabled;

    public HotReloadHost(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.debugHotReloadEnabled = new OptProperty();
        this.runtimeHotReloadEnabled = new OptProperty();
        this.blazorWasmHotReloadEnabled = new OptProperty();
    }

    @NotNull
    public final OptProperty<Boolean> getDebugHotReloadEnabled() {
        return this.debugHotReloadEnabled;
    }

    @NotNull
    public final OptProperty<Boolean> getRuntimeHotReloadEnabled() {
        return this.runtimeHotReloadEnabled;
    }

    @NotNull
    public final OptProperty<Boolean> getBlazorWasmHotReloadEnabled() {
        return this.blazorWasmHotReloadEnabled;
    }

    public final boolean hotReloadWhenDebugAllowed() {
        return BoolPropertyExKt.getHasTrueValue((IOptPropertyView)((IOptPropertyView)this.debugHotReloadEnabled)) && DotNetDebuggerSettings.Companion.getInstance().getAllowTypingDuringDebug();
    }

    public final void notifyWarning(@NlsContexts.NotificationContent @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message2) {
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
        Notification notification2 = new Notification("Hot Reload", title2, message2, NotificationType.WARNING);
        notification2.notify(this.project);
    }

    @Nullable
    public final Object checkProjectConfigRuntimeHotReload(@NotNull Lifetime lifetime2, @NotNull HotReloadSupportedInfo info, @NotNull Continuation<? super Boolean> $completion) {
        return IRdCall.DefaultImpls.startSuspending$default((IRdCall)((IRdCall)HotReloadModel_PregeneratedKt.getHotReloadModel((Solution)SolutionHostExtensionsKt.getSolution((Project)this.project)).getCheckProjectConfigRuntimeHotReload()), (Lifetime)lifetime2, (Object)info, null, $completion, (int)4, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/hotReload/HotReloadHost$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/hotReload/HotReloadHost;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nHotReloadHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HotReloadHost.kt\ncom/jetbrains/rider/hotReload/HotReloadHost$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,57:1\n31#2,2:58\n*S KotlinDebug\n*F\n+ 1 HotReloadHost.kt\ncom/jetbrains/rider/hotReload/HotReloadHost$Companion\n*L\n25#1:58,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HotReloadHost getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager componentManager = (ComponentManager)project;
            boolean bl = false;
            Class<HotReloadHost> clazz = HotReloadHost.class;
            Object object = componentManager.getService(clazz);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)componentManager, clazz);
            }
            return (HotReloadHost)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/hotReload/HotReloadHost$ProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/HotReloadModel;", "()V", "extensionCreated", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "intellij.rider"})
    public static final class ProtocolListener
    implements SolutionExtListener<HotReloadModel> {
        public void extensionCreated(@NotNull Lifetime lifetime2, @NotNull ClientProjectSession session, @NotNull HotReloadModel model2) {
            Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
            HotReloadHost hotReloadHost = Companion.getInstance(session.getProject());
            BeCommonExtensionsKt.bind((IOptProperty)((IOptProperty)hotReloadHost.getDebugHotReloadEnabled()), (Lifetime)lifetime2, (IOptProperty)model2.getDebugHotReloadEnabled());
            BeCommonExtensionsKt.bind((IOptProperty)((IOptProperty)hotReloadHost.getRuntimeHotReloadEnabled()), (Lifetime)lifetime2, (IOptProperty)model2.getRuntimeHotReloadEnabled());
            BeCommonExtensionsKt.bind((IOptProperty)((IOptProperty)hotReloadHost.getBlazorWasmHotReloadEnabled()), (Lifetime)lifetime2, (IOptProperty)model2.getBlazorWasmHotReloadEnabled());
        }
    }
}

