/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup.analyzers;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.analyzers.XamarinEnvironmentComponentBase;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.util.SubProgressIndicatorKt;
import icons.RiderIcons;
import java.io.File;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\nH\u0016R\u0016\u0010\t\u001a\u00020\n8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0019\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\fR\u0014\u0010\u0016\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\f\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/XamarinAndroidEnvironmentComponent;", "Lcom/jetbrains/rider/environmentSetup/analyzers/XamarinEnvironmentComponentBase;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "isCalledOnInitialStep", "", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;Z)V", "description", "", "getDescription", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "id", "getId", "name", "getName", "url", "getUrl", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.rider"})
public final class XamarinAndroidEnvironmentComponent
extends XamarinEnvironmentComponentBase {
    private final boolean isCalledOnInitialStep;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String url;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String description;
    @NotNull
    private final Icon icon;

    public XamarinAndroidEnvironmentComponent(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader, boolean isCalledOnInitialStep) {
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        super(localReader, updatesReader, "Xamarin.Android");
        this.isCalledOnInitialStep = isCalledOnInitialStep;
        this.id = "xamarin-android";
        this.name = "Xamarin Android";
        this.url = "https://docs.microsoft.com/en-us/xamarin/android/";
        this.description = RiderEnvironmentSetupBundle.Companion.message("xamarin.android.environment.component.description", new Object[0]);
        Icon icon2 = RiderIcons.Components.EnvironmentXamarin;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EnvironmentXamarin");
        this.icon = icon2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
        File file2;
        File file3;
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        super.doExecute(SubProgressIndicatorKt.createSubProgress((ProgressIndicator)pi, (double)0.5), url2);
        ComponentsUpdatesReader.Info info = this.getUpdatesReader().get("jdk8", null);
        if (info == null) {
            return;
        }
        ComponentsUpdatesReader.Info info2 = info;
        File file4 = file3 = SystemInfo.isWindows ? FilesKt.resolve((File)new File(System.getenv("LOCALAPPDATA")), (String)"JetBrains") : (SystemInfo.isMac ? FilesKt.resolve((File)FilesKt.resolve((File)FilesKt.resolve((File)new File(System.getProperty("user.home")), (String)".local"), (String)"share"), (String)"JetBrains") : null);
        File file5 = file2 = file4 != null ? FilesKt.resolve((File)file4, (String)"jdk8") : null;
        if (file2 != null && !file2.exists()) {
            EnvironmentSetupUtils.INSTANCE.downloadAndExtract(info2.getUrl(), SubProgressIndicatorKt.createSubProgress((ProgressIndicator)pi, (double)0.1), (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(pi, file2){
                final /* synthetic */ ProgressIndicator $pi;
                final /* synthetic */ File $jdkFolder;
                {
                    this.$pi = $pi;
                    this.$jdkFolder = $jdkFolder;
                    super(1);
                }

                public final void invoke(@NotNull File folder) {
                    Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
                    this.$pi.setText2(RiderBundle.message("progress.details.installing", new Object[0]));
                    this.$pi.setIndeterminate(true);
                    this.$pi.startNonCancelableSection();
                    EnvironmentSetupUtils.moveDirectoryContentRecursive$default(EnvironmentSetupUtils.INSTANCE, folder, this.$jdkFolder, EnvironmentSetupUtils.MoveStrategy.MoveOverwrite, null, 8, null);
                    this.$pi.finishNonCancelableSection();
                }
            }));
        } else {
            pi.setFraction(pi.getFraction() + 0.1);
        }
        if (EnvironmentSetupUtils.INSTANCE.installPluginIfNeeded("com.jetbrains.rider.android", SubProgressIndicatorKt.createSubProgress((ProgressIndicator)pi, (double)0.4), this.isCalledOnInitialStep)) {
            this.setRestartRequested(true);
        }
    }
}

