/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup.analyzers;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.SingleEnvironmentComponent;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupUtils;
import com.jetbrains.rider.nuget.helpers.RiderNuGetOperation;
import icons.RiderIcons;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\bH\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0013H\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0016\u0010\u0007\u001a\u00020\b8\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\nR\u0014\u0010\u0016\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/environmentSetup/analyzers/MonoEnvironmentComponent;", "Lcom/jetbrains/rider/environmentSetup/SingleEnvironmentComponent;", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "(Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;)V", "description", "", "getDescription", "()Ljava/lang/String;", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "id", "getId", "localVersion", "Lcom/jetbrains/rider/nuget/helpers/RiderNuGetOperation$Version;", "name", "getName", "url", "getUrl", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getLocalVersion", "supportedByOS", "", "intellij.rider"})
public final class MonoEnvironmentComponent
extends SingleEnvironmentComponent {
    @Nullable
    private RiderNuGetOperation.Version localVersion;
    @NotNull
    private final String id;
    @NotNull
    private final String name;
    @NotNull
    private final String url;
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    private final String description;
    @NotNull
    private final Icon icon;

    public MonoEnvironmentComponent(@NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader) {
        Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
        Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
        super(localReader, updatesReader);
        Element element = localReader.find("monoRuntimes");
        List list2 = element != null ? element.getChildren("monoRuntime") : null;
        List list3 = list2 == null ? CollectionsKt.emptyList() : list2;
        for (Element element2 : list3) {
            String string;
            Attribute attribute = element2.getAttribute("version");
            if ((attribute != null ? attribute.getValue() : null) == null) continue;
            string = string;
            RiderNuGetOperation.Version version = RiderNuGetOperation.Version.Companion.parse(string);
            RiderNuGetOperation.Version version2 = this.localVersion;
            if (version2 != null && version2.compareTo(version) >= 0) continue;
            this.localVersion = version;
        }
        this.id = "mono";
        this.name = "Mono";
        this.url = "https://www.mono-project.com/";
        this.description = RiderEnvironmentSetupBundle.Companion.message("mono.environment.component.description", new Object[0]);
        Icon icon2 = RiderIcons.Components.EnvironmentMono;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"EnvironmentMono");
        this.icon = icon2;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String getDescription() {
        return this.description;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    @Nullable
    protected RiderNuGetOperation.Version getLocalVersion() {
        return this.localVersion;
    }

    @Override
    public boolean supportedByOS() {
        return !SystemInfo.isWindows;
    }

    @Override
    public void doExecute(@NotNull ProgressIndicator pi, @NotNull String url2) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        EnvironmentSetupUtils.INSTANCE.downloadAndInstallPkg(url2, pi);
    }
}

