/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.plugins.PluginManagerConfigurable;
import com.intellij.ide.plugins.newui.VerticalLayout;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.rider.environmentSetup.ComponentsLocalReader;
import com.jetbrains.rider.environmentSetup.ComponentsUpdatesReader;
import com.jetbrains.rider.environmentSetup.EnvironmentAnalyzer;
import com.jetbrains.rider.environmentSetup.EnvironmentComponent;
import com.jetbrains.rider.environmentSetup.EnvironmentIndicatorBase;
import com.jetbrains.rider.environmentSetup.EnvironmentSetupPanel;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001:\u0001'B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0018J\b\u0010\u001a\u001a\u00020\u0018H$J\b\u0010\u001b\u001a\u00020\u0018H$J\b\u0010\u001c\u001a\u00020\u0018H$J\u0010\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH$J\b\u0010 \u001a\u00020\u0018H$J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010\t\u001a\u00020!H\u0002J\"\u0010\"\u001a\u00020\u00182\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006("}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;", "", "project", "Lcom/intellij/openapi/project/Project;", "componentName", "", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;)V", "analyzer", "Lcom/jetbrains/rider/environmentSetup/EnvironmentAnalyzer;", "component", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "getComponentName", "()Ljava/lang/String;", "indicator", "Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView$MyIndicator;", "infoLabel", "Ljavax/swing/JLabel;", "mainPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getMainPanel", "()Lcom/intellij/util/ui/components/BorderLayoutPanel;", "getProject", "()Lcom/intellij/openapi/project/Project;", "cancel", "", "install", "onCancel", "onCancelDisabled", "onCancelEnabled", "onEnabled", "action", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "onReady", "Ljavax/swing/JComponent;", "j", "localReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsLocalReader;", "updatesReader", "Lcom/jetbrains/rider/environmentSetup/ComponentsUpdatesReader;", "MyIndicator", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nEnvironmentSetupSingleComponentView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnvironmentSetupSingleComponentView.kt\ncom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,240:1\n1#2:241\n*E\n"})
public abstract class EnvironmentSetupSingleComponentView {
    @Nullable
    private final Project project;
    @NotNull
    private final String componentName;
    @NotNull
    private final EnvironmentAnalyzer analyzer;
    @NotNull
    private final JLabel infoLabel;
    @Nullable
    private EnvironmentComponent component;
    @Nullable
    private MyIndicator indicator;
    @NotNull
    private final BorderLayoutPanel mainPanel;

    public EnvironmentSetupSingleComponentView(@Nullable Project project, @NotNull String componentName) {
        BorderLayoutPanel borderLayoutPanel;
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        this.project = project;
        this.componentName = componentName;
        this.analyzer = new EnvironmentAnalyzer(this.project, false);
        this.infoLabel = new JLabel(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupManager.info.label.refreshing", new Object[0]), 0);
        BorderLayoutPanel borderLayoutPanel2 = borderLayoutPanel = new BorderLayoutPanel();
        EnvironmentSetupSingleComponentView environmentSetupSingleComponentView = this;
        boolean bl = false;
        borderLayoutPanel2.add((Component)this.infoLabel);
        environmentSetupSingleComponentView.mainPanel = borderLayoutPanel;
        this.analyzer.analyze((Function3<? super List<? extends EnvironmentComponent>, ? super ComponentsLocalReader, ? super ComponentsUpdatesReader, Unit>)((Function3)new Function3<List<? extends EnvironmentComponent>, ComponentsLocalReader, ComponentsUpdatesReader, Unit>(){

            public final void invoke(@NotNull List<? extends EnvironmentComponent> components, @NotNull ComponentsLocalReader localReader, @NotNull ComponentsUpdatesReader updatesReader) {
                Intrinsics.checkNotNullParameter(components, (String)"components");
                Intrinsics.checkNotNullParameter((Object)localReader, (String)"localReader");
                Intrinsics.checkNotNullParameter((Object)updatesReader, (String)"updatesReader");
                this.j((EnvironmentComponent)CollectionsKt.singleOrNull(components), localReader, updatesReader);
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                infoLabel.setText(it);
            }
        }), (Function1<? super EnvironmentComponent, Boolean>)((Function1)new Function1<EnvironmentComponent, Boolean>(){

            @NotNull
            public final Boolean invoke(@NotNull EnvironmentComponent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return StringsKt.equals((String)it.getName(), (String)this.getComponentName(), (boolean)true);
            }
        }));
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getComponentName() {
        return this.componentName;
    }

    @NotNull
    public final BorderLayoutPanel getMainPanel() {
        return this.mainPanel;
    }

    protected abstract void onEnabled(@NotNull EnvironmentComponent.Action var1);

    protected abstract void onReady();

    protected abstract void onCancel();

    protected abstract void onCancelEnabled();

    protected abstract void onCancelDisabled();

    private final void j(EnvironmentComponent environmentComponent, ComponentsLocalReader componentsLocalReader, ComponentsUpdatesReader componentsUpdatesReader) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (environmentComponent == null) {
            Object[] objectArray = new Object[]{this.componentName};
            this.infoLabel.setText(RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupManager.label.can.not.find.component.with.name", objectArray));
            return;
        }
        this.component = environmentComponent;
        OpaquePanel opaquePanel = object5 = new OpaquePanel((LayoutManager)new BorderLayout(JBUI.scale((int)10), 0));
        boolean bl2 = false;
        opaquePanel.setBorder(JBUI.Borders.empty((int)15));
        OpaquePanel opaquePanel2 = object5;
        opaquePanel = object5 = new JLabel(environmentComponent.getIcon());
        OpaquePanel opaquePanel3 = opaquePanel2;
        bl2 = false;
        opaquePanel.setVerticalAlignment(1);
        opaquePanel3.add((Component)object5, (Object)"West");
        object5 = new OpaquePanel((LayoutManager)new VerticalLayout(JBUI.scale((int)5), JBUI.scale((int)181)));
        opaquePanel2.add((Component)object5);
        opaquePanel = new LinkLabel("<html><b>" + environmentComponent.getName() + "</b></html>", null, (arg_0, arg_1) -> EnvironmentSetupSingleComponentView.j(environmentComponent, arg_0, arg_1));
        object5.add(RelativeFont.LARGE.install((Component)opaquePanel));
        Object object6 = new Object[]{environmentComponent.getVersion()};
        JLabel jLabel = new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.version", object6)).wrapWith(HtmlChunk.html()).toString());
        object5.add((Component)jLabel);
        Object object7 = object4 = new JLabel("<html>" + environmentComponent.getDescription() + "</html>");
        boolean bl3 = false;
        ((JComponent)object7).setBorder((Border)JBUI.Borders.empty((int)5, (int)0, (int)0, (int)0));
        object6 = object4;
        object5.add((Component)object6);
        object4 = environmentComponent.getAction();
        if (object4 != null) {
            object3 = new Object[]{object4.getVersion(), object4.getSize()};
            String string = HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.available.version", (Object[])object3)).wrapWith(HtmlChunk.p()).wrapWith(HtmlChunk.html()).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            object7 = string;
            Object object8 = object3 = new JLabel((String)object7, 0);
            boolean bl4 = false;
            ((JComponent)object8).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            ((JComponent)object8).setBorder((Border)JBUI.Borders.empty((int)5, (int)0));
            Object object9 = object3;
            object5.add((Component)object9);
            object2 = object8 = new JLabel("", 0);
            boolean bl5 = false;
            ((JComponent)object2).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            object3 = object8;
            object = object2 = new JProgressBar(0, 100);
            boolean bl6 = false;
            ((JComponent)object).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            ((JComponent)object).setVisible(false);
            object8 = object2;
            this.indicator = new MyIndicator(this, (JProgressBar)object8, (JLabel)object3);
            object5.add((Component)object8);
            object5.add((Component)object3);
            this.onEnabled((EnvironmentComponent.Action)object4);
        } else {
            String string = environmentComponent.getActionNotAvailableReason();
            if (string == null) {
                string = RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.can.not.install.component", new Object[0]);
            }
            object7 = string;
            JLabel jLabel2 = new JLabel(HtmlChunk.raw((String)object7).wrapWith(HtmlChunk.font((String)"gray")).wrapWith(HtmlChunk.html()).toString());
            object3 = jLabel2;
            opaquePanel3 = object5;
            boolean bl7 = false;
            ((JComponent)object3).setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
            opaquePanel3.add((Component)jLabel2);
        }
        this.mainPanel.removeAll();
        this.mainPanel.add((Component)opaquePanel2);
        Throwable throwable = componentsLocalReader.getError();
        if (throwable != null) {
            object3 = throwable;
            boolean bl8 = false;
            object = object2 = EnvironmentSetupPanel.Companion.createLocalErrorLabel((Throwable)object3);
            BorderLayoutPanel borderLayoutPanel = this.mainPanel;
            bl = false;
            ((JComponent)object).setBorder(JBUI.Borders.empty((int)15));
            borderLayoutPanel.addToBottom((Component)object2);
        }
        Throwable throwable2 = componentsUpdatesReader.getError();
        if (throwable2 != null) {
            object3 = throwable2;
            boolean bl9 = false;
            object = object2 = EnvironmentSetupPanel.Companion.createUpdatesErrorLabel((Throwable)object3);
            BorderLayoutPanel borderLayoutPanel = this.mainPanel;
            bl = false;
            ((JComponent)object).setBorder(JBUI.Borders.empty((int)15));
            borderLayoutPanel.addToBottom((Component)object2);
        }
        this.mainPanel.setBackground(PluginManagerConfigurable.MAIN_BG_COLOR);
        this.mainPanel.updateUI();
    }

    public final void install() {
        MyIndicator myIndicator = this.indicator;
        if (myIndicator == null) {
            return;
        }
        MyIndicator myIndicator2 = myIndicator;
        EnvironmentComponent environmentComponent = this.component;
        if (environmentComponent == null) {
            return;
        }
        EnvironmentComponent environmentComponent2 = environmentComponent;
        myIndicator2.start();
        environmentComponent2.execute((ProgressIndicator)myIndicator2, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EnvironmentSetupSingleComponentView this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                EnvironmentSetupSingleComponentView.access$onReady(this.this$0, new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.installation.completed", new Object[0])).wrapWith(HtmlChunk.font((String)"green")).wrapWith(HtmlChunk.html()).toString(), AllIcons.General.InspectionsOK, 0));
            }
        }), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ EnvironmentSetupSingleComponentView this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                Object[] objectArray = new Object[]{error};
                EnvironmentSetupSingleComponentView.access$onReady(this.this$0, new JLabel(HtmlChunk.raw((String)RiderEnvironmentSetupBundle.Companion.message("EnvironmentSetupSingleComponentView.label.can.not.install.component.0", objectArray)).wrapWith(HtmlChunk.font((String)"red")).wrapWith(HtmlChunk.html()).toString(), AllIcons.General.Error, 0));
            }
        }));
    }

    private final void j(JComponent jComponent) {
        SwingUtilities.invokeLater(() -> EnvironmentSetupSingleComponentView.j(this, jComponent));
    }

    public final void cancel() {
        block1: {
            MyIndicator myIndicator = this.indicator;
            boolean bl = myIndicator != null ? myIndicator.isRunning() : false;
            if (!bl) break block1;
            MyIndicator myIndicator2 = this.indicator;
            if (myIndicator2 != null) {
                myIndicator2.cancel();
            }
        }
    }

    private static final void j(EnvironmentComponent environmentComponent, LinkLabel linkLabel, Object object) {
        BrowserUtil.browse((String)environmentComponent.getUrl());
    }

    private static final void j(EnvironmentSetupSingleComponentView environmentSetupSingleComponentView, JComponent jComponent) {
        JComponent jComponent2;
        Intrinsics.checkNotNullParameter((Object)environmentSetupSingleComponentView, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)jComponent, (String)"$component");
        MyIndicator myIndicator = environmentSetupSingleComponentView.indicator;
        if (myIndicator != null) {
            MyIndicator myIndicator2 = myIndicator;
            boolean bl = false;
            myIndicator2.getProgressBar().setVisible(false);
            myIndicator2.getStatusLabel().setVisible(false);
        }
        environmentSetupSingleComponentView.indicator = null;
        JComponent jComponent3 = jComponent2 = jComponent;
        BorderLayoutPanel borderLayoutPanel = environmentSetupSingleComponentView.mainPanel;
        boolean bl = false;
        jComponent3.setBorder(JBUI.Borders.empty((int)15));
        borderLayoutPanel.addToBottom((Component)jComponent2);
        environmentSetupSingleComponentView.mainPanel.updateUI();
        environmentSetupSingleComponentView.onReady();
    }

    public static final /* synthetic */ void access$onReady(EnvironmentSetupSingleComponentView $this, JComponent component2) {
        $this.j(component2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView$MyIndicator;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentIndicatorBase;", "owner", "Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;", "progressBar", "Ljavax/swing/JProgressBar;", "statusLabel", "Ljavax/swing/JLabel;", "(Lcom/jetbrains/rider/environmentSetup/EnvironmentSetupSingleComponentView;Ljavax/swing/JProgressBar;Ljavax/swing/JLabel;)V", "getProgressBar", "()Ljavax/swing/JProgressBar;", "getStatusLabel", "()Ljavax/swing/JLabel;", "cancel", "", "finishNonCancelableSection", "start", "startNonCancelableSection", "intellij.rider"})
    private static final class MyIndicator
    extends EnvironmentIndicatorBase {
        @NotNull
        private final EnvironmentSetupSingleComponentView owner;
        @NotNull
        private final JProgressBar progressBar;
        @NotNull
        private final JLabel statusLabel;

        public MyIndicator(@NotNull EnvironmentSetupSingleComponentView owner, @NotNull JProgressBar progressBar, @NotNull JLabel statusLabel) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
            Intrinsics.checkNotNullParameter((Object)statusLabel, (String)"statusLabel");
            super(progressBar, statusLabel);
            this.owner = owner;
            this.progressBar = progressBar;
            this.statusLabel = statusLabel;
        }

        @NotNull
        public final JProgressBar getProgressBar() {
            return this.progressBar;
        }

        @NotNull
        public final JLabel getStatusLabel() {
            return this.statusLabel;
        }

        public void start() {
            super.start();
            SwingUtilities.invokeLater(() -> MyIndicator.N(this));
        }

        @Override
        public void cancel() {
            super.cancel();
            SwingUtilities.invokeLater(() -> MyIndicator.v(this));
        }

        public void startNonCancelableSection() {
            super.startNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.j(this));
        }

        public void finishNonCancelableSection() {
            super.finishNonCancelableSection();
            SwingUtilities.invokeLater(() -> MyIndicator.w(this));
        }

        private static final void N(MyIndicator myIndicator) {
            Intrinsics.checkNotNullParameter((Object)((Object)myIndicator), (String)"this$0");
            myIndicator.progressBar.setVisible(true);
        }

        private static final void v(MyIndicator myIndicator) {
            Intrinsics.checkNotNullParameter((Object)((Object)myIndicator), (String)"this$0");
            myIndicator.owner.onCancel();
        }

        private static final void j(MyIndicator myIndicator) {
            Intrinsics.checkNotNullParameter((Object)((Object)myIndicator), (String)"this$0");
            myIndicator.owner.onCancelDisabled();
        }

        private static final void w(MyIndicator myIndicator) {
            Intrinsics.checkNotNullParameter((Object)((Object)myIndicator), (String)"this$0");
            myIndicator.owner.onCancelEnabled();
        }
    }
}

