/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.environmentSetup;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.environmentSetup.RiderEnvironmentSetupBundle;
import com.jetbrains.rider.environmentSetup.impl.EnvironmentSetupManager;
import com.jetbrains.rider.wizard.RiderUnderWizardRunner;
import com.jetbrains.rider.wizard.core.stat.RiderWizardStat;
import java.util.HashSet;
import java.util.concurrent.CancellationException;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 )2\u00020\u0001:\u0005()*+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH$J5\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0017\u0010\"\u001a\u0013\u0012\t\u0012\u00070\u0004\u00a2\u0006\u0002\b$\u0012\u0004\u0012\u00020\u001c0#J\n\u0010%\u001a\u0004\u0018\u00010&H&J\b\u0010'\u001a\u00020\u0012H&R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006-"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent;", "", "()V", "actionNotAvailableReason", "", "getActionNotAvailableReason", "()Ljava/lang/String;", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "id", "getId", "name", "getName", "restartRequested", "", "getRestartRequested", "()Z", "setRestartRequested", "(Z)V", "url", "getUrl", "version", "getVersion", "doExecute", "", "pi", "Lcom/intellij/openapi/progress/ProgressIndicator;", "execute", "onDone", "Lkotlin/Function0;", "onError", "Lkotlin/Function1;", "Lorg/jetbrains/annotations/Nls;", "getAction", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "supportedByOS", "Action", "Companion", "InstallAction", "Tag", "UpdateAction", "intellij.rider"})
public abstract class EnvironmentComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean restartRequested;
    @NotNull
    private static final HashSet<String> installedComponentsSet = new HashSet();

    public final void execute(@NotNull ProgressIndicator pi, @NotNull Function0<Unit> onDone, @NotNull Function1<? super String, Unit> onError) {
        Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
        Intrinsics.checkNotNullParameter(onDone, (String)"onDone");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        EnvironmentSetupManager.INSTANCE.registerJob(this.getName(), pi, (Function0<Boolean>)((Function0)new Function0<Boolean>(this, pi, onDone, onError){
            final /* synthetic */ EnvironmentComponent this$0;
            final /* synthetic */ ProgressIndicator $pi;
            final /* synthetic */ Function0<Unit> $onDone;
            final /* synthetic */ Function1<String, Unit> $onError;
            {
                this.this$0 = $receiver;
                this.$pi = $pi;
                this.$onDone = $onDone;
                this.$onError = $onError;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                try {
                    this.this$0.doExecute(this.$pi);
                    this.$onDone.invoke();
                    EnvironmentComponent.access$getInstalledComponentsSet$cp().add(this.this$0.getId());
                    RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ EnvironmentComponent this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            RiderWizardStat.INSTANCE.envStepOnInstall(this.this$0);
                        }
                    }));
                    return true;
                }
                catch (CancellationException cancellationException) {
                    RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ EnvironmentComponent this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            RiderWizardStat.INSTANCE.envStepOnCancel(this.this$0);
                        }
                    }));
                    return false;
                }
                catch (Throwable throwable) {
                    RiderUnderWizardRunner.INSTANCE.runAction((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0){
                        final /* synthetic */ EnvironmentComponent this$0;
                        {
                            this.this$0 = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            RiderWizardStat.INSTANCE.envStepOnFail(this.this$0);
                        }
                    }));
                    Logger.getInstance((String)"EnvironmentComponent").error(throwable);
                    String string = throwable.getLocalizedMessage();
                    if (string == null && (string = throwable.getMessage()) == null) {
                        string = RiderEnvironmentSetupBundle.Companion.message("EnvironmentComponent.unknown.error", new Object[0]);
                    }
                    String string2 = string;
                    this.$onError.invoke((Object)string2);
                    return false;
                }
            }
        }));
    }

    @NotNull
    public abstract String getId();

    public final boolean getRestartRequested() {
        return this.restartRequested;
    }

    public final void setRestartRequested(boolean bl) {
        this.restartRequested = bl;
    }

    @Nls
    @NotNull
    public abstract String getName();

    @NlsSafe
    @NotNull
    public abstract String getUrl();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public abstract String getDescription();

    @NotNull
    public abstract Icon getIcon();

    @NlsSafe
    @NotNull
    public abstract String getVersion();

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public abstract String getActionNotAvailableReason();

    public abstract boolean supportedByOS();

    @Nullable
    public abstract Action getAction();

    protected abstract void doExecute(@NotNull ProgressIndicator var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0012\u0010\b\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "", "name", "", "getName", "()Ljava/lang/String;", "size", "getSize", "version", "getVersion", "intellij.rider"})
    public static interface Action {
        @NotNull
        public String getName();

        @NotNull
        public String getVersion();

        @NotNull
        public String getSize();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Companion;", "", "()V", "installedComponentsSet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "isInstalled", "", "id", "intellij.rider"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isInstalled(@NotNull String id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            return installedComponentsSet.contains(id2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$InstallAction;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "version", "", "size", "(Ljava/lang/String;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "getSize", "getVersion", "intellij.rider"})
    public static final class InstallAction
    implements Action {
        @NotNull
        private final String version;
        @NotNull
        private final String size;
        @NotNull
        private final String name;

        public InstallAction(@NotNull String version, @NotNull String size) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.version = version;
            this.size = size;
            this.name = "Install";
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version;
        }

        @Override
        @NotNull
        public String getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Tag;", "", "name", "", "value", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.rider"})
    public static final class Tag {
        @NotNull
        private final String name;
        @NotNull
        private final String value;

        public Tag(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.name = name;
            this.value = value;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.value;
        }

        @NotNull
        public final Tag copy(@NotNull String name, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return new Tag(name, value);
        }

        public static /* synthetic */ Tag copy$default(Tag tag, String string, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = tag.name;
            }
            if ((n2 & 2) != 0) {
                string2 = tag.value;
            }
            return tag.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Tag(name=" + this.name + ", value=" + this.value + ")";
        }

        public int hashCode() {
            int n2 = this.name.hashCode();
            n2 = n2 * 31 + this.value.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Tag)) {
                return false;
            }
            Tag tag = (Tag)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)tag.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.value, (Object)tag.value);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$UpdateAction;", "Lcom/jetbrains/rider/environmentSetup/EnvironmentComponent$Action;", "version", "", "size", "(Ljava/lang/String;Ljava/lang/String;)V", "name", "getName", "()Ljava/lang/String;", "getSize", "getVersion", "intellij.rider"})
    public static final class UpdateAction
    implements Action {
        @NotNull
        private final String version;
        @NotNull
        private final String size;
        @NotNull
        private final String name;

        public UpdateAction(@NotNull String version, @NotNull String size) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)size, (String)"size");
            this.version = version;
            this.size = size;
            this.name = "Update";
        }

        @Override
        @NotNull
        public String getVersion() {
            return this.version;
        }

        @Override
        @NotNull
        public String getSize() {
            return this.size;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }
    }
}

