/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.psi.PsiFile;
import com.intellij.util.Alarm;
import com.intellij.util.SingleAlarm;
import com.jetbrains.ide.model.highlighterRegistration.HighlighterProperties;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.document.VersionsExKt;
import com.jetbrains.rd.ide.editor.markup.UtilKt;
import com.jetbrains.rd.ide.model.AbstractDocumentVersion;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rdclient.document.DocumentExKt;
import com.jetbrains.rdclient.document.FrontendDocumentHost;
import com.jetbrains.rider.cpp.fileType.CppLanguage;
import com.jetbrains.rider.editors.PlatformTextControlUtilsKt;
import com.jetbrains.rider.editors.statistic.RiderMarkupStatisticCollector;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/editors/RiderEditorMarkupTracker;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "()V", "supportedLanguages", "", "Lcom/intellij/lang/Language;", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "EditorMarkupListener", "intellij.rider"})
public final class RiderEditorMarkupTracker
implements EditorFactoryListener {
    @NotNull
    private final List<Language> supportedLanguages;

    public RiderEditorMarkupTracker() {
        Object[] objectArray = new Language[]{CSharpLanguage.INSTANCE, CppLanguage.INSTANCE};
        this.supportedLanguages = CollectionsKt.listOf((Object[])objectArray);
    }

    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        long l = System.nanoTime();
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        Project project = editor3.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        PsiFile psiFile = PlatformTextControlUtilsKt.getPsiFile((Editor)editor3);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            return;
        }
        PsiFile psiFile2 = psiFile;
        if (!this.supportedLanguages.contains(psiFile2)) {
            return;
        }
        Disposable disposable = ((EditorImpl)editor3).getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        LifetimeDefinition lifetimeDefinition = LifetimeDisposableExKt.defineNestedLifetime((Disposable)disposable);
        DocumentEx documentEx = ((EditorImpl)editor3).getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(project2, (Document)documentEx);
        if (frontendMarkupContributor == null || (frontendMarkupContributor = frontendMarkupContributor.getMarkupAdapter()) == null) {
            return;
        }
        FrontendMarkupContributor frontendMarkupContributor2 = frontendMarkupContributor;
        frontendMarkupContributor2.addListener(lifetimeDefinition.getLifetime(), (FrontendMarkupAdapterListener)new EditorMarkupListener(project2, editor3, (Language)psiFile2, l, lifetimeDefinition));
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010!\u001a\u00020\u001e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020 0#H\u0016J\b\u0010$\u001a\u00020\u001eH\u0002J\f\u0010%\u001a\u00020&*\u00020&H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/editors/RiderEditorMarkupTracker$EditorMarkupListener;", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "language", "Lcom/intellij/lang/Language;", "editorOpenTime", "", "listenerLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Lcom/intellij/lang/Language;JLcom/jetbrains/rd/util/lifetime/LifetimeDefinition;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getEditorOpenTime", "()J", "isBackendReady", "", "getLanguage", "()Lcom/intellij/lang/Language;", "lastUpdateTime", "Ljava/lang/Long;", "getListenerLifetimeDefinition", "()Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "getProject", "()Lcom/intellij/openapi/project/Project;", "updateAlarm", "Lcom/intellij/util/SingleAlarm;", "afterAdded", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "afterBulkAdd", "highlighters", "", "j", "j", "", "intellij.rider"})
    @SourceDebugExtension(value={"SMAP\nRiderEditorMarkupTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderEditorMarkupTracker.kt\ncom/jetbrains/rider/editors/RiderEditorMarkupTracker$EditorMarkupListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1603#2,9:111\n1855#2:120\n1856#2:122\n1612#2:123\n1#3:121\n*S KotlinDebug\n*F\n+ 1 RiderEditorMarkupTracker.kt\ncom/jetbrains/rider/editors/RiderEditorMarkupTracker$EditorMarkupListener\n*L\n85#1:111,9\n85#1:120\n85#1:122\n85#1:123\n85#1:121\n*E\n"})
    private static final class EditorMarkupListener
    implements FrontendMarkupAdapterListener {
        @NotNull
        private final Project project;
        @NotNull
        private final Editor editor;
        @NotNull
        private final Language language;
        private final long editorOpenTime;
        @NotNull
        private final LifetimeDefinition listenerLifetimeDefinition;
        @Nullable
        private Long lastUpdateTime;
        private final boolean isBackendReady;
        @NotNull
        private final SingleAlarm updateAlarm;

        public EditorMarkupListener(@NotNull Project project, @NotNull Editor editor2, @NotNull Language language, long editorOpenTime, @NotNull LifetimeDefinition listenerLifetimeDefinition) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            Intrinsics.checkNotNullParameter((Object)listenerLifetimeDefinition, (String)"listenerLifetimeDefinition");
            this.project = project;
            this.editor = editor2;
            this.language = language;
            this.editorOpenTime = editorOpenTime;
            this.listenerLifetimeDefinition = listenerLifetimeDefinition;
            this.isBackendReady = SolutionHostExtensionsKt.getSolution((Project)this.project).getSolutionLifecycle().getFullStartupFinished().getValueOrNull() != null;
            this.updateAlarm = new SingleAlarm(() -> EditorMarkupListener.j(this), this.isBackendReady ? 500 : 2000, LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)this.listenerLifetimeDefinition.getLifetime(), null, (int)1, null), Alarm.ThreadToUse.SWING_THREAD, ModalityState.any());
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Editor getEditor() {
            return this.editor;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final long getEditorOpenTime() {
            return this.editorOpenTime;
        }

        @NotNull
        public final LifetimeDefinition getListenerLifetimeDefinition() {
            return this.listenerLifetimeDefinition;
        }

        public void afterAdded(@NotNull RangeHighlighterEx highlighter2) {
            Intrinsics.checkNotNullParameter((Object)highlighter2, (String)"highlighter");
            long l = System.nanoTime();
            this.j();
            if (RLifetimeKt.isNotAlive((Lifetime)this.listenerLifetimeDefinition.getLifetime())) {
                return;
            }
            if (UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)highlighter2)) == null) {
                return;
            }
            this.lastUpdateTime = l;
            SingleAlarm.request$default((SingleAlarm)this.updateAlarm, (boolean)false, (int)0, (int)3, null);
        }

        public void afterBulkAdd(@NotNull List<? extends RangeHighlighterEx> highlighters) {
            Intrinsics.checkNotNullParameter(highlighters, (String)"highlighters");
            long l = System.nanoTime();
            this.j();
            if (RLifetimeKt.isNotAlive((Lifetime)this.listenerLifetimeDefinition.getLifetime())) {
                return;
            }
            Iterable iterable = highlighters;
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            Iterable iterable3 = iterable2;
            boolean bl3 = false;
            Iterator iterator2 = iterable3.iterator();
            while (iterator2.hasNext()) {
                HighlighterProperties highlighterProperties;
                Object t;
                Object t2 = t = iterator2.next();
                boolean bl4 = false;
                RangeHighlighterEx rangeHighlighterEx = (RangeHighlighterEx)t2;
                boolean bl5 = false;
                if (UtilKt.getBackendProperties((RangeHighlighter)((RangeHighlighter)rangeHighlighterEx)) == null) continue;
                boolean bl6 = false;
                collection.add(highlighterProperties);
            }
            if (!CollectionsKt.any((Iterable)((List)collection))) {
                return;
            }
            this.lastUpdateTime = l;
            SingleAlarm.request$default((SingleAlarm)this.updateAlarm, (boolean)false, (int)0, (int)3, null);
        }

        private final void j() {
            if (EditorMarkupListener.j(this)) {
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.listenerLifetimeDefinition, (boolean)false, (int)1, null);
            }
        }

        private final int j(int n2) {
            int n3 = (int)Math.log10(n2);
            int n4 = (int)Math.pow(10.0, n3);
            return RangesKt.coerceAtLeast((int)(n2 - n2 % n4), (int)10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final void j(EditorMarkupListener editorMarkupListener) {
            Intrinsics.checkNotNullParameter((Object)editorMarkupListener, (String)"this$0");
            Long l = editorMarkupListener.lastUpdateTime;
            if (l == null) {
                return;
            }
            long l2 = l;
            long l3 = TimeUnit.MILLISECONDS.convert(l2 - editorMarkupListener.editorOpenTime, TimeUnit.NANOSECONDS);
            try {
                int n2 = editorMarkupListener.j(editorMarkupListener.editor.getDocument().getLineCount());
                RiderMarkupStatisticCollector.INSTANCE.logMarkupReady(editorMarkupListener.project, editorMarkupListener.language, n2, l3);
            }
            catch (Exception exception) {
            }
            finally {
                LifetimeDefinition.terminate$default((LifetimeDefinition)editorMarkupListener.listenerLifetimeDefinition, (boolean)false, (int)1, null);
            }
        }

        private static final boolean j(EditorMarkupListener editorMarkupListener) {
            Document document2 = editorMarkupListener.editor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            RdDocumentId rdDocumentId = DocumentExKt.getDocumentId((Document)document2, (Project)editorMarkupListener.project);
            if (rdDocumentId == null) {
                return true;
            }
            RdDocumentId rdDocumentId2 = rdDocumentId;
            DocumentSynchronizer documentSynchronizer = FrontendDocumentHost.Companion.getInstance(editorMarkupListener.project).getSynchronizer(rdDocumentId2);
            if (documentSynchronizer == null) {
                return true;
            }
            DocumentSynchronizer documentSynchronizer2 = documentSynchronizer;
            return VersionsExKt.moreThan((AbstractDocumentVersion)documentSynchronizer2.getVersion(), (int)5);
        }
    }
}

