/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.editors;

import com.intellij.codeInsight.hint.ImplementationViewDocumentFactory;
import com.intellij.codeInsight.hint.ImplementationViewElement;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.LanguageTextField;
import com.jetbrains.rd.ide.document.DocumentExKt;
import com.jetbrains.rd.ide.model.AbstractSandboxInfo;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdLanguage;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.lang.ProtocolLanguageManagerKt;
import com.jetbrains.rdclient.showImplementations.FrontendImplementationViewElement;
import com.jetbrains.rdclient.util.idea.RangeUtilKt;
import com.jetbrains.rider.editors.sandboxes.SandboxManager;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import com.jetbrains.rider.model.SandboxInfo;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rider/editors/QuickDefinitionDocumentFactory;", "Lcom/intellij/codeInsight/hint/ImplementationViewDocumentFactory;", "()V", "navigationOffset", "Lcom/intellij/openapi/util/Key;", "", "createDocument", "Lcom/intellij/openapi/editor/Document;", "element", "Lcom/intellij/codeInsight/hint/ImplementationViewElement;", "tuneEditorAfterShow", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "intellij.rider"})
public final class QuickDefinitionDocumentFactory
implements ImplementationViewDocumentFactory {
    @NotNull
    private final Key<Integer> navigationOffset;

    public QuickDefinitionDocumentFactory() {
        Key key2 = Key.create((String)"navigationOffset");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        this.navigationOffset = key2;
    }

    @Nullable
    public Document createDocument(@NotNull ImplementationViewElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof FrontendImplementationViewElement)) {
            return null;
        }
        VirtualFile virtualFile2 = element.getContainingFile();
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Document document2 = FileDocumentManager.getInstance().getDocument(virtualFile3);
        if (document2 == null) {
            return null;
        }
        Document document3 = document2;
        String string = document3.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String string2 = StringsKt.trimIndent((String)string);
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)element.getProject()).getPsiFile(document3);
        if (psiFile == null || (psiFile = psiFile.getLanguage()) == null) {
            psiFile = (Language)CSharpLanguage.INSTANCE;
        }
        PsiFile psiFile2 = psiFile;
        Intrinsics.checkNotNull((Object)psiFile2);
        PsiFile psiFile3 = psiFile2;
        RdLanguage rdLanguage = ProtocolLanguageManagerKt.toRdLanguage((Language)psiFile3);
        if (rdLanguage == null) {
            return null;
        }
        psiFile2 = rdLanguage;
        String string3 = element.getText();
        Document document4 = new LanguageTextField.SimpleDocumentCreator().createDocument(string3 != null ? StringsKt.trimIndent((String)string3) : null, (Language)psiFile3, element.getProject());
        document4.setReadOnly(true);
        RdFileDocumentId rdFileDocumentId = DocumentExKt.createDocumentId((VirtualFile)virtualFile3);
        String string4 = "/* ReSharper disable All */\n#pragma warning disable\n" + string2;
        RdTextRange rdTextRange = RangeUtilKt.fromOffset((RdTextRange.Companion)RdTextRange.Companion, (int)(((FrontendImplementationViewElement)element).getRange().getStartOffset() + 52));
        List list2 = CollectionsKt.emptyList();
        List list3 = CollectionsKt.emptyList();
        List list4 = CollectionsKt.emptyList();
        SandboxInfo sandboxInfo = new SandboxInfo("QuickDefinition", (RdDocumentId)rdFileDocumentId, string4, rdTextRange, true, null, list2, true, list3, (RdLanguage)psiFile2, true, null, true, list4);
        SandboxManager sandboxManager = SandboxManager.Companion.getInstance();
        Intrinsics.checkNotNull((Object)document4);
        sandboxManager.markAsSandbox(document4, (AbstractSandboxInfo)sandboxInfo);
        document4.putUserData(this.navigationOffset, (Object)Math.max(0, ((FrontendImplementationViewElement)element).getNavigationOffset() - ((FrontendImplementationViewElement)element).getRange().getStartOffset()));
        return document4;
    }

    public void tuneEditorAfterShow(@NotNull EditorEx editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Integer n2 = (Integer)editor2.getDocument().getUserData(this.navigationOffset);
        if (n2 != null) {
            editor2.getCaretModel().moveToOffset(n2.intValue());
            editor2.getScrollingModel().scrollTo(editor2.offsetToLogicalPosition(n2.intValue()), ScrollType.MAKE_VISIBLE);
        }
        editor2.getContentComponent().requestFocus();
    }
}

