/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.winforms.editor.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rider.designers.winforms.editor.actions.DesignerSolutionExplorerActionBase;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import icons.RiderIcons;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rider/designers/winforms/editor/actions/OpenWinFormsDesignerAction;", "Lcom/jetbrains/rider/designers/winforms/editor/actions/DesignerSolutionExplorerActionBase;", "()V", "editorTypeId", "", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "updateActionIcon", "intellij.rider"})
public final class OpenWinFormsDesignerAction
extends DesignerSolutionExplorerActionBase {
    @NotNull
    private final String editorTypeId;

    public OpenWinFormsDesignerAction() {
        super(null, 1, null);
        this.editorTypeId = "WinFormsEditor";
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        VirtualFile virtualFile2 = ProjectModelNodeExtensionKt.getVirtualFile((DataContext)dataContext);
        if (virtualFile2 == null) {
            return;
        }
        VirtualFile virtualFile3 = virtualFile2;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        FileEditorManagerEx fileEditorManagerEx = FileEditorManagerEx.Companion.getInstanceEx(project2);
        fileEditorManagerEx.openTextEditor(new OpenFileDescriptor(project2, virtualFile3), true);
        fileEditorManagerEx.setSelectedEditor(virtualFile3, this.editorTypeId);
    }

    @Override
    protected void updateActionIcon(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        Object object = this.getContextDescriptor(dataContext);
        if (object == null || (object = this.getWinFormsType((RdProjectFileDescriptor)object)) == null) {
            return;
        }
        Object object2 = object;
        Presentation presentation2 = e.getPresentation();
        presentation2.setIcon(switch (object2) {
            case "Form" -> RiderIcons.Designer.WinformsForm;
            case "CustomComponent" -> RiderIcons.Designer.WinformsComponent;
            case "UserControl" -> RiderIcons.Designer.WinformsUsercontrol;
            default -> null;
        });
    }
}

