/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.winforms.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IMutablePropertyBase;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rd.util.reactive.Signal;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.designers.DesignerEditorBase;
import com.jetbrains.rider.designers.DesignerUtils;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.winforms.DesignerEnvironmentProvider;
import com.jetbrains.rider.designers.winforms.editor.WinFormsDesignerComponent;
import com.jetbrains.rider.designers.winforms.editor.WinFormsEditorProvider;
import com.jetbrains.rider.model.DesignerDescriptor;
import com.jetbrains.rider.model.DesignerEditorState;
import com.jetbrains.rider.model.ExternalDesignerNotification;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.wormhole.awt.Wormhole;
import com.jetbrains.wormhole.events.WormholeEvent;
import com.jetbrains.wormhole.events.WormholeEventArgument;
import com.jetbrains.wormhole.interop.WindowId;
import com.jetbrains.wormhole.interop.windows.WindowsPlatformProvider;
import com.jetbrains.wormhole.interop.windows.WindowsWindowId;
import java.awt.Container;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010/\u001a\u00020'H\u0016J\b\u00100\u001a\u00020'H\u0016J\u000e\u00101\u001a\u00020'2\u0006\u00102\u001a\u000203J\u0006\u00104\u001a\u00020'J\n\u00105\u001a\u0004\u0018\u000106H\u0016J\b\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u0005H\u0016J\b\u0010:\u001a\u00020\u0012H\u0016J\b\u0010;\u001a\u000208H\u0016J\b\u0010<\u001a\u00020\u0017H\u0016J\b\u0010=\u001a\u00020\u0017H\u0016J\u0006\u0010>\u001a\u00020'J\u0006\u0010?\u001a\u00020'J\u0018\u0010?\u001a\u00020'2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020\u0017J\b\u0010C\u001a\u00020'H\u0016J\b\u0010D\u001a\u00020'H\u0002J\u0006\u0010E\u001a\u00020'R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001dR\u001c\u0010\u001f\u001a\u0004\u0018\u00010 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u0019R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditor;", "Lcom/jetbrains/rider/designers/DesignerEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "provider", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditorProvider;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/rider/designers/winforms/editor/WinFormsEditorProvider;)V", "descriptor", "Lcom/jetbrains/rider/model/DesignerDescriptor;", "getDescriptor", "()Lcom/jetbrains/rider/model/DesignerDescriptor;", "setDescriptor", "(Lcom/jetbrains/rider/model/DesignerDescriptor;)V", "editorComponent", "Lcom/jetbrains/rider/designers/winforms/editor/WinFormsDesignerComponent;", "fileId", "", "getFileId", "()Ljava/lang/String;", "focused", "Lcom/jetbrains/rd/util/reactive/Property;", "", "getFocused", "()Lcom/jetbrains/rd/util/reactive/Property;", "<set-?>", "hasWindow", "getHasWindow", "()Z", "j", "notification", "Lcom/jetbrains/rider/model/ExternalDesignerNotification;", "getNotification", "()Lcom/jetbrains/rider/model/ExternalDesignerNotification;", "setNotification", "(Lcom/jetbrains/rider/model/ExternalDesignerNotification;)V", "reload", "Lcom/jetbrains/rd/util/reactive/Signal;", "", "getReload", "()Lcom/jetbrains/rd/util/reactive/Signal;", "rootWindowId", "", "getRootWindowId", "wormhole", "Lcom/jetbrains/wormhole/awt/Wormhole;", "deselectNotify", "dispose", "embedExternalWindow", "id", "Lcom/jetbrains/wormhole/interop/WindowId;", "forceClose", "getBackgroundHighlighter", "Lcom/intellij/codeHighlighting/BackgroundEditorHighlighter;", "getComponent", "Ljavax/swing/JComponent;", "getFile", "getName", "getPreferredFocusedComponent", "isModified", "isValid", "releaseExternalWindow", "save", "taskLifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "forceSaving", "selectNotify", "j", "showError", "intellij.rider"})
public final class WinFormsEditor
extends DesignerEditorBase {
    @NotNull
    private final VirtualFile targetFile;
    @NotNull
    private final WinFormsEditorProvider provider;
    @NotNull
    private final String fileId;
    private boolean hasWindow;
    @Nullable
    private ExternalDesignerNotification notification;
    @NotNull
    private final Signal<Unit> reload;
    @NotNull
    private final Property<Boolean> focused;
    @NotNull
    private final Property<Long> rootWindowId;
    @Nullable
    private DesignerDescriptor descriptor;
    @NotNull
    private final Wormhole wormhole;
    @NotNull
    private final WinFormsDesignerComponent editorComponent;

    public WinFormsEditor(@NotNull Project project, @NotNull VirtualFile targetFile, @NotNull WinFormsEditorProvider provider2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        Intrinsics.checkNotNullParameter((Object)provider2, (String)"provider");
        super(project);
        this.targetFile = targetFile;
        this.provider = provider2;
        String string = ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((ProjectModelEntity)CollectionsKt.first((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)this.getFile(), (Project)project))).getDescriptor(), (String)"WINFORMS.ID");
        Intrinsics.checkNotNull((Object)string);
        this.fileId = string;
        this.reload = new Signal();
        this.focused = new Property((Object)false);
        this.rootWindowId = new Property((Object)0L);
        Wormhole wormhole2 = object = new Wormhole(new WindowsPlatformProvider(DesignerEnvironmentProvider.INSTANCE, null, 2, null), null, 2, null);
        WinFormsEditor winFormsEditor = this;
        boolean bl = false;
        wormhole2.addEventListener(WormholeEvent.Companion.getAttachedToRoot(), (Function1)new Function1<WormholeEventArgument.WindowId, Unit>(wormhole2, this){
            final /* synthetic */ Wormhole $it;
            final /* synthetic */ WinFormsEditor this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull WormholeEventArgument.WindowId windowId) {
                Intrinsics.checkNotNullParameter((Object)windowId, (String)"<anonymous parameter 0>");
                Container container = this.this$0.getComponent().getRootPane().getParent();
                Intrinsics.checkNotNullExpressionValue((Object)container, (String)"getParent(...)");
                WindowId windowId2 = this.$it.calculateClosestWindowsId(container);
                if (!(windowId2 instanceof WindowsWindowId)) {
                    return;
                }
                this.this$0.getRootWindowId().set((Object)((WindowsWindowId)windowId2).getPointer());
            }
        });
        winFormsEditor.wormhole = object;
        wormhole2 = object = new WinFormsDesignerComponent(this, this.getLifetime(), this.wormhole);
        winFormsEditor = this;
        bl = false;
        SourceExKt.flowInto((ISource)((ISource)((WinFormsDesignerComponent)((Object)wormhole2)).getFocused()), (Lifetime)this.getLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)this.focused));
        SourceExKt.flowInto((ISource)((ISource)this.focused), (Lifetime)this.getLifetime(), (IMutablePropertyBase)((IMutablePropertyBase)((WinFormsDesignerComponent)((Object)wormhole2)).getFocused()));
        winFormsEditor.editorComponent = object;
    }

    @NotNull
    public final String getFileId() {
        return this.fileId;
    }

    public final boolean getHasWindow() {
        return this.hasWindow;
    }

    @Nullable
    public final ExternalDesignerNotification getNotification() {
        return this.notification;
    }

    public final void setNotification(@Nullable ExternalDesignerNotification externalDesignerNotification) {
        this.notification = externalDesignerNotification;
    }

    @NotNull
    public final Signal<Unit> getReload() {
        return this.reload;
    }

    @NotNull
    public final Property<Boolean> getFocused() {
        return this.focused;
    }

    @NotNull
    public final Property<Long> getRootWindowId() {
        return this.rootWindowId;
    }

    @Nullable
    public final DesignerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public final void setDescriptor(@Nullable DesignerDescriptor designerDescriptor2) {
        this.descriptor = designerDescriptor2;
    }

    private final boolean j() {
        DesignerDescriptor designerDescriptor2 = this.descriptor;
        return designerDescriptor2 != null && designerDescriptor2.getWindowId().getValue() != null;
    }

    public final void embedExternalWindow(@NotNull WindowId id2) {
        Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
        if (this.hasWindow) {
            return;
        }
        this.j();
        this.hasWindow = true;
        this.wormhole.embed(id2);
        SwingUtilities.invokeLater(() -> WinFormsEditor.j(this));
    }

    public final void releaseExternalWindow() {
        if (!this.hasWindow) {
            return;
        }
        if (!this.editorComponent.isLoading()) {
            this.editorComponent.startLoading();
        }
        this.wormhole.release();
        this.hasWindow = false;
    }

    private final void j() {
        if (this.editorComponent.isLoading()) {
            this.editorComponent.stopLoading();
        }
    }

    public final void save() {
        WinFormsEditor.save$default(this, this.getLifetimeDefinition().createNested(), false, 2, null);
    }

    public final void save(@NotNull LifetimeDefinition taskLifetimeDefinition, boolean forceSaving) {
        Intrinsics.checkNotNullParameter((Object)taskLifetimeDefinition, (String)"taskLifetimeDefinition");
        if (!this.j()) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)taskLifetimeDefinition, (boolean)false, (int)1, null);
            return;
        }
        DesignerDescriptor designerDescriptor2 = this.descriptor;
        if (designerDescriptor2 == null) {
            return;
        }
        DesignerDescriptor designerDescriptor3 = designerDescriptor2;
        designerDescriptor3.getDesignerSaved().advise(taskLifetimeDefinition.getLifetime(), (Function1)new Function1<Unit, Unit>(taskLifetimeDefinition, this){
            final /* synthetic */ LifetimeDefinition $taskLifetimeDefinition;
            final /* synthetic */ WinFormsEditor this$0;
            {
                this.$taskLifetimeDefinition = $taskLifetimeDefinition;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$taskLifetimeDefinition, (boolean)false, (int)1, null);
                if (FileEditorManager.getInstance((Project)this.this$0.getProject()).isFileOpen(this.this$0.getFile())) {
                    DesignerUtils.INSTANCE.tryOpenEditor(this.this$0.getFile(), this.this$0.getProject(), WinFormsEditor.access$getProvider$p(this.this$0));
                }
            }
        });
        designerDescriptor3.getSaveDesigner().fire((Object)forceSaving);
    }

    public static /* synthetic */ void save$default(WinFormsEditor winFormsEditor, LifetimeDefinition lifetimeDefinition, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        winFormsEditor.save(lifetimeDefinition, bl);
    }

    @NotNull
    public JComponent getComponent() {
        return (JComponent)((Object)this.editorComponent);
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)((Object)this.editorComponent);
    }

    @NotNull
    public String getName() {
        return RiderDesignersBundle.Companion.message("SelectCustomAction.name.designer", new Object[0]);
    }

    @NotNull
    public VirtualFile getFile() {
        return this.targetFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isModified() {
        if (!this.j()) return false;
        DesignerDescriptor designerDescriptor2 = this.descriptor;
        Intrinsics.checkNotNull((Object)designerDescriptor2);
        if (designerDescriptor2.getState().getValue() != DesignerEditorState.Modified) return false;
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    public final void forceClose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
        Disposer.dispose((Disposable)((Disposable)this));
    }

    public void dispose() {
        if (!this.j()) {
            LifetimeDefinition.terminate$default((LifetimeDefinition)this.getLifetimeDefinition(), (boolean)false, (int)1, null);
            return;
        }
        this.save(this.getLifetimeDefinition(), true);
    }

    public final void showError() {
        this.editorComponent.markAsUnsupported();
    }

    private static final void j(WinFormsEditor winFormsEditor) {
        Intrinsics.checkNotNullParameter((Object)((Object)winFormsEditor), (String)"this$0");
        winFormsEditor.wormhole.revalidate();
        winFormsEditor.wormhole.repaint();
    }

    public static final /* synthetic */ WinFormsEditorProvider access$getProvider$p(WinFormsEditor $this) {
        return $this.provider;
    }
}

