/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.settingFiles.ui;

import com.intellij.openapi.ui.Messages;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.rider.RiderBundle;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.settingFiles.SettingModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/ui/NameColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/rider/designers/settingFiles/SettingModel;", "", "()V", "isCellEditable", "", "item", "setValue", "", "value", "valueOf", "intellij.rider"})
public final class NameColumn
extends ColumnInfo<SettingModel, String> {
    @NotNull
    public static final NameColumn INSTANCE = new NameColumn();

    private NameColumn() {
        super(RiderBundle.message("column.name.name", new Object[0]));
    }

    public boolean isCellEditable(@NotNull SettingModel item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return true;
    }

    @NotNull
    public String valueOf(@NotNull SettingModel item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getName();
    }

    public void setValue(@NotNull SettingModel item, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            Messages.showWarningDialog((String)RiderDesignersBundle.Companion.message("NameColumn.dialog.message.setting.name.can.not.be.empty", new Object[0]), (String)RiderDesignersBundle.Companion.message("NameColumn.dialog.title.can.not.rename.setting", new Object[0]));
            return;
        }
        if (!PathUtil.isValidFileName((String)value)) {
            Object[] objectArray = new Object[]{value};
            Messages.showWarningDialog((String)RiderDesignersBundle.Companion.message("NameColumn.dialog.message.setting.name.contains.invalid.characters", objectArray), (String)RiderDesignersBundle.Companion.message("NameColumn.dialog.title.can.not.rename.setting", new Object[0]));
            return;
        }
        if (!item.getOwner().isPossibleName(item, value)) {
            Object[] objectArray = new Object[]{value};
            Messages.showWarningDialog((String)RiderDesignersBundle.Companion.message("NameColumn.dialog.message.there.another.setting.with.name", objectArray), (String)RiderDesignersBundle.Companion.message("NameColumn.dialog.title.can.not.rename.setting", new Object[0]));
            return;
        }
        item.setName(value);
    }
}

