/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.settingFiles;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.GlobalUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel;
import com.jetbrains.rd.ide.model.RiderProjectDocumentOperationModel_PregeneratedKt;
import com.jetbrains.rd.ide.model.Solution;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rdclient.util.idea.DocumentUtilKt;
import com.jetbrains.rider.designers.RiderDesignersBundle;
import com.jetbrains.rider.designers.settingFiles.SettingModel;
import com.jetbrains.rider.designers.settingFiles.SettingsFileModel;
import com.jetbrains.rider.designers.settingFiles.SettingsTableFileEditor;
import com.jetbrains.rider.projectView.SolutionHostExtensionsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010#\u001a\u00020$J\f\u0010%\u001a\b\u0012\u0004\u0012\u00020$0&J\b\u0010'\u001a\u00020\u001cH\u0002J\n\u0010(\u001a\u0004\u0018\u00010\u001cH\u0002J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020$2\u0006\u0010,\u001a\u00020\u000eJ\u0006\u0010-\u001a\u00020*J\u000e\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020$J\u0006\u00100\u001a\u00020/R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/rider/designers/settingFiles/SettingsFileModel;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "document", "Lorg/jdom/Document;", "getDocument", "()Lorg/jdom/Document;", "setDocument", "(Lorg/jdom/Document;)V", "error", "", "getError", "()Ljava/lang/String;", "setError", "(Ljava/lang/String;)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "namespace", "Lorg/jdom/Namespace;", "getNamespace", "()Lorg/jdom/Namespace;", "getProject", "()Lcom/intellij/openapi/project/Project;", "root", "Lorg/jdom/Element;", "getRoot", "()Lorg/jdom/Element;", "setRoot", "(Lorg/jdom/Element;)V", "stamp", "", "add", "Lcom/jetbrains/rider/designers/settingFiles/SettingModel;", "createSettingModels", "", "j", "N", "isPossibleName", "", "model", "name", "reload", "remove", "", "write", "intellij.rider"})
@SourceDebugExtension(value={"SMAP\nSettingsFileModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsFileModel.kt\ncom/jetbrains/rider/designers/settingFiles/SettingsFileModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1549#2:203\n1620#2,3:204\n1549#2:207\n1620#2,3:208\n766#2:211\n857#2,2:212\n1549#2:214\n1620#2,3:215\n*S KotlinDebug\n*F\n+ 1 SettingsFileModel.kt\ncom/jetbrains/rider/designers/settingFiles/SettingsFileModel\n*L\n63#1:203\n63#1:204,3\n98#1:207\n98#1:208,3\n125#1:211\n125#1:212,2\n125#1:214\n125#1:215,3\n*E\n"})
public final class SettingsFileModel {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private org.jdom.Document document;
    @Nullable
    private Element root;
    @Nullable
    private String error;
    private long stamp;

    public SettingsFileModel(@NotNull Project project, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project;
        this.file = file2;
        this.stamp = -1L;
        this.reload();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    public final org.jdom.Document getDocument() {
        return this.document;
    }

    public final void setDocument(@Nullable org.jdom.Document document2) {
        this.document = document2;
    }

    @Nullable
    public final Element getRoot() {
        return this.root;
    }

    public final void setRoot(@Nullable Element element) {
        this.root = element;
    }

    @Nullable
    public final String getError() {
        return this.error;
    }

    public final void setError(@Nullable String string) {
        this.error = string;
    }

    @Nullable
    public final Namespace getNamespace() {
        org.jdom.Document document2 = this.document;
        return document2 != null && (document2 = document2.getRootElement()) != null ? document2.getNamespace() : null;
    }

    public final boolean reload() {
        if (this.file.getModificationStamp() == this.stamp) {
            return false;
        }
        this.document = null;
        this.root = null;
        this.error = null;
        try {
            Element element;
            org.jdom.Document document2 = new SAXBuilder().build(DocumentUtilKt.toIOFile((VirtualFile)this.file));
            Intrinsics.checkNotNull((Object)document2);
            org.jdom.Document document3 = this.document = document2;
            Object object = element = document3 != null ? document3.getRootElement() : null;
            if (element == null) {
                this.error = "'SettingsFile' root element is missing";
            } else if (!StringsKt.equals((String)element.getName(), (String)"SettingsFile", (boolean)true)) {
                this.error = "Root element should be 'SettingsFile' instead of '" + element.getName() + "'";
            } else {
                this.root = element;
            }
        }
        catch (Throwable throwable) {
            this.error = "Invalid settings file: " + throwable.getMessage();
        }
        this.stamp = this.file.getModificationStamp();
        return true;
    }

    @NotNull
    public final List<SettingModel> createSettingModels() {
        Collection collection;
        Object object = this.N();
        if (object != null && (object = object.getChildren("Setting", this.getNamespace())) != null) {
            Iterable iterable = (Iterable)object;
            boolean bl = false;
            Iterable iterable2 = iterable;
            collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
            boolean bl2 = false;
            for (Object t : iterable2) {
                Element element = (Element)t;
                Collection collection2 = collection;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)element);
                collection2.add(new SettingModel(this, element));
            }
        } else {
            return CollectionsKt.emptyList();
        }
        return (List)collection;
    }

    public final void write() {
        org.jdom.Document document2 = this.document;
        if (document2 == null) {
            return;
        }
        org.jdom.Document document3 = document2;
        ApplicationKt.getApplication().runWriteAction(() -> SettingsFileModel.j(this, document3));
    }

    @NotNull
    public final SettingModel add() {
        SettingModel settingModel;
        Object object3;
        Object object2 = this.createSettingModels();
        int n2 = 0;
        Iterable iterable = object2;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        boolean bl = false;
        for (Object object3 : iterable) {
            settingModel = (SettingModel)object3;
            Collection collection2 = collection;
            boolean bl2 = false;
            collection2.add(settingModel.getName());
        }
        HashSet hashSet = CollectionsKt.toHashSet((Iterable)((List)collection));
        object2 = null;
        object2 = "Setting";
        n2 = 1;
        while (hashSet.contains(object2)) {
            object2 = "Setting" + n2;
            ++n2;
        }
        Collection collection3 = collection = new Element("Setting", this.getNamespace());
        boolean bl3 = false;
        collection3.setAttribute("Name", (String)object2);
        collection3.setAttribute("Type", "System.String");
        collection3.setAttribute("Scope", "User");
        object3 = new Element("Value", collection3.getNamespace());
        settingModel = object3;
        Collection collection4 = collection3;
        boolean bl4 = false;
        settingModel.setAttribute("Profile", "(Default)");
        collection4.addContent((Element)object3);
        iterable = collection;
        this.j().addContent((Element)iterable);
        return new SettingModel(this, (Element)iterable);
    }

    public final void remove(@NotNull SettingModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        model2.getElement().detach();
        this.write();
    }

    public final boolean isPossibleName(@NotNull SettingModel model2, @NotNull String name) {
        boolean bl;
        SettingModel settingModel;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Iterable iterable = this.createSettingModels();
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        Collection collection = new ArrayList();
        boolean bl3 = false;
        for (Object t : iterable2) {
            settingModel = (SettingModel)t;
            bl = false;
            if (!(!Intrinsics.areEqual((Object)settingModel.getElement(), (Object)model2.getElement()))) continue;
            collection.add(t);
        }
        iterable = (List)collection;
        bl2 = false;
        iterable2 = iterable;
        collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        bl3 = false;
        for (Object t : iterable2) {
            settingModel = (SettingModel)t;
            Collection collection2 = collection;
            bl = false;
            collection2.add(settingModel.getName());
        }
        return !((List)collection).contains(name);
    }

    private final Element N() {
        Element element;
        Element element2 = this.root;
        if (element2 != null) {
            Element element3 = this.root;
            element = element2.getChild("Settings", (Namespace)(element3 != null ? element3.getNamespace() : null));
        } else {
            element = null;
        }
        return element;
    }

    private final Element j() {
        Element element = this.N();
        if (element != null) {
            return element;
        }
        Element element2 = this.root;
        Intrinsics.checkNotNull((Object)element2);
        Element element3 = new Element("Settings", element2.getNamespace());
        Element element4 = this.root;
        Intrinsics.checkNotNull((Object)element4);
        element4.addContent(element3);
        return element3;
    }

    private static final void j(org.jdom.Document document2, Document document3, FileDocumentManager fileDocumentManager, SettingsFileModel settingsFileModel) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"$document");
        Intrinsics.checkNotNullParameter((Object)document3, (String)"$fileDocument");
        Intrinsics.checkNotNullParameter((Object)fileDocumentManager, (String)"$manager");
        Intrinsics.checkNotNullParameter((Object)settingsFileModel, (String)"this$0");
        String string = JDOMUtil.writeDocument((org.jdom.Document)document2, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"writeDocument(...)");
        String string2 = string;
        document3.setText((CharSequence)string2);
        fileDocumentManager.saveDocument(document3);
        UndoManager undoManager = UndoManager.getInstance((Project)settingsFileModel.project);
        Document[] documentArray = new Document[]{document3};
        Document[] documentArray2 = documentArray;
        undoManager.undoableActionPerformed((UndoableAction)new GlobalUndoableAction(settingsFileModel, documentArray2){
            final /* synthetic */ SettingsFileModel this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1);
            }

            public void redo() {
                this.j();
            }

            public void undo() {
                this.j();
            }

            private final void j() {
                ApplicationKt.getApplication().invokeLater(() -> write.1.1.1.j(this.this$0));
            }

            private static final void j(SettingsFileModel settingsFileModel) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)settingsFileModel, (String)"this$0");
                    FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)settingsFileModel.getProject()).getAllEditors(settingsFileModel.getFile());
                    Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
                    Object[] objectArray = fileEditorArray;
                    boolean bl = false;
                    Object[] objectArray2 = objectArray;
                    Collection collection = new ArrayList<E>();
                    boolean bl2 = false;
                    for (Object object : objectArray2) {
                        if (!(object instanceof SettingsTableFileEditor)) continue;
                        collection.add(object);
                    }
                    SettingsTableFileEditor settingsTableFileEditor = (SettingsTableFileEditor)((Object)CollectionsKt.singleOrNull((List)((List)collection)));
                    if (settingsTableFileEditor == null) break block1;
                    settingsTableFileEditor.refresh();
                }
            }
        });
    }

    private static final void j(SettingsFileModel settingsFileModel, org.jdom.Document document2) {
        Intrinsics.checkNotNullParameter((Object)settingsFileModel, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"$document");
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
        FileDocumentManager fileDocumentManager2 = fileDocumentManager;
        Document document3 = fileDocumentManager2.getDocument(settingsFileModel.file);
        if (document3 == null) {
            return;
        }
        Document document4 = document3;
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        Project project = settingsFileModel.project;
        Runnable runnable = () -> SettingsFileModel.j(document2, document4, fileDocumentManager2, settingsFileModel);
        RiderProjectDocumentOperationModel riderProjectDocumentOperationModel = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)settingsFileModel.file.getName(), (String)"getName(...)");
        commandProcessor.executeCommand(project, runnable, RiderDesignersBundle.Companion.message("SettingsFileModel.command.name.update", (Object[])riderProjectDocumentOperationModel), null);
        settingsFileModel.stamp = settingsFileModel.file.getModificationStamp();
        riderProjectDocumentOperationModel = RiderProjectDocumentOperationModel_PregeneratedKt.getRiderProjectDocumentOperationModel((Solution)SolutionHostExtensionsKt.getSolution((Project)settingsFileModel.project));
        ISignal iSignal = riderProjectDocumentOperationModel.getAfterDocumentInEditorSaved();
        String string = settingsFileModel.file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        iSignal.fire((Object)string);
    }
}

