/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.designers.resx.grid.table;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.designers.resx.grid.data.OnDemandData;
import com.jetbrains.rider.designers.resx.grid.renderers.ResxEditor;
import com.jetbrains.rider.designers.resx.grid.renderers.ResxRenderer;
import com.jetbrains.rider.designers.resx.grid.table.EditingController;
import com.jetbrains.rider.designers.resx.grid.table.ResxController;
import com.jetbrains.rider.model.BeDataGrid;
import com.jetbrains.rider.model.BeDataGridCell;
import com.jetbrains.rider.model.BeDataGridRow;
import com.jetbrains.rider.model.BeDataGridRowCellPointer;
import java.awt.Component;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001-B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000b2\b\u0010(\u001a\u0004\u0018\u00010\fJ\u0018\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010+\u001a\u00020%J\u0016\u0010,\u001a\u00020%2\u0006\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\u000bR'\u0010\t\u001a\u001b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u000b\u0012\t\u0018\u00010\f\u00a2\u0006\u0002\b\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fRB\u0010\u0010\u001a6\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0012\u0012\u0004\u0012\u00020\f0\u0011j\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0012\u0012\u0004\u0012\u00020\f`\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006."}, d2={"Lcom/jetbrains/rider/designers/resx/grid/table/EditingController;", "", "controller", "Lcom/jetbrains/rider/designers/resx/grid/table/ResxController;", "onDemandData", "Lcom/jetbrains/rider/designers/resx/grid/data/OnDemandData;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "(Lcom/jetbrains/rider/designers/resx/grid/table/ResxController;Lcom/jetbrains/rider/designers/resx/grid/data/OnDemandData;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "checkEditing", "Lkotlin/Function2;", "", "", "Lcom/intellij/openapi/util/NlsSafe;", "getController", "()Lcom/jetbrains/rider/designers/resx/grid/table/ResxController;", "editingCells", "Ljava/util/HashMap;", "Lkotlin/Pair;", "Lkotlin/collections/HashMap;", "editingItem", "Lcom/jetbrains/rider/designers/resx/grid/table/EditingController$EditingItem;", "getEditingItem", "()Lcom/jetbrains/rider/designers/resx/grid/table/EditingController$EditingItem;", "setEditingItem", "(Lcom/jetbrains/rider/designers/resx/grid/table/EditingController$EditingItem;)V", "editor", "Lcom/jetbrains/rider/designers/resx/grid/renderers/ResxEditor;", "getEditor", "()Lcom/jetbrains/rider/designers/resx/grid/renderers/ResxEditor;", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "renderer", "Lcom/jetbrains/rider/designers/resx/grid/renderers/ResxRenderer;", "getRenderer", "()Lcom/jetbrains/rider/designers/resx/grid/renderers/ResxRenderer;", "editingStopped", "", "rowIndex", "columnIndex", "value", "getValueAt", "Lcom/jetbrains/rider/model/BeDataGridCell;", "reset", "startEditing", "EditingItem", "intellij.rider"})
public final class EditingController {
    @NotNull
    private final ResxController controller;
    @NotNull
    private final OnDemandData onDemandData;
    @NotNull
    private final Lifetime lifetime;
    @Nullable
    private EditingItem editingItem;
    @NotNull
    private HashMap<Pair<Integer, Integer>, String> editingCells;
    @NotNull
    private final Function2<Integer, Integer, String> checkEditing;
    @NotNull
    private final ResxRenderer renderer;
    @NotNull
    private final ResxEditor editor;

    public EditingController(@NotNull ResxController controller, @NotNull OnDemandData onDemandData, @NotNull Lifetime lifetime2) {
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)onDemandData, (String)"onDemandData");
        Intrinsics.checkNotNullParameter((Object)lifetime2, (String)"lifetime");
        this.controller = controller;
        this.onDemandData = onDemandData;
        this.lifetime = lifetime2;
        this.editingCells = new HashMap();
        this.checkEditing = (Function2)new Function2<Integer, Integer, String>(this){
            final /* synthetic */ EditingController this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final String invoke(int row, int cell) {
                return (String)EditingController.access$getEditingCells$p(this.this$0).get(new Pair((Object)row, (Object)cell));
            }
        };
        this.renderer = new ResxRenderer(this.checkEditing, (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditingController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    BeDataGridRowCellPointer beDataGridRowCellPointer = (BeDataGridRowCellPointer)EditingController.access$getOnDemandData$p(this.this$0).getViewModel().getCurrentCell().getValueOrNull();
                    if (beDataGridRowCellPointer == null) break block0;
                    BeDataGridRowCellPointer beDataGridRowCellPointer2 = beDataGridRowCellPointer;
                    EditingController editingController = this.this$0;
                    BeDataGridRowCellPointer beDataGridRowCellPointer3 = beDataGridRowCellPointer2;
                    boolean bl = false;
                    EditingController.access$getOnDemandData$p(editingController).tryOpenItem(beDataGridRowCellPointer3);
                }
            }
        }));
        Function2<Integer, Integer, String> function2 = this.checkEditing;
        BeDataGrid beDataGrid = this.onDemandData.getViewModel();
        this.editor = new ResxEditor(this, function2, beDataGrid){
            @Nullable
            private Disposable disposable;
            final /* synthetic */ EditingController this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            @NotNull
            public Component getTableCellEditorComponent(@NotNull JTable table2, @Nullable Object value, boolean isSelected, int row, int column) {
                Intrinsics.checkNotNullParameter((Object)table2, (String)"table");
                this.this$0.startEditing(row, column);
                this.disposable = () -> editor.1.j(this.this$0, this);
                return super.getTableCellEditorComponent(table2, value, isSelected, row, column);
            }

            public boolean stopCellEditing() {
                block0: {
                    Disposable disposable = this.disposable;
                    if (disposable == null) break block0;
                    disposable.dispose();
                }
                return super.stopCellEditing();
            }

            public void cancelCellEditing() {
                Disposable disposable = this.disposable;
                if (disposable != null) {
                    disposable.dispose();
                }
                super.cancelCellEditing();
            }

            private static final void j(EditingController editingController, editor.1 var1_1) {
                Intrinsics.checkNotNullParameter((Object)editingController, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)((Object)var1_1), (String)"this$1");
                editingController.setEditingItem(null);
                var1_1.disposable = null;
            }
        };
    }

    @NotNull
    public final ResxController getController() {
        return this.controller;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @Nullable
    public final EditingItem getEditingItem() {
        return this.editingItem;
    }

    public final void setEditingItem(@Nullable EditingItem editingItem) {
        this.editingItem = editingItem;
    }

    @NotNull
    public final ResxRenderer getRenderer() {
        return this.renderer;
    }

    @NotNull
    public final ResxEditor getEditor() {
        return this.editor;
    }

    public final void reset() {
        this.editor.cancelCellEditing();
        this.editingCells.clear();
    }

    @Nullable
    public final BeDataGridCell getValueAt(int rowIndex, int columnIndex) {
        EditingItem editingItem = this.editingItem;
        if (editingItem != null) {
            EditingItem editingItem2 = editingItem;
            boolean bl = false;
            if (rowIndex == editingItem2.getRowIndex()) {
                return (BeDataGridCell)CollectionsKt.getOrNull((List)editingItem2.getItem().getCells(), (int)columnIndex);
            }
        }
        return null;
    }

    public final void startEditing(int rowIndex, int columnIndex) {
        EditingItem editingItem;
        EditingController editingController = this;
        BeDataGridRow beDataGridRow = this.onDemandData.getRange().get(rowIndex);
        if (beDataGridRow != null) {
            BeDataGridRow beDataGridRow2 = beDataGridRow;
            EditingController editingController2 = editingController;
            boolean bl = false;
            editingItem = new EditingItem(rowIndex, columnIndex, beDataGridRow2);
            editingController = editingController2;
        } else {
            editingItem = null;
        }
        editingController.editingItem = editingItem;
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ EditingController this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                this.this$0.getController().getComponent().getSelectionController().getCompositeTable().clearSelection();
            }
        }), (int)1, null);
    }

    public final void editingStopped(int rowIndex, int columnIndex, @Nullable String value) {
        if (!Intrinsics.areEqual((Object)value, (Object)this.editor.getCellEditorValue())) {
            ((Map)this.editingCells).put(new Pair((Object)rowIndex, (Object)columnIndex), this.editor.getCellEditorValue());
            this.onDemandData.commitValue(rowIndex, columnIndex, this.editor.getCellEditorValue(), (Function0<Unit>)((Function0)new Function0<Unit>(this, rowIndex, columnIndex){
                final /* synthetic */ EditingController this$0;
                final /* synthetic */ int $rowIndex;
                final /* synthetic */ int $columnIndex;
                {
                    this.this$0 = $receiver;
                    this.$rowIndex = $rowIndex;
                    this.$columnIndex = $columnIndex;
                    super(0);
                }

                public final void invoke() {
                    EditingController.access$getEditingCells$p(this.this$0).remove(new Pair((Object)this.$rowIndex, (Object)this.$columnIndex));
                }
            }));
        }
    }

    public static final /* synthetic */ HashMap access$getEditingCells$p(EditingController $this) {
        return $this.editingCells;
    }

    public static final /* synthetic */ OnDemandData access$getOnDemandData$p(EditingController $this) {
        return $this.onDemandData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/designers/resx/grid/table/EditingController$EditingItem;", "", "rowIndex", "", "columnIndex", "item", "Lcom/jetbrains/rider/model/BeDataGridRow;", "(IILcom/jetbrains/rider/model/BeDataGridRow;)V", "getColumnIndex", "()I", "getItem", "()Lcom/jetbrains/rider/model/BeDataGridRow;", "getRowIndex", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.rider"})
    public static final class EditingItem {
        private final int rowIndex;
        private final int columnIndex;
        @NotNull
        private final BeDataGridRow item;

        public EditingItem(int rowIndex, int columnIndex, @NotNull BeDataGridRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            this.rowIndex = rowIndex;
            this.columnIndex = columnIndex;
            this.item = item;
        }

        public final int getRowIndex() {
            return this.rowIndex;
        }

        public final int getColumnIndex() {
            return this.columnIndex;
        }

        @NotNull
        public final BeDataGridRow getItem() {
            return this.item;
        }

        public final int component1() {
            return this.rowIndex;
        }

        public final int component2() {
            return this.columnIndex;
        }

        @NotNull
        public final BeDataGridRow component3() {
            return this.item;
        }

        @NotNull
        public final EditingItem copy(int rowIndex, int columnIndex, @NotNull BeDataGridRow item) {
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            return new EditingItem(rowIndex, columnIndex, item);
        }

        public static /* synthetic */ EditingItem copy$default(EditingItem editingItem, int n2, int n3, BeDataGridRow beDataGridRow, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n2 = editingItem.rowIndex;
            }
            if ((n4 & 2) != 0) {
                n3 = editingItem.columnIndex;
            }
            if ((n4 & 4) != 0) {
                beDataGridRow = editingItem.item;
            }
            return editingItem.copy(n2, n3, beDataGridRow);
        }

        @NotNull
        public String toString() {
            return "EditingItem(rowIndex=" + this.rowIndex + ", columnIndex=" + this.columnIndex + ", item=" + this.item + ")";
        }

        public int hashCode() {
            int n2 = Integer.hashCode(this.rowIndex);
            n2 = n2 * 31 + Integer.hashCode(this.columnIndex);
            n2 = n2 * 31 + this.item.hashCode();
            return n2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EditingItem)) {
                return false;
            }
            EditingItem editingItem = (EditingItem)other;
            if (this.rowIndex != editingItem.rowIndex) {
                return false;
            }
            if (this.columnIndex != editingItem.columnIndex) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.item, (Object)editingItem.item);
        }
    }
}

